/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.gui.value.ConstValEditor;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;

public class MultiValEditor<T>
extends AValEditor<T> {
    private static final long serialVersionUID = -3861213307843638199L;
    private static final String TYPE_MIXED = Intl.intl("<mixed>");
    private final CardLayout d_cards;
    private final guiComboBox<Object> d_cbType;
    private final guiPanel d_editorPanel;
    private final Map<Object, Entry<T, ? extends T>> d_entries;
    private Object d_lastOpt;
    private boolean d_inlinePref;
    private final Semaphore d_comboSelLock = new Semaphore(1);
    private final PropertyChangeListener d_valChangedListener;

    public MultiValEditor(Class<T> type, Entry<T, ? extends T> ... editors) {
        this(type, Arrays.asList(editors), false);
    }

    public MultiValEditor(Class<T> type, Collection<Entry<T, ? extends T>> editors, boolean inline) {
        super(type);
        assert (editors.stream().allMatch(entry -> entry.editor == null || entry.editor.isLive()));
        this.d_entries = new LinkedHashMap<Object, Entry<T, ? extends T>>(editors.size());
        for (Entry<T, T> entry2 : editors) {
            this.d_entries.put(entry2.key, entry2);
        }
        this.d_inlinePref = inline;
        ArrayList<Object> keys = new ArrayList<Object>(this.d_entries.keySet());
        if (editors.size() > 1) {
            Entry<Object, Object> entry3 = new Entry<Object, Object>(TYPE_MIXED, Intl.intl("Selection is mixed."), new EmptyEditor<T>(type), obj -> obj == null, () -> true, obj -> obj);
            this.d_entries.put(entry3.key, entry3);
        }
        this.d_cbType = new guiComboBox<Object>((Collection<Object>)keys);
        this.d_cards = new ResizeableCardLayout();
        this.d_editorPanel = new guiPanel(this.d_cards);
        this.d_entries.values().forEach(p -> {
            JComponent comp = p.editor.getComponent();
            String str = p.key.toString();
            this.d_editorPanel.add((Component)comp, str);
        });
        this.d_valChangedListener = e -> {
            if (this.d_comboSelLock.tryAcquire()) {
                this.updateValue();
                this.d_comboSelLock.release();
            }
        };
        this.d_cbType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3269152420596074021L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Entry entry = MultiValEditor.this.d_entries.get(value);
                String tt = entry != null ? entry.tooltip : null;
                this.setToolTipText(tt);
                return comp;
            }
        });
        this.d_cbType.addActionListener(e -> {
            Object sel = this.d_cbType.getSelectedItem();
            if (sel == null) {
                sel = TYPE_MIXED;
            }
            this.showCard(sel);
        });
        ActionListener actionListener = e -> {
            if (!this.d_comboSelLock.tryAcquire()) {
                return;
            }
            Object sel = this.d_cbType.getSelectedItem();
            Entry<T, ? extends T> entry = this.d_entries.get(sel);
            assert (entry != null);
            SwingUtilities.invokeLater(() -> {
                if (this.d_comboSelLock.tryAcquire()) {
                    Object newValue = entry.converter.apply(this.getValue());
                    entry.editor.setValue(newValue);
                    if (entry.init.getAsBoolean()) {
                        this.updateValue();
                        this.updateListeners(sel);
                    } else {
                        this.selectOption(this.d_lastOpt);
                    }
                    this.d_comboSelLock.release();
                }
            });
            this.d_comboSelLock.release();
        };
        this.d_lastOpt = editors.size() > 1 ? TYPE_MIXED : editors.iterator().next().key;
        this.d_cbType.addActionListener(actionListener);
        GridBagHelper gb = new GridBagHelper(this, false);
        this.add(gb);
        gb.finalizeRows();
        this.loadValue(this.getValue());
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        if (this.d_entries.size() > 1) {
            this.addTwoComps(gb, true);
        } else {
            gb.addRow(this.d_editorPanel, 1, 1.0);
        }
    }

    public void addTwoComps(GridBagHelper gb, boolean fill) {
        if (!this.d_inlinePref) {
            if (fill) {
                gb.addRow(new Object[]{this.d_cbType, GridBagHelper.Anchor.TOP, GridBagHelper.Fill.HORIZONTAL, this.d_editorPanel, GridBagHelper.Fill.HORIZONTAL});
            } else {
                gb.addRow(new Object[]{this.d_cbType, GridBagHelper.Anchor.TOP, GridBagHelper.Fill.HORIZONTAL, this.d_editorPanel});
            }
        } else {
            gb.addRow(this.d_cbType);
            gb.addFilledRow(new JSeparator());
            gb.addRow(this.d_editorPanel, 1.0, new int[]{2, 1});
        }
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
    }

    @Override
    protected T saveValue(Mediator mediator) {
        Object sel = this.d_cbType.getSelectedItem();
        Entry<T, ? extends T> entry = this.d_entries.get(sel);
        if (entry == null) {
            return null;
        }
        return (T)entry.editor.getValue();
    }

    @Override
    protected void loadValue(T value) {
        if (this.d_comboSelLock.tryAcquire()) {
            Object newOpt = this.d_lastOpt;
            for (Map.Entry<Object, Entry<T, T>> mentry : this.d_entries.entrySet()) {
                Entry<T, ? extends T> entry = mentry.getValue();
                IValEditor editor = mentry.getValue().editor;
                if (value != null && !editor.getType().isInstance(value) || !entry.filter.test(editor.getType().cast(value))) continue;
                newOpt = mentry.getKey();
                break;
            }
            this.selectOption(newOpt);
            if (newOpt.equals(TYPE_MIXED)) {
                this.showCard(TYPE_MIXED);
            }
            this.updateListeners(newOpt);
            this.d_comboSelLock.release();
        }
    }

    private void selectOption(Object opt) {
        if (opt.equals(TYPE_MIXED)) {
            this.d_cbType.setSelectedIndex(-1);
        } else {
            this.d_cbType.setSelectedItem(opt);
        }
    }

    private void updateListeners(Object newOpt) {
        this.d_entries.get((Object)this.d_lastOpt).editor.removeValueListener(this.d_valChangedListener);
        Entry<T, ? extends T> entry = this.d_entries.get(newOpt);
        entry.editor.setValue(entry.converter.apply(this.getValue()));
        entry.editor.addValueListener(this.d_valChangedListener);
        this.d_lastOpt = newOpt;
    }

    private void showCard(Object sel) {
        this.d_cards.show(this.d_editorPanel, sel.toString());
        Entry<T, ? extends T> entry = this.d_entries.get(sel);
        String tt = entry != null ? entry.tooltip : null;
        this.d_cbType.setToolTipText(tt);
        Window window = SwingUtilities.windowForComponent(this.d_cbType);
        if (window != null && !(window instanceof Frame)) {
            EventQueue.invokeLater(() -> window.pack());
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.d_cbType.setEnabled(enable);
        this.d_editorPanel.setEnabled(enable);
    }

    public guiComboBox<Object> getComboBox() {
        return this.d_cbType;
    }

    public guiPanel getEditor() {
        return this.d_editorPanel;
    }

    public static class Entry<T, T2 extends T> {
        public final Object key;
        public final String tooltip;
        public final IValEditor<T2> editor;
        public final Predicate<T2> filter;
        public final Function<T, T2> converter;
        public final BooleanSupplier init;

        public Entry(Object key, String tooltip, IValEditor<T2> editor, Predicate<T2> filter, BooleanSupplier init, Function<T, T2> converter) {
            this.key = key;
            this.tooltip = tooltip;
            this.editor = editor;
            this.filter = filter;
            this.converter = converter;
            this.init = init;
        }

        public Entry(Object key, String tooltip, Class<T2> type, T2 value) {
            this(key, tooltip, new ConstValEditor<T2>(type, value), v -> Objects.equals(v, value), () -> true, tags -> value);
        }
    }

    public static class EmptyEditor<T>
    extends guiPanel
    implements IValEditor<T> {
        private static final long serialVersionUID = -1836083094581335712L;
        private final Class<T> d_type;
        private T d_val;

        public EmptyEditor(Class<T> type) {
            this.d_type = type;
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public String formatNonLiveValue() {
            return "";
        }

        @Override
        public <DomainT extends Mediator> T commit(DomainT domain) {
            this.setModified(false);
            return this.getValue();
        }

        @Override
        public void add(GridBagHelper gb) {
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public T getValue() {
            return this.d_val;
        }

        @Override
        public void setValue(T value) {
            this.d_val = value;
        }
    }

    private static class ResizeableCardLayout
    extends CardLayout {
        private static final long serialVersionUID = 229534264878055140L;

        private ResizeableCardLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component current = this.findCurrentComponent(parent);
            if (current != null) {
                Insets insets = parent.getInsets();
                Dimension pref = current.getPreferredSize();
                pref.width += insets.left + insets.right;
                pref.height += insets.top + insets.bottom;
                return pref;
            }
            return super.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Component findCurrentComponent(Container parent) {
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                return comp;
            }
            return null;
        }
    }
}

