/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;
import merlin.gui.value.DefaultVarEditorPnl;
import merlin.gui.value.IVariantEditor;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;

public class DiscreteVarEditor<ValType>
implements IVariantEditor<ValType> {
    private final Map<ValType, String> d_vals;

    public DiscreteVarEditor(Object ... args) {
        this(DiscreteVarEditor.toMap(args));
    }

    public DiscreteVarEditor(Map<ValType, String> vals) {
        this.d_vals = vals;
    }

    private static <ValType> Map<ValType, String> toMap(Object ... args) {
        assert (args.length % 2 == 0);
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        int m = 0;
        while (m < args.length) {
            Object val = args[m++];
            String alias = (String)args[m++];
            map.put(val, alias);
        }
        return map;
    }

    @Override
    public String describe(IVariant<ValType> variant) {
        return VariantUtil.describeVariant(variant, val -> this.d_vals.get(val));
    }

    @Override
    public guiPanel getEditorPanel(IUnitSrc timeUnit) {
        return DefaultVarEditorPnl.newPnl(timeUnit, this.d_vals, Collections.emptyList());
    }

    @Override
    public void load(guiPanel editorPanel, IVariant<ValType> variant) {
        DefaultVarEditorPnl pnl = (DefaultVarEditorPnl)editorPanel;
        pnl.load(variant);
    }

    @Override
    public IVariant<ValType> save(guiPanel editorPanel) {
        DefaultVarEditorPnl pnl = (DefaultVarEditorPnl)editorPanel;
        return pnl.save();
    }
}

