/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.function.Predicate;
import java.util.function.Supplier;
import merlin.Intl;
import merlin.gui.MerlinValueFields;
import merlin.gui.value.EditValDlg;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.UniformCurve;

public class UniformEditor
extends AValEditor<UniformCurve> {
    private static final long serialVersionUID = -1890725361403928839L;
    public ValueField<UnitDouble> d_min;
    public ValueField<UnitDouble> d_max;

    public UniformEditor(int unitType) {
        this(unitType, UnitDoubleVR.above(0.0, SIUS.unit(unitType), true));
    }

    public UniformEditor(int unitType, UnitDoubleVR range) {
        super(UniformCurve.class);
        Supplier<ValueField> fieldFactory = () -> this.registerEd(MerlinValueFields.udFld(SIUS.newud(0.0, unitType), (Predicate<UnitDouble>)range, unitType));
        this.d_min = fieldFactory.get();
        this.d_max = fieldFactory.get();
        GridBagHelper gb = new GridBagHelper(this, false);
        gb.addRow(Intl.intl("Min:"), this.d_min, Intl.intl("Max:"), this.d_max);
        gb.finalizeRows();
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public UniformCurve saveValue(Mediator mediator) {
        return new UniformCurve((UnitDouble)this.d_min.getValue(), (UnitDouble)this.d_max.getValue());
    }

    @Override
    public void loadValue(UniformCurve uc) {
        this.d_min.setValue(uc.getMin());
        this.d_max.setValue(uc.getMax());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        double v2;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        UnitDouble min = (UnitDouble)this.d_min.getValue();
        UnitDouble max = (UnitDouble)this.d_max.getValue();
        Unit u = min.getUnit();
        double v1 = min.getValue(u);
        if (v1 > (v2 = max.getValue(u))) {
            if (showWarn) {
                EditValDlg.showInvalidEntryMessage(this, Intl.intl("Req: Min <= Max"));
            }
            return false;
        }
        return true;
    }
}

