/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.labels;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.data.ICompElement;
import merlin.data.property.IDisplayProp;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.ScenarioComp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.util.Pair;

public interface IScenarioLabelGenerator
extends ILabelGenerator {
    default public boolean getInteractable() {
        return true;
    }

    public Collection<? extends ICompElement> getSelection();

    public Boolean getState(Collection<Object> var1);

    public void applyOverride(Collection<? extends IDisplayProp<?>> var1, boolean var2);

    default public <T> ScenarioComp<guiComboBox<T>> combo(final Function<T, Pair<String, String>> formatter, Collection<T> items, Set<Object> props) {
        final guiComboBox combo = new guiComboBox<T>(items){
            private static final long serialVersionUID = 1L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.isShiftDown()) {
                    if (e.getID() == 500 && e.getButton() == 1) {
                        super.processMouseEvent(e);
                        return;
                    } else {
                        if (e.getID() != 504 && e.getID() != 505) return;
                        super.processMouseEvent(e);
                    }
                    return;
                } else {
                    super.processMouseEvent(e);
                }
            }
        };
        combo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Pair<String, Object> desc = value != null ? (Pair)formatter.apply(value) : new Pair<String, Object>("", null);
                this.setText((String)desc.v1);
                if (desc.v2 != null && !((String)desc.v2).isEmpty()) {
                    combo.setToolTipText((String)desc.v2);
                    this.setToolTipText((String)desc.v2);
                } else {
                    combo.setToolTipText(null);
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        return new ScenarioComp<guiComboBox<T>>(combo, this, props);
    }

    default public <PropT> ScenarioComp<guiLabel> lbl(PropT prop, String label, String tooltip) {
        guiLabel lbl = new guiLabel(label);
        lbl.setToolTipText(guiUtil.encodeToHtmlLabel(tooltip));
        return new ScenarioComp<guiLabel>(lbl, this, Set.of(prop));
    }

    default public ScenarioComp<guiLabel> lbl(String text, String tooltip, Set<Object> props) {
        guiLabel lbl = new guiLabel(text);
        if (!tooltip.isEmpty()) {
            lbl.setToolTipText(guiUtil.encodeToHtmlLabel(tooltip));
        }
        return new ScenarioComp<guiLabel>(lbl, this, props);
    }

    default public ScenarioComp<guiMultiStateCheckBox> checkbox(String text, String tooltip, IDisplayProp<?> prop) {
        guiMultiStateCheckBox checkbox = new guiMultiStateCheckBox(text){
            private static final long serialVersionUID = 1L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.isShiftDown()) {
                    if (e.getID() == 500 && e.getButton() == 1) {
                        super.processMouseEvent(e);
                        return;
                    } else {
                        if (e.getID() != 504 && e.getID() != 505) return;
                        super.processMouseEvent(e);
                    }
                    return;
                } else {
                    super.processMouseEvent(e);
                }
            }
        };
        if (!tooltip.isEmpty()) {
            checkbox.setToolTipText(guiUtil.encodeToHtmlLabel(tooltip));
        }
        return new ScenarioComp<guiMultiStateCheckBox>(checkbox, this, Set.of(prop));
    }
}

