/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.treeview.TVEntryPoint;
import merlin.treeview.Util;
import merlin.unitsystem.UnitSystem;
import merlin.util.ILabeledEnum;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class guiUtil
extends thunderheadeng.gui.guiUtil {
    public static final int ICON_HEIGHT = 16;
    private static final ErrorIconSet s_warningIcon = new ErrorIconSet("warn16.gif", "warn8.gif");
    private static final ErrorIconSet s_errorIcon = new ErrorIconSet("error16.gif", "error8.gif");

    public static String getFileNameNoExt(String filename) {
        int extix = filename.lastIndexOf(46);
        if (extix < 0) {
            return filename;
        }
        return filename.substring(0, extix);
    }

    public static ImageIcon loadMerlinIcon(String name) {
        return guiUtil.loadMerlinIcon(name, -1);
    }

    public static ImageIcon loadMerlinIcon(String name, int maxDimension) {
        return guiUtil.loadIcon("merlin/icons/" + name, maxDimension);
    }

    public static Cursor createMerlinCursor(String key, String filename, int hotspotx, int hotspoty) {
        return guiUtil.createCursor(key, "merlin/icons/" + filename, hotspotx, hotspoty);
    }

    public static void addSelectableMenuItem(JMenu menu, SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.addItemListener(action);
        menu.add(item);
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction action) {
        JToggleButton button = new JToggleButton(action);
        guiUtil.initToolbarBtn(action, button);
        button.addItemListener(action);
        return button;
    }

    public static JButton createToolbarButton(Action action) {
        JButton btn = new JButton(action);
        guiUtil.initToolbarBtn(action, btn);
        return btn;
    }

    private static void initToolbarBtn(Action action, AbstractButton btn) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            btn.setText("");
            String ttt = (String)action.getValue("ShortDescription");
            if (ttt == null || ttt.trim().equals("")) {
                btn.setToolTipText((String)action.getValue("Name"));
            }
        }
    }

    public static void addMEMenuItems(JMenu menu, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            SelectableAction action = actions[m];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.addItemListener(action);
            menu.add(item);
            group.add(item);
        }
    }

    public static void addMEToolbarItems(JToolBar tb, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            JToggleButton item = guiUtil.createToolbarToggleButton(actions[m]);
            tb.add(item);
            group.add(item);
        }
    }

    public static Icon createDisabledIcon(Icon i, Component c) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)i).getImage()));
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        i.paintIcon(c, g, 0, 0);
        g.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bi));
    }

    public static Icon[] decorateIcons(MerlinData md, TVEntryPoint<Object> tvep, Runnable redecorate, Component comp, IMerlinObj obj, Collection<? extends SimError> errors) {
        Icon[] baseIcons = tvep.getIcons(md, comp, obj, redecorate);
        if (errors.isEmpty()) {
            return baseIcons;
        }
        ErrorIconSet icons = guiUtil.chooseErrorIcons(errors);
        return new Icon[]{baseIcons[0] != null ? new DecoratedIcon(baseIcons[0], icons.decorator, 3) : icons.icon, baseIcons[1] != null ? new DecoratedIcon(baseIcons[1], icons.decorator, 3) : icons.icon};
    }

    private static ErrorIconSet chooseErrorIcons(Collection<? extends SimError> errors) {
        SimError.Level maxLevel = SimError.Level.MODERATE;
        for (SimError simError : errors) {
            if (simError.level.severity <= maxLevel.severity) continue;
            maxLevel = simError.level;
        }
        return maxLevel == SimError.Level.MODERATE ? s_warningIcon : s_errorIcon;
    }

    public static boolean decorateComboRenderer(MerlinData data, JComboBox<?> cb, JList<?> list, Object value, JLabel c, boolean isSelected, boolean cellHasFocus, boolean includeIcon) {
        Runnable redecorate = () -> {
            cb.repaint();
            list.repaint();
        };
        return guiUtil.decorateCellRenderer(data, redecorate, value, c, isSelected, cellHasFocus, includeIcon, true);
    }

    public static boolean decorateCellRenderer(MerlinData data, Runnable redecorate, Object value, JLabel c, boolean isSelected, boolean cellHasFocus, boolean includeIcon, boolean decreaseMargin) {
        try (MerlinData.ReadLock lock = data.lockRead();){
            if (value instanceof IMerlinObj) {
                TVEntryPoint<Object> ep = Util.getEP(value);
                IMerlinObj obj = (IMerlinObj)value;
                c.setText(ep.getName(data, obj));
                c.setFont(ep.getFont(data, obj));
                c.setEnabled(ep.isVisible(data, obj));
                Collection errors = MerlinApp.getGlobalErrors().map(analysis -> analysis.getCollapsedErrors(obj)).orElse(List.of());
                if (includeIcon) {
                    Icon[] decorators = guiUtil.decorateIcons(data, ep, redecorate, c, obj, errors);
                    c.setIcon(decorators[0]);
                    c.setDisabledIcon(decorators[1]);
                }
                c.setToolTipText(guiUtil.formatErrors(errors));
                if (decreaseMargin) {
                    c.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static String formatErrors(Collection<? extends SimError> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        Object msg = "";
        for (SimError simError : errors) {
            if (simError.cause.isEmpty()) continue;
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + "<br>";
            }
            if (simError.level == SimError.Level.CRITICAL) {
                msg = (String)msg + String.format("<b>%s</b>", simError.format());
                continue;
            }
            msg = (String)msg + simError.format();
        }
        if (((String)msg).isEmpty()) {
            return null;
        }
        return "<html>" + (String)msg + "</html>";
    }

    public static String format(UnitDouble ud) {
        int type = UnitSystem.getType(ud.getUnit());
        return guiUtil.format(ud, type);
    }

    public static String format(UnitDouble ud, int unitType) {
        if (unitType == -1) {
            unitType = UnitSystem.getType(ud.getUnit());
        }
        if (unitType == -1) {
            return Global.format(ud);
        }
        UnitSystem us = MerlinApp.getApp().getUnitSystem();
        Unit unit = us.getUnit(unitType);
        return Global.format(ud.convert(unit));
    }

    public static String format(UnitDouble ud, UnaryOperator<Unit> getDisplayUnit) {
        Unit unit = (Unit)getDisplayUnit.apply(ud.getUnit());
        return Global.format(ud.convert(unit));
    }

    public static void setLongTooltip(JComponent component, String text) {
        text = ((String)text).replace("\n", "<br>");
        text = "<html>" + (String)text + "</html>";
        component.setToolTipText((String)text);
    }

    public static int getWrappedLines(JTextComponent component) {
        int lines = 0;
        View view = component.getUI().getRootView(component).getView(0);
        int paragraphs = view.getViewCount();
        for (int i = 0; i < paragraphs; ++i) {
            lines += view.getView(i).getViewCount();
        }
        return lines;
    }

    public static <T extends Enum<T>> guiComboBox<T> newEnumCombo(Class<T> clazz) {
        return guiUtil.newEnumCombo(clazz, Intl.intl("<mixed>"));
    }

    public static <T extends Enum<T>> guiComboBox<T> newEnumCombo(Class<T> clazz, String nullLabel) {
        return guiUtil.newEnumCombo(clazz, Predicates.alwaysTrue(), nullLabel);
    }

    public static <T extends Enum<T>> guiComboBox<T> newEnumCombo(Class<T> clazz, Predicate<? super T> filter, String nullLabel) {
        return guiUtil.newCombo((? super T v) -> {
            if (v == null) {
                return new Pair<String, Object>(nullLabel, null);
            }
            if (v instanceof ILabeledEnum) {
                ILabeledEnum le = (ILabeledEnum)((Object)v);
                return guiUtil.encodeToHtmlLabel(le.getName(), le.getDescription());
            }
            if (v instanceof INamed) {
                return new Pair<String, Object>(((INamed)((Object)v)).getName(), null);
            }
            return new Pair<String, Object>(v.name(), null);
        }, theUtil.filter(Arrays.asList((Enum[])clazz.getEnumConstants()), filter));
    }

    public static Pair<String, String> encodeToHtmlLabels(String str1, String str2) {
        return new Pair<String, String>(guiUtil.encodeToHtmlLabel(str1), guiUtil.encodeToHtmlLabel(str2));
    }

    public static Window getWindow(Component c) {
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static <T> guiComboBox<T> newCombo(T item1, String label1, Object ... args) {
        assert (args.length % 2 == 0);
        ArrayList items = new ArrayList();
        final HashMap labels = new HashMap();
        BiConsumer<Object, String> add = (item, label) -> {
            items.add(item);
            labels.put(item, label);
        };
        add.accept(item1, label1);
        int m = 0;
        while (m < args.length) {
            Object item2 = args[m++];
            String label2 = (String)args[m++];
            add.accept(item2, label2);
        }
        guiComboBox<Object> result = new guiComboBox<Object>(items);
        result.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText((String)labels.get(value));
                return this;
            }
        });
        return result;
    }

    public static Pair<guiRadioButton, guiRadioButton> createPlacementButtons() {
        guiRadioButton d_uniformRB = new guiRadioButton(Intl.intl("Uniform (hex grid)"), false);
        d_uniformRB.setToolTipText(Intl.intl("Places occupants uniformly in a hexagonal grid pattern."));
        guiRadioButton d_randomRB = new guiRadioButton(Intl.intl("Random"), true);
        d_randomRB.setToolTipText(Intl.intl("Places occupants randomly in the space."));
        guiUtil.group(new AbstractButton[]{d_uniformRB, d_randomRB});
        return new Pair<guiRadioButton, guiRadioButton>(d_uniformRB, d_randomRB);
    }

    public static Color getActiveColor() {
        return MerlinApp.getApp().getData().scenarios.getActive().getColor();
    }

    private static class ErrorIconSet {
        public final Icon icon;
        public final Icon decorator;

        public ErrorIconSet(String iconName16, String iconName8) {
            this.icon = guiUtil.loadMerlinIcon(iconName16);
            this.decorator = guiUtil.loadMerlinIcon(iconName8);
        }
    }
}

