/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.agents;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import merlin.EntryPointFactory;
import merlin.MerlinApp;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.gui.filter.ObjRestrictionEditorComponents;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class CompRestrictionsPanel {
    private final List<CompRestriction> d_allRestrictions = new ArrayList<CompRestriction>();

    public CompRestrictionsPanel(MerlinData md, ILabelGenerator overrideCallback) {
        for (OccProfile.CompRestrictions.Type type : OccProfile.CompRestrictions.Type.values()) {
            CompRestriction chooser = new CompRestriction(md, type, overrideCallback);
            this.d_allRestrictions.add(chooser);
        }
        int maxModeWidth = this.d_allRestrictions.stream().mapToInt(r -> r.d_modeCB.getPreferredSize().width).max().getAsInt();
        this.d_allRestrictions.stream().forEach(r -> r.d_modeCB.setPreferredSize(new Dimension(maxModeWidth, r.d_modeCB.getPreferredSize().height)));
    }

    public boolean validateData(Component parent, boolean allowWarn, boolean allowEdit) {
        return this.d_allRestrictions.stream().allMatch(r -> r.validateData(parent, allowWarn, allowEdit));
    }

    public void init(OccProfile dataObj) {
        OccProfile.CompRestrictions compRestrictions = dataObj.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
        this.init(compRestrictions);
    }

    public void init(OccProfile.CompRestrictions compRestrictions) {
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.initCompRestrictions(compRestrictions);
        }
    }

    public OccProfile.CompRestrictions commit() {
        LinkedIdentityHashSet<IMerlinObj> objs = new LinkedIdentityHashSet<IMerlinObj>();
        EnumMap<OccProfile.CompRestrictions.Type, OccProfile.CompRestrictions.CompRestrictionsInfo> infos = new EnumMap<OccProfile.CompRestrictions.Type, OccProfile.CompRestrictions.CompRestrictionsInfo>(OccProfile.CompRestrictions.Type.class);
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.commitRestrictions(objs, infos);
        }
        return new OccProfile.CompRestrictions(objs, infos);
    }

    public void addToLayout(guiPanel basePanel) {
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.addToLayout(basePanel);
        }
    }

    private static class CompRestriction<T extends IMerlinObj>
    extends ObjRestrictionEditorComponents<OccProfile.CompRestrictions.Mode, T> {
        private final OccProfile.CompRestrictions.Type d_type;

        public CompRestriction(MerlinData md, OccProfile.CompRestrictions.Type type, ILabelGenerator labels) {
            super((Component)labels.lbl(OccProfile.PROP_RESTRICTED_COMPONENTS, type.lbl, ""), type.clazz, ObjRestrictionEditorComponents.newChooser(md, type.chooserLbl, type.clazz, CompRestriction.getRoot(md, type), type.filter), (ModeT mode) -> guiUtil.encodeToHtmlLabel(mode.name, mode.desc), OccProfile.CompRestrictions.Mode.FROM_LIST, type.modes);
            this.d_type = type;
        }

        private static Composite<? extends ICompElement> getRoot(MerlinData md, OccProfile.CompRestrictions.Type type) {
            return EntryPointFactory.get(type.clazz).getRootComposite(md);
        }

        public void initCompRestrictions(OccProfile.CompRestrictions restrictions) {
            MerlinData md = MerlinApp.getApp().getData();
            if (restrictions == null) {
                this.load(null, true, Collections.emptySet());
                return;
            }
            OccProfile.CompRestrictions.CompRestrictionsInfo compInfo = restrictions.getTypeInfo(this.d_type);
            this.load(compInfo.mode, !compInfo.rejected, theUtil.filter(restrictions.getObjs(this.clazz), this.d_type.filter.and(obj -> obj instanceof AMerlinObj && ((AMerlinObj)obj).getDomain() == md)));
        }

        public void commitRestrictions(Set<IMerlinObj> objs, Map<OccProfile.CompRestrictions.Type, OccProfile.CompRestrictions.CompRestrictionsInfo> infos) {
            ObjRestrictionEditorComponents.Data data = this.save();
            boolean rejected = true;
            switch ((OccProfile.CompRestrictions.Mode)((Object)data.mode)) {
                case NONE: 
                case FROM_BEHAVIOR: {
                    rejected = false;
                    break;
                }
                case ALL: 
                case UP_ONLY: 
                case DOWN_ONLY: {
                    rejected = true;
                    break;
                }
                case FROM_LIST: {
                    rejected = !data.accepted;
                    objs.addAll(data.objs);
                }
            }
            OccProfile.CompRestrictions.CompRestrictionsInfo info = new OccProfile.CompRestrictions.CompRestrictionsInfo(rejected, (OccProfile.CompRestrictions.Mode)((Object)data.mode));
            infos.put(this.d_type, info);
        }
    }
}

