/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.text.Format;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import merlin.Intl;
import merlin.util.StringTagsUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.guiFormattedFld;

public class StrTagsField
extends ValueField<Set<String>> {
    private static final long serialVersionUID = 1L;
    private boolean d_emptyAllowed = true;
    private boolean d_nullAllowed = false;
    private final boolean d_allowPredef;
    private final Set<String> d_predefTags;

    public StrTagsField() {
        this(false);
    }

    public StrTagsField(boolean allowPredef) {
        this(allowPredef, StringTagsUtil.getDefaultPredefTags());
    }

    public StrTagsField(boolean allowPredef, Set<String> predefTags) {
        super(StrTagsField.getFormatterFactory(true, false, allowPredef, predefTags), Collections.emptySet());
        this.d_allowPredef = allowPredef;
        this.d_predefTags = predefTags;
        this.setToolTipText(Intl.intl("Enter a space-separated list of tags."));
        this.setColumns(20);
        this.setAccurateValidate(true);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    public void setEmptyAllowed(boolean allowed) {
        if (this.d_emptyAllowed == allowed) {
            return;
        }
        this.d_emptyAllowed = allowed;
        this.updateFormatterFactory();
    }

    @Override
    public void setNullAllowed(boolean allowed) {
        if (allowed == this.d_nullAllowed) {
            return;
        }
        this.d_nullAllowed = allowed;
        this.updateFormatterFactory();
    }

    private void updateFormatterFactory() {
        this.setFormatterFactory(StrTagsField.getFormatterFactory(this.d_emptyAllowed, this.d_nullAllowed, this.d_allowPredef, this.d_predefTags));
    }

    @Override
    public boolean getNullAllowed() {
        return this.d_nullAllowed;
    }

    private static JFormattedTextField.AbstractFormatterFactory getFormatterFactory(boolean allowEmpty, boolean allowNull, boolean allowPredef, Set<String> predefTags) {
        TagFormat editFormat = new TagFormat(allowPredef, allowEmpty, false, predefTags);
        TagFormatter defFormatter = new TagFormatter(editFormat, allowNull);
        TagFormat displayFormat = new TagFormat(allowPredef, allowEmpty, true, predefTags);
        TagFormatter displayFormatter = new TagFormatter(displayFormat, allowNull);
        return new DefaultFormatterFactory(defFormatter, displayFormatter);
    }

    private static class TagFormat
    extends AFormat<Set<String>> {
        private static final long serialVersionUID = 1L;
        private static final String s_mixed = Intl.intl("<mixed>");
        private final boolean d_allowPredefs;
        private final Set<String> d_predefTags;
        private final boolean d_display;
        private final boolean d_allowEmpty;

        private TagFormat(boolean allowPredefs, boolean allowEmpty, boolean display, Set<String> predefTags) {
            this.d_allowPredefs = allowPredefs;
            this.d_display = display;
            this.d_allowEmpty = allowEmpty;
            this.d_predefTags = predefTags;
        }

        @Override
        protected Map<String, Set<String>> newAliasMap() {
            return new LinkedHashMap<String, Set<String>>();
        }

        @Override
        protected Set<String> parse(String text) throws ParseException {
            if (this.d_display && text.equals(s_mixed)) {
                return null;
            }
            return StringTagsUtil.parse(text, this.d_allowEmpty, this.d_allowPredefs, this.d_predefTags);
        }

        @Override
        protected String toString(Set<String> val) {
            if (val == null) {
                if (this.d_display) {
                    return s_mixed;
                }
                return "";
            }
            return StringTagsUtil.format(val);
        }
    }

    private static class TagFormatter
    extends guiFormattedFld.Formatter<Set<String>> {
        private static final long serialVersionUID = 1L;
        private final TagFormat d_tagFormat;

        public TagFormatter(TagFormat format, boolean allowNull) {
            super((Format)format, allowNull);
            this.d_tagFormat = format;
        }

        @Override
        public void validateValue(Set<String> value) throws ParseException {
            super.validateValue(value);
            this.d_tagFormat.parse(this.d_tagFormat.format(value));
        }
    }
}

