/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.ABooleanListDlg;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SetChooser<T extends IMerlinObj>
extends AValEditor<Set<T>>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private static final int SHOW_SEL_CROSSOVER = 10;
    protected final MerlinData d_data;
    private final JEditorPane d_editor;
    protected final String d_desc;
    private final String d_emptyDesc;
    protected final Composite<? extends ICompElement> d_root;
    protected final Class<T> d_clazz;
    protected Predicate<? super T> d_filter;
    private Comparator<T> d_sorter;
    private final Map<Integer, String> d_buttonLabels = new HashMap<Integer, String>();
    protected List<T> d_availObjs;
    private int d_options;

    public SetChooser(MerlinData md, String desc, String emptyDesc, int options, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<? super T> availFilter) {
        super(Set.class);
        this.d_data = md;
        this.d_desc = desc;
        this.d_emptyDesc = emptyDesc;
        this.d_options = options;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_sorter = new MerlinUtil.SortByName();
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.getHtmlLabel("", e -> this.edit());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
        this.setValue(Collections.emptySet());
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    public void setSorter(Comparator<T> sorter) {
        if (Objects.equals(this.d_sorter, sorter)) {
            return;
        }
        this.d_sorter = sorter;
        this.updateAvailable();
    }

    public void setButtonLabel(int button, String label) {
        if (label != null) {
            this.d_buttonLabels.put(button, label);
        } else {
            this.d_buttonLabels.remove(button);
        }
    }

    public String getButtonLabel(int button) {
        return this.d_buttonLabels.get(button);
    }

    public boolean edit() {
        Window parent = guiUtil.getWindow(this);
        this.updateAvailable();
        boolean showSelDef = this.d_availObjs.size() > 10 && this.getValue() != null && !((Set)this.getValue()).isEmpty();
        ObjDlg<T> dlg = new ObjDlg<T>(parent, this.d_desc, this.d_options, showSelDef, this.d_root);
        this.applyButtonLabels(dlg);
        dlg.setAvailObjs(this.d_availObjs);
        dlg.setObjectSelectionState((Set)this.getValue());
        if (dlg.doModal() != 1) {
            this.firePropertyChange("edit", true, false);
            return false;
        }
        this.setValue(dlg.getSelectedObjs(this.d_clazz));
        this.firePropertyChange("edit", false, true);
        return true;
    }

    protected void applyButtonLabels(guiDialog dlg) {
        this.d_buttonLabels.forEach((i, lbl) -> dlg.getButton((int)i).setText((String)lbl));
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    protected void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        LinkedIdentityHashSet objs = (LinkedIdentityHashSet)this.getValue();
        if (objs != null && !objs.isEmpty()) {
            objs = new LinkedIdentityHashSet(objs);
            objs.retainAll(this.d_availObjs);
            this.setValue(objs);
        }
        this.updateDesc();
    }

    protected List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, this.d_sorter != null ? this.d_sorter : MerlinUtil.getSorter(this.d_data, all));
        return all;
    }

    public void setFilter(Predicate<? super T> filter) {
        if (Objects.equals(this.d_filter, filter)) {
            return;
        }
        this.d_filter = filter;
        this.updateAvailable();
    }

    public Predicate<? super T> getFilter() {
        return this.d_filter;
    }

    public void setAnyAllowed(boolean anyAllowed) {
        this.d_options = anyAllowed ? (this.d_options |= 4) : (this.d_options &= 0xFFFFFFFB);
        this.updateDesc();
    }

    public void setObjs(Set<T> objs) {
        this.setValue(objs);
        this.setModified(false);
    }

    @Override
    protected void loadValue(Set<T> value) {
        this.updateDesc();
    }

    @Override
    protected Set<T> saveValue(Mediator mediator) {
        return (Set)this.getValue();
    }

    public void setUnselectedObjs(Set<T> objs) {
        this.setValue(this.invert(objs));
    }

    public Set<T> getObjs() {
        return (Set)this.getValue();
    }

    public Set<T> getUnselectedObjs() {
        return this.invert((Set)this.getValue());
    }

    private Set<T> invert(Set<T> objs) {
        if (objs == null) {
            return null;
        }
        return this.d_availObjs.stream().filter(Filters.reject(objs)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
    }

    protected boolean getOption(int option) {
        return (this.d_options & option) == option;
    }

    protected void updateDesc() {
        boolean isShortened;
        Object desc = null;
        Set val = (Set)this.getValue();
        if (val == null) {
            desc = Intl.intl("[mixed]");
        } else if (val.isEmpty()) {
            String emptyDesc = this.getOption(4) ? Intl.intl("any") : this.d_emptyDesc;
            desc = "[" + emptyDesc + "]";
        } else if (this.allSelected(val) && val.size() > 1) {
            desc = Intl.intl("[All]");
        } else {
            ArrayList objs = new ArrayList(val);
            Collections.sort(objs, ObjSorter.INSTANCE);
            StringBuffer descBuffer = new StringBuffer();
            for (IMerlinObj obj : objs) {
                if (!descBuffer.isEmpty()) {
                    descBuffer.append("; ");
                }
                descBuffer.append(MerlinUtil.getName(obj));
            }
            desc = descBuffer.toString();
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = thunderheadeng.gui.guiUtil.shorten((String)desc, 100, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (!this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText((String)desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    private boolean allSelected(Set<T> vals) {
        return vals.size() == this.getAllAvailableObjs().size();
    }

    private static class ObjDlg<T extends IMerlinObj>
    extends ABooleanListDlg<T> {
        private static final long serialVersionUID = 1L;
        private final Composite<? extends ICompElement> d_root;

        protected ObjDlg(Window parent, String desc, int options, boolean showSelDef, Composite<? extends ICompElement> root) {
            super(parent, desc, desc, null, options, showSelDef);
            this.d_root = root;
        }

        @Override
        public String format(T mobj) {
            if (this.isShowPath()) {
                return MerlinUtil.getNameWithBreadcrumbs(this.d_root, mobj);
            }
            return MerlinUtil.getName(mobj);
        }
    }

    protected static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        protected ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

