/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JEditorPane;
import merlin.Intl;
import merlin.data.property.IDisplayProp;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.ScenarioSetupDlg;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.util.IdentityHashSet;

public class ScenarioSetupEditor
extends AValEditor<ScenarioUtil.MixedOverrideState> {
    private static final long serialVersionUID = 1L;
    private final JEditorPane d_editor;
    private final String d_emptyDesc = Intl.intl("[none]");
    private final Supplier<Set<IDisplayProp<?>>> d_propSupplier;
    protected List<IDisplayProp<?>> d_availProps;

    public ScenarioSetupEditor(Supplier<Set<IDisplayProp<?>>> propSupplier) {
        super(Set.class);
        this.d_propSupplier = propSupplier;
        this.d_editor = guiUtil.getHtmlLabel("", e -> this.edit());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.updateAvailable();
        this.setValue(ScenarioUtil.MixedOverrideState.EMPTY);
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    public boolean edit() {
        Window parent = guiUtil.getWindow(this);
        this.updateAvailable();
        ScenarioSetupDlg dlg = new ScenarioSetupDlg(parent, 0, false);
        dlg.setAvailObjs(this.d_availProps);
        dlg.setObjectSelectionState(((ScenarioUtil.MixedOverrideState)this.getValue()).toDisplay(this.d_availProps));
        if (dlg.doModal() != 1) {
            this.firePropertyChange("edit", true, false);
            return false;
        }
        ScenarioUtil.MixedOverrideState newState = dlg.getObjectSelectionState().toStorage();
        this.setValue(newState);
        this.firePropertyChange("edit", false, true);
        return true;
    }

    public void updateAvailable() {
        this.d_availProps = ScenarioUtil.sortAvailableDisplayProps(this.d_propSupplier.get());
        ScenarioUtil.MixedOverrideState state = (ScenarioUtil.MixedOverrideState)this.getValue();
        if (state != null) {
            Set<IDisplayProp<?>> flattenedAvail = ScenarioUtil.toStorage(this.d_availProps);
            IdentityHashSet overridenProps = new IdentityHashSet(state.overrides());
            IdentityHashSet mixedProps = new IdentityHashSet(state.mixed());
            overridenProps.retainAll(flattenedAvail);
            mixedProps.retainAll(flattenedAvail);
            this.setValue(new ScenarioUtil.MixedOverrideState(overridenProps, mixedProps));
        }
        this.updateDesc();
    }

    public void setObjs(ScenarioUtil.MixedOverrideState state) {
        this.setValue(state);
        this.setModified(false);
    }

    @Override
    protected void loadValue(ScenarioUtil.MixedOverrideState value) {
        this.updateDesc();
    }

    @Override
    protected ScenarioUtil.MixedOverrideState saveValue(Mediator mediator) {
        return (ScenarioUtil.MixedOverrideState)this.getValue();
    }

    protected void updateDesc() {
        boolean isShortened;
        String desc = null;
        ScenarioUtil.MixedOverrideState val = (ScenarioUtil.MixedOverrideState)this.getValue();
        if (val == null || !val.mixed().isEmpty()) {
            desc = Intl.intl("[mixed]");
        } else if (val.overrides().isEmpty()) {
            desc = this.d_emptyDesc;
        } else {
            ArrayList props = new ArrayList(val.toDisplay(this.d_availProps).overrides());
            props.sort(ScenarioUtil.PROP_SORTER);
            StringBuilder descBuffer = new StringBuilder();
            for (IDisplayProp iDisplayProp : props) {
                if (!descBuffer.isEmpty()) {
                    descBuffer.append("; ");
                }
                descBuffer.append(iDisplayProp.getDisplayName());
            }
            desc = descBuffer.toString();
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = guiUtil.shorten(desc, 150, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (!this.d_availProps.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText(desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }
}

