/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JSeparator;
import merlin.Intl;
import merlin.actions.NewScenario;
import merlin.actions.SetActiveScenario;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.data.scenario.ScenarioUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.SortCache;

public class ScenarioComboModel
extends AbstractListModel<Object>
implements IEventObserver,
ComboBoxModel<Object> {
    private static final long serialVersionUID = 1L;
    private final MerlinData d_data;
    private final Semaphore d_lock = new Semaphore(1);
    private SortCache<Object> d_scenarioCache;
    private WeakReference<Scenario> d_selectedScenario;
    private final UIHook NEW_SCENARIO = new UIHook(NewScenario.NEW_SCENARIO_OP, Intl.intl("New Scenario"));
    public static final Object NEW_SCENARIO_ITEM = Intl.intl("<Add New...>");
    public static final Object SEPARATOR = new JSeparator(0);

    public ScenarioComboModel(MerlinData md) {
        this.d_data = md;
        this.regenScenarioCache();
        this.updateSelectedScenario();
    }

    private void regenScenarioCache() {
        this.d_scenarioCache = new SortCache(this.getScenarios(this.d_data));
    }

    private SortCache<Object> getScenarioCache() {
        return this.d_scenarioCache;
    }

    protected Collection<?> getScenarios(MerlinData md) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>(md.scenarios.flatten(Scenario.class));
        scenarios.sort(ScenarioUtil.SCENARIO_SORTER);
        ArrayList<Object> scenarioOptions = new ArrayList<Object>();
        scenarioOptions.add(NEW_SCENARIO_ITEM);
        scenarioOptions.add(SEPARATOR);
        scenarioOptions.addAll(scenarios);
        return scenarioOptions;
    }

    public Object getScenario(int index) {
        return this.getScenarioCache().get(index);
    }

    private void updateSelectedScenario() {
        this.setSelectedItem(this.d_data.scenarios.getActive(), false);
    }

    @Override
    public int getSize() {
        return this.getScenarioCache().size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getScenario(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem == NEW_SCENARIO_ITEM) {
            this.NEW_SCENARIO.run(null);
        } else {
            this.setSelectedItem(anItem, true);
        }
    }

    public int indexOf(Scenario scenario) {
        return this.getScenarioCache().indexOf(scenario);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItem(Object anItem, boolean setActive) {
        if (!(anItem instanceof Scenario)) {
            return;
        }
        Scenario scenario = (Scenario)anItem;
        if (!this.d_lock.tryAcquire()) {
            return;
        }
        try {
            this.d_selectedScenario = new WeakReference<Scenario>(scenario);
            int ix = this.indexOf(scenario);
            this.fireContentsChanged(this, ix, ix);
            if (setActive) {
                SetActiveScenario.setActiveScenario(null, scenario);
            }
        }
        finally {
            this.d_lock.release();
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.d_selectedScenario.get();
    }

    @Override
    public void update(Events events) {
        IEventRecord<ScenarioRoot> scenarioEvts = events.getEvents(ScenarioRoot.class, new Class[0]);
        if (scenarioEvts.hasChangedObjs(MerlinData.CHILD_ADDED) || scenarioEvts.hasChangedObjs(MerlinData.CHILD_REMOVED)) {
            this.regenScenarioCache();
        }
        if (events.isChanged(this.d_data.scenarios, ScenarioRoot.ACTIVE_SCENARIO)) {
            this.updateSelectedScenario();
        }
    }
}

