/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.Objects;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import merlin.EntryPointFactory;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.gui.ScenarioComboModel;
import merlin.gui.guiUtil;
import thunderheadeng.gui.guiComboBox;

public class ScenarioComboBox
extends guiComboBox<Scenario> {
    private static final long serialVersionUID = 4247925537193044011L;
    private MerlinData d_data;
    private final boolean d_showIcon;

    public ScenarioComboBox(MerlinData md, boolean showIcon) {
        this.d_data = md;
        this.d_showIcon = showIcon;
        this.setModel(new ScenarioComboModel(md));
        md.getEvents().addObserver((ScenarioComboModel)this.getModel());
        this.setRenderer(new ScenarioCellRenderer());
        this.addItemListener(e -> this.updateFont());
        this.updateFont();
    }

    private void updateFont() {
        Scenario scenario = (Scenario)this.getSelectedItem();
        if (scenario != null) {
            Font font = EntryPointFactory.get(scenario).tvEntryPoint.getFont(this.d_data, scenario);
            if (!Objects.equals(this.getFont(), font)) {
                this.setFont(font);
            }
        }
    }

    private class ScenarioCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4928376446272495812L;

        private ScenarioCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == ScenarioComboModel.SEPARATOR) {
                return (JSeparator)value;
            }
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof String)) {
                guiUtil.decorateComboRenderer(ScenarioComboBox.this.d_data, ScenarioComboBox.this, list, value, this, isSelected, cellHasFocus, ScenarioComboBox.this.d_showIcon);
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            return c;
        }
    }
}

