/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.gui.dialogs.AFindDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Filters;

public class PthFindDlg
extends AFindDlg<INamed, MerlinData> {
    private static final long serialVersionUID = -2595614188856099398L;
    private guiCheckBox d_objectNames;
    private guiCheckBox d_objectTags;

    public PthFindDlg(Window owner, MerlinData md) {
        super(owner, md);
    }

    @Override
    protected Collection<JComponent> getSubclassComponents() {
        if (this.d_objectNames == null) {
            this.d_objectNames = new guiCheckBox(Intl.intl("Object Names"));
            this.d_objectNames.setToolTipText(Intl.intl("Includes the names of objects in the search."));
            this.d_objectNames.setSelected(true);
        }
        if (this.d_objectTags == null) {
            this.d_objectTags = new guiCheckBox(Intl.intl("Object Tags"));
            this.d_objectTags.setToolTipText(Intl.intl("Includes an object's tags in the search."));
            this.d_objectTags.setSelected(true);
        }
        return List.of(this.d_objectNames, this.d_objectTags);
    }

    @Override
    public void perform(final guiComboBox<String> findFld, final guiLabel message, final AFindDlg.ActionAfterQuery action) {
        UIHook.run(this, "Find", new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                PthFindDlg.this.run(findFld, message, action);
            }
        }, 0);
    }

    @Override
    protected Collection<INamed> find(String query) {
        if (query.trim().isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<INamed> objects = new ArrayList<INamed>();
        MerlinData md = (MerlinData)this.getDomain();
        for (Object child : EntryPointFactory.get(md).tvEntryPoint.getChildren(md, md)) {
            if (child instanceof INamed) {
                objects.add((INamed)child);
            }
            if (!(child instanceof Composite)) continue;
            objects.addAll(((Composite)child).getDeepMembers());
        }
        if (query.toLowerCase().startsWith("numtris")) {
            return objects.stream().filter(PthFindDlg.getNumTrisFilter(query)).collect(Collectors.toList());
        }
        Function<INamed, Stream> getSearchStrings = this.d_objectNames.isSelected() && this.d_objectTags.isSelected() ? o -> {
            ICompElement celem;
            Stream<String> strings = Stream.of(o.getName());
            if (o instanceof ICompElement && (celem = (ICompElement)o).isSupportedLocally(MerlinData.TAGS)) {
                strings = Stream.concat(strings, celem.getProp(MerlinData.TAGS).stream().flatMap(tags -> tags.stream()).map(NamedMerlinObj::getName));
            }
            return strings;
        } : (this.d_objectNames.isSelected() ? o -> Stream.of(o.getName()) : (this.d_objectTags.isSelected() ? o -> {
            ICompElement celem;
            if (o instanceof ICompElement && (celem = (ICompElement)o).isSupportedLocally(MerlinData.TAGS)) {
                return celem.getProp(MerlinData.TAGS).stream().flatMap(tags -> tags.stream()).map(NamedMerlinObj::getName);
            }
            return Stream.empty();
        } : o -> Stream.empty()));
        return this.performSearch(query, objects, getSearchStrings);
    }

    @Override
    protected void selectNext() {
        if (!this.getIterator().hasNext()) {
            return;
        }
        try (MerlinData.WriteLock lock = ((MerlinData)this.getDomain()).lockWrite();){
            Undo.begin(Intl.intl("Find Next"));
            Undo.insertUndoEntry_restoreSelection((MerlinData)this.getDomain());
            ((MerlinData)this.getDomain()).selection.set(this.getIterator().next());
            Undo.end((MerlinData)this.getDomain());
        }
        PthFindDlg.showSelectionInTree();
    }

    @Override
    protected void selectAll() {
        try (MerlinData.WriteLock lock = ((MerlinData)this.getDomain()).lockWrite();){
            Undo.begin(Intl.intl("Find All"));
            Undo.insertUndoEntry_restoreSelection((MerlinData)this.getDomain());
            ((MerlinData)this.getDomain()).selection.set(this.getSelection());
            Undo.end((MerlinData)this.getDomain());
        }
        PthFindDlg.showSelectionInTree();
    }

    private static Predicate<INamed> getNumTrisFilter(String query) {
        int count;
        IntPredicate comparator;
        if (!query.toLowerCase().startsWith("numtris")) {
            return Filters.rejectAll();
        }
        StringTokenizer toks = new StringTokenizer(query, " ");
        if (toks.countTokens() != 3) {
            return Filters.rejectAll();
        }
        toks.nextToken();
        String compStr = toks.nextToken();
        String numStr = toks.nextToken();
        switch (compStr) {
            case ">": {
                comparator = i -> i > 0;
                break;
            }
            case ">=": {
                comparator = i -> i >= 0;
                break;
            }
            case "<": {
                comparator = i -> i < 0;
                break;
            }
            case "<=": {
                comparator = i -> i <= 0;
                break;
            }
            case "==": {
                comparator = i -> i == 0;
                break;
            }
            default: {
                return Filters.rejectAll();
            }
        }
        try {
            count = Integer.parseInt(numStr.trim());
        }
        catch (Throwable t) {
            return Filters.rejectAll();
        }
        return elem -> {
            if (!(elem instanceof IMerlinGeomSrc)) {
                return false;
            }
            IMerlinGeomSrc geom = (IMerlinGeomSrc)((Object)elem);
            int numPrims = geom.getGeom().getNumPrims(1);
            return comparator.test(numPrims - count);
        };
    }

    private static void showSelectionInTree() {
        EventQueue.invokeLater(() -> {
            MerlinApp app = MerlinApp.getApp();
            if (app != null) {
                app.getTreeView().showCurrentSelection();
            }
        });
    }
}

