/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.actions.NewObject;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.IDisplayProp;
import merlin.gui.ManagerDlg;
import merlin.gui.NewActionListener;
import merlin.gui.NewDlg;
import merlin.gui.ProfilesPanel;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;

public class ProfilesDlg
extends ManagerDlg<OccProfile, ManagerDlg.IManager<OccProfile>> {
    private static final long serialVersionUID = -2692486551630731588L;
    private static final int s_newActionIx = 0;
    private static final int s_libraryActionIx = 1;
    private static final int s_renameActionIx = 2;
    private static final int s_deleteActionIx = 3;
    private static final int s_overridesActionIx = 4;
    private final IEditor<OccProfile> d_editor;
    private ManagerDlg.IManager<OccProfile> d_mgr;

    public ProfilesDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Edit Profiles"), OccProfile.class);
        this.d_editor = new ProfilesPanel(owner, this.getMgrOverrideCallback());
        String newMsg = Intl.intl("New Profile");
        this.d_actions = new Action[]{this.newAction(new NewActionListener<OccProfile, NewDlg<OccProfile>>(NewObject.NEW_PROFILE_OP)), new ManagerDlg.LibraryAction(), new ManagerDlg.RenameAction(OccProfile.PROP_NAME, newMsg, md -> md.profiles), new ManagerDlg.DeleteAction(), this.d_overrideAction};
        this.updateActions();
    }

    @Override
    protected boolean validateEditor(IEditor<OccProfile> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.d_edix;
            OccProfile prof = (OccProfile)this.getList().getItem(ix);
            if (prof != null && !this.validateProfile(prof, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateProfile(OccProfile prof, boolean showWarn, boolean allowModify) {
        Map<IDisplayProp, List<EgressAgent>> localPropMap;
        if (!showWarn) {
            return true;
        }
        boolean showProfWarn = MerlinPrefs.getBoolean(MerlinPrefs.ShowCustomProfilesWarning);
        if (showProfWarn && !(localPropMap = this.getLocalPropsMap(prof)).isEmpty()) {
            Object msg;
            if (localPropMap.size() == 1) {
                Map.Entry<IDisplayProp, List<EgressAgent>> entry = localPropMap.entrySet().iterator().next();
                String dispName = entry.getKey().getDisplayName();
                msg = entry.getValue().size() == 1 ? String.format(Intl.intl("Occupant <b>%1$s</b> has a custom <b>%2$s</b> defined and will not be<br>affected by the %3$s change."), entry.getValue().get(0).getName(), dispName, dispName) : String.format(Intl.intl("%1$d occupants have a custom <b>%2$s</b> defined and will not be<br>affected by the %3$s change."), entry.getValue().size(), dispName, dispName);
            } else {
                HashSet modifiedAgents = new HashSet();
                for (List list : localPropMap.values()) {
                    modifiedAgents.addAll(list);
                }
                msg = modifiedAgents.size() == 1 ? String.format(Intl.intl("Occupant <b>%s</b> has custom profile parameters defined and might not be<br>affected by the profile changes."), ((EgressAgent)modifiedAgents.iterator().next()).getName()) : String.format(Intl.intl("%d occupants have profile parameters defined and might not be<br>affected by the profile changes."), modifiedAgents.size());
            }
            msg = "<html>" + (String)msg + "</html>";
            guiCheckBox neverShowCB = new guiCheckBox(Intl.intl("Do not show this message again."));
            guiPanel panel = new guiPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(panel);
            gridBagHelper.addFilledRow(msg);
            gridBagHelper.addFilledRow(neverShowCB);
            gridBagHelper.finalizeRows();
            JOptionPane.showMessageDialog(this, panel, Intl.intl("Custom Agents"), 2);
            MerlinPrefs.set(MerlinPrefs.ShowCustomProfilesWarning, !neverShowCB.isSelected());
        }
        return true;
    }

    private Map<IDisplayProp, List<EgressAgent>> getLocalPropsMap(OccProfile prof) {
        Collection<IDisplayProp> changes = ((ProfilesPanel)this.d_editor).getChanges(prof);
        if (changes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IDisplayProp, List<EgressAgent>> localPropMap = new HashMap<IDisplayProp, List<EgressAgent>>();
        for (EgressAgent agent : this.getMerlinData().agents.getDeepMembers(EgressAgent.class)) {
            if (agent.getProfile().getProfParent() != prof) continue;
            for (IDisplayProp prop : changes) {
                if (!(prop instanceof IPropertySet.Prop) || !agent.getProfile().isDefinedLocally((IPropertySet.Prop)((Object)prop))) continue;
                localPropMap.computeIfAbsent(prop, k -> new ArrayList()).add(agent);
            }
        }
        return localPropMap;
    }

    public void init(MerlinData md, ManagerDlg.IManager<OccProfile> mgr, OccProfile init) {
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
    }

    @Override
    public void updateActions() {
        this.updateActionEnabled(0, this.shouldEnableNew());
        this.updateActionEnabled(1, this.shouldEnableImport());
        this.updateActionEnabled(2, this.shouldEnableRename());
        this.updateActionEnabled(3, this.shouldEnableDelete());
        this.updateActionEnabled(4, this.shouldEnableOverride());
    }
}

