/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import merlin.MerlinApp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.AObjsList;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;

public class PathObjsList
extends AObjsList<IMerlinObj> {
    public PathObjsList(MerlinData md, String undoDesc, boolean linkSelection, boolean autoSort, Collection<? extends IMerlinObj> objs) {
        super(PathObjsList.getCallback(md, undoDesc), linkSelection, autoSort, objs);
    }

    private static AObjsList.ICallback<IMerlinObj> getCallback(final MerlinData md, final String undoDesc) {
        return new AObjsList.ICallback<IMerlinObj>(){

            @Override
            public Collection<? extends IMerlinObj> finalizeObjs(Collection<? extends IMerlinObj> objs, boolean autoSort) {
                if (!autoSort) {
                    return objs;
                }
                ArrayList<? extends IMerlinObj> sortedReplacements = new ArrayList<IMerlinObj>(objs);
                Comparator<? extends IMerlinObj> baseSorter = MerlinUtil.getSorter(md, objs);
                sortedReplacements.sort((o1, o2) -> {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return baseSorter.compare((IMerlinObj)o1, (IMerlinObj)o2);
                });
                return sortedReplacements;
            }

            @Override
            public Events getEvents() {
                return md.getEvents();
            }

            @Override
            public boolean isSelectionEvent(IEventRecord<?> events) {
                return events.containsChange(MerlinData.SELECTION_CHANGED);
            }

            @Override
            public boolean isDecorationEvent(IEventRecord<?> events) {
                return events.containsChange(NamedMerlinObj.NAME);
            }

            @Override
            public boolean isSelected(IMerlinObj obj) {
                return md.selection.isSelected(obj);
            }

            @Override
            public void setSelection(AObjsList<IMerlinObj> dlg, Collection<? extends IMerlinObj> objs) {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(undoDesc);
                        Undo.insertUndoEntry_restoreSelection(md);
                        md2.selection.clear();
                        md2.selection.selectAll(objs);
                        Undo.end(md);
                    }
                });
                UIHook.run(dlg, "PathObjsList.updateSelAction.valueChanged", op, 0);
            }

            @Override
            public void decorateCells(DefaultListCellRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                guiUtil.decorateCellRenderer(md, list::repaint, value, r, isSelected, cellHasFocus, true, true);
                r.setText(MerlinUtil.getName(value));
            }

            @Override
            public JPopupMenu getContextMenu(MouseEvent e) {
                return MerlinApp.getContextMenu();
            }
        };
    }
}

