/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.NodeComboModel;
import merlin.gui.guiUtil;
import thunderheadeng.gui.guiComboBox;

public class NodeComboBox<T extends IMerlinObj>
extends guiComboBox<NodeComboModel.CompositeItem<T>> {
    private static final long serialVersionUID = 7895768520555305671L;

    public NodeComboBox(NodeComboModel<T> model) {
        super(model);
        this.setRenderer(new CompositeListRenderer());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        if (prefSize.width < 150) {
            prefSize.width = 150;
        }
        return prefSize;
    }

    public T getSelectedNode() {
        NodeComboModel.CompositeItem selectedItem = (NodeComboModel.CompositeItem)this.getSelectedItem();
        return selectedItem != null ? (T)selectedItem.composite : null;
    }

    public void setSelectedNode(T node) {
        ((NodeComboModel)this.getModel()).setSelectedNode(node);
    }

    private class CompositeListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 632357205839199325L;
        private static final int OFFSET = 16;

        private CompositeListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Component) {
                return (Component)value;
            }
            MerlinData md = MerlinApp.getApp().getData();
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof NodeComboModel.CompositeItem) {
                NodeComboModel.CompositeItem item = (NodeComboModel.CompositeItem)value;
                guiUtil.decorateComboRenderer(md, NodeComboBox.this, list, item.composite, label, isSelected, cellHasFocus, true);
                int indent = label.getInsets().left + item.depth * 16;
                label.setBorder(BorderFactory.createEmptyBorder(0, indent, 0, 0));
            }
            return label;
        }
    }
}

