/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class MerlinComboBox<T extends IMerlinObj>
extends guiComboBox<T>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private final MerlinData d_data;
    private final Class<?> d_type;
    private String d_nullName;
    private Semaphore d_updateLock = new Semaphore(1);
    private Function<MerlinData, List<T>> d_getValues;

    public MerlinComboBox(MerlinData md, Class<T> type, T ... specialValues) {
        this(md, type, Predicates.alwaysTrue(), (IMerlinObj[])specialValues);
    }

    public MerlinComboBox(MerlinData md, Class<T> type, Predicate<? super T> filter, T ... specialValues) {
        this(md, type, filter, null, (IMerlinObj[])specialValues);
    }

    public MerlinComboBox(MerlinData md, Class<T> type, Predicate<? super T> filter, Comparator<T> sorter, T ... specialValues) {
        this(md, (Class<?>)type, new ItemsFromModel<T>(type, filter, sorter, specialValues));
    }

    public MerlinComboBox(final MerlinData md, Class<?> type, Function<MerlinData, List<T>> getValues) {
        this.d_data = md;
        this.d_type = type;
        this.d_getValues = getValues;
        this.d_nullName = "";
        md.getEvents().addObserver(this);
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null || !guiUtil.decorateComboRenderer(md, MerlinComboBox.this, list, value, this, isSelected, cellHasFocus, true)) {
                    this.setText(MerlinComboBox.this.d_nullName);
                }
                return this;
            }
        });
        this.updateEntries();
    }

    public Semaphore getUpdateLock() {
        return this.d_updateLock;
    }

    public boolean setFilter(Predicate<? super T> filter) {
        Function<MerlinData, List<T>> function = this.d_getValues;
        if (function instanceof ItemsFromModel) {
            ItemsFromModel fromModel = (ItemsFromModel)function;
            fromModel.setFilter(filter);
            this.updateEntries();
            return true;
        }
        return false;
    }

    public void setNullName(String nullName) {
        this.d_nullName = nullName;
        this.repaint();
    }

    protected String getName(MerlinData md, Object o) {
        if (!(o instanceof IMerlinObj)) {
            return o == null ? "" : o.toString();
        }
        EntryPoint<IMerlinObj> ep = EntryPointFactory.get((IMerlinObj)o);
        return ep.tvEntryPoint.getName(md, (IMerlinObj)o);
    }

    protected List<T> getItems(MerlinData md) {
        return this.d_getValues.apply(md);
    }

    private void updateEntries() {
        IMerlinObj selItem = (IMerlinObj)this.getSelectedItem();
        List<T> items = this.getItems(this.d_data);
        this.setItems(items);
        if (items.contains(selItem)) {
            this.setSelectedItem(selItem);
        } else if (!items.isEmpty()) {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public void update(Events events) {
        if (!this.d_updateLock.tryAcquire()) {
            return;
        }
        try {
            IEventRecord<?> evt = events.getEvents(this.d_type, new Class[0]);
            if (!evt.getAddedObjs().isEmpty() || !evt.getRemovedObjs().isEmpty()) {
                this.updateEntries();
            } else if (evt.hasChangedObjs()) {
                this.repaint();
            }
        }
        finally {
            this.d_updateLock.release();
        }
    }

    private static class ItemsFromModel<T>
    implements Function<MerlinData, List<T>> {
        private final Class<T> d_type;
        private Predicate<? super T> d_filter;
        private final Comparator<T> d_sorter;
        private final T[] d_specialValues;

        public ItemsFromModel(Class<T> d_type, Predicate<? super T> d_filter, Comparator<T> d_sorter, T ... specialValues) {
            this.d_type = d_type;
            this.d_filter = d_filter;
            this.d_sorter = d_sorter;
            this.d_specialValues = specialValues;
        }

        public void setFilter(Predicate<? super T> filter) {
            this.d_filter = filter;
        }

        @Override
        public List<T> apply(MerlinData d_data) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (this.d_type.equals(Material.class)) {
                items.addAll(theUtil.filter(d_data.materials.flatten(Material.class), this.d_type, this.d_filter));
            } else {
                for (IMerlinObj iMerlinObj : d_data.getChildren()) {
                    if (!(iMerlinObj instanceof Composite)) continue;
                    items.addAll(theUtil.filter(((Composite)iMerlinObj).getDeepMembers(this.d_type), this.d_filter));
                }
            }
            Comparator<Object> sorter = this.d_sorter != null ? this.d_sorter : MerlinUtil.getSorter(d_data, items);
            Collections.sort(items, sorter);
            items.addAll(0, Arrays.asList(this.d_specialValues));
            return items;
        }
    }

    public static class MerlinComboBoxWithEmptyOption<T extends IMerlinObj>
    extends MerlinComboBox<T> {
        private static final long serialVersionUID = 1L;

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, String msg, Predicate<? super T> filter) {
            super(md, type, filter, new IMerlinObj[0]);
            this.setNullName(msg);
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, String msg) {
            this(md, type, msg, Predicates.alwaysTrue());
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, Predicate<? super T> filter) {
            this(md, type, Intl.intl("[None]"), filter);
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type) {
            this(md, type, Intl.intl("[None]"));
        }

        @Override
        public List<T> getItems(MerlinData md) {
            List list = super.getItems(md);
            list.add(0, null);
            return list;
        }

        @Override
        public int getSelectedIndex() {
            int index = super.getSelectedIndex();
            if (index == -1) {
                index = 0;
            }
            return index;
        }
    }
}

