/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.MerlinOpImpl;
import merlin.actions.NewObject;
import merlin.actions.ScenarioSetupAction;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.property.IDisplayProp;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.InvisibleSplitPane;
import merlin.gui.LibraryDlg;
import merlin.gui.ScenarioSetupDlg;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.IScenarioLabelGenerator;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;

public class ManagerDlg<T extends ICompElement, MgrT extends IManager<T>>
extends guiDialog
implements ListSelectionListener,
DlgListener,
Observer,
ActionListener,
IEventObserver {
    private static final long serialVersionUID = -6801201917913411572L;
    private final JFrame d_owner;
    private final guiPanel d_mgrEdPanel;
    private final guiPanel d_actPanel;
    private final guiPanel d_edPanel;
    private final ListCellRenderer<?> d_ren;
    public static final String KEY = "KEY";
    private MgrT d_mgr;
    private RecordList d_recs;
    private IEditor<T> d_editor;
    private IEditor<MgrT> d_mgrEditor;
    private MerlinData d_md;
    protected int d_edix;
    private Class<T> d_clazz;
    protected Action[] d_actions;
    protected ScenarioSetupAction d_overrideAction;
    private final boolean d_decorateList;

    protected ManagerDlg(JFrame owner, String title, Class<T> clazz) {
        this(owner, title, clazz, false);
    }

    protected ManagerDlg(JFrame owner, String title, Class<T> clazz, boolean decorateList) {
        super((Window)owner, title, 11);
        this.d_clazz = clazz;
        this.d_decorateList = decorateList;
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.d_owner = owner;
        this.d_mgr = null;
        this.d_editor = null;
        this.d_mgrEditor = null;
        this.d_md = null;
        this.d_ren = new ManagedListCellRen();
        this.d_recs = new RecordList();
        this.d_recs.addListener(this);
        this.d_edix = -1;
        this.d_overrideAction = new ScenarioSetupAction(e -> {
            if (!this.preSave()) {
                return;
            }
            int selIx = this.getList().getSelectedIx();
            Object obj = this.getList().getItem(selIx);
            ScenarioSetupDlg dlg = new ScenarioSetupDlg((Window)this, 0, false);
            List<IDisplayProp<?>> supportedDisplayProps = ScenarioUtil.getSortedAvailableDisplayProps(obj);
            dlg.setAvailObjs(supportedDisplayProps);
            ScenarioUtil.MixedOverrideState state = ScenarioUtil.getScenarioOverrideState(this.getMerlinData().scenarios.getActive(), Collections.singleton(obj));
            dlg.setObjectSelectionState(state.toDisplay(supportedDisplayProps));
            if (dlg.doModal() == 1) {
                MerlinOpImpl op = new MerlinOpImpl((app, data) -> {
                    ScenarioUtil.MixedOverrideState newOverrides = dlg.getObjectSelectionState().toStorage();
                    Scenario activeScenario = data.scenarios.getActive();
                    ScenarioUtil.applyScenarioOverrideState(data, activeScenario, Collections.singleton(obj), newOverrides);
                });
                UIHook.run(this, "ManagerDlg.ScenarioOverridesAction.actionPerformed", op, 0);
            }
            this.d_editor.init(obj);
            this.getList().updateModelView(this.d_mgr);
        });
        this.addDlgListener(this);
        CloseListener closeLis = new CloseListener();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(ks);
        this.getRootPane().registerKeyboardAction(closeLis, ks, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeLis);
        guiPanel content = this.getDialogPane();
        content.setLayout(new BorderLayout());
        this.d_mgrEdPanel = new guiPanel(new GridBagLayout());
        guiPanel left = new guiPanel(new GridBagLayout());
        this.d_edPanel = new guiPanel(new GridBagLayout());
        this.d_actPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(this.d_actPanel, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
        GridBagUtil.add(left, this.d_recs, 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0);
        GridBagUtil.add(left, this.d_actPanel, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0);
        InvisibleSplitPane splitPane = new InvisibleSplitPane(1, true, left, this.d_edPanel);
        splitPane.setDividerSize(12);
        content.add((Component)this.d_mgrEdPanel, "North");
        content.add((Component)splitPane, "Center");
        this.setResizable(true);
    }

    protected ILabelGenerator getMgrOverrideCallback() {
        return new IScenarioLabelGenerator(){

            @Override
            public Collection<? extends ICompElement> getSelection() {
                return ManagerDlg.this.getList().getSelectedItem() != null ? Set.of(ManagerDlg.this.getList().getSelectedItem()) : Collections.emptySet();
            }

            @Override
            public Boolean getState(Collection<Object> props) {
                Collection<? extends ICompElement> objs = this.getSelection();
                return ScenarioUtil.isLabelActiveOverride(MerlinApp.getAppData(), objs, props);
            }

            @Override
            public void applyOverride(Collection<? extends IDisplayProp<?>> props, boolean setCustomized) {
                if (props == null) {
                    return;
                }
                if (!ManagerDlg.this.preSave()) {
                    return;
                }
                Object obj = ManagerDlg.this.getList().getSelectedItem();
                Collection<? extends ICompElement> sel = this.getSelection();
                ScenarioUtil.MixedOverrideState state = ScenarioUtil.getScenarioOverrideState(ManagerDlg.this.d_md.scenarios.getActive(), sel);
                if (setCustomized) {
                    state.overrides().addAll(props);
                } else {
                    state.overrides().removeAll(props);
                }
                ScenarioUtil.applyScenarioOverrideState(ManagerDlg.this.d_md, ManagerDlg.this.d_md.scenarios.getActive(), sel, state);
                ManagerDlg.this.d_editor.init(obj);
                ManagerDlg.this.repaint();
            }
        };
    }

    @Override
    public void setVisible(boolean visible) {
        assert (!visible || MerlinApp.getApp().getData().getEvents().isObserver(this)) : String.format("Each %s instance must only be opened once", this.getClass().getSimpleName());
        super.setVisible(visible);
        if (!visible) {
            MerlinApp.getApp().getData().getEvents().removeObserver(this);
        }
    }

    public MerlinData getMerlinData() {
        return this.d_md;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.d_status = 16;
        this.fireButtonPressed(16);
    }

    public RecordList getList() {
        return this.d_recs;
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int opt = this.showConfirm();
            if (opt == 1) {
                this.d_editor.init(this.getList().getItem(this.d_edix));
            } else if (opt == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        try {
            int ix = this.getList().getSelectedIx();
            if (this.d_edix == ix) {
                return;
            }
            if (-1 < this.d_edix && this.d_edix < this.d_mgr.size() && this.d_editor.isModified()) {
                if (!MerlinPrefs.getBoolean(MerlinPrefs.LIST_EDITORS_PROMPT_TO_SAVE)) {
                    if (!this.handleYes()) {
                        this.handleCancel();
                        return;
                    }
                    this.handleNo(ix);
                    this.d_edix = ix;
                } else {
                    switch (this.showConfirm()) {
                        case 0: {
                            boolean isValid = this.handleYes();
                            if (!isValid) {
                                this.handleCancel();
                                break;
                            }
                        }
                        case 1: {
                            this.handleNo(ix);
                            this.d_edix = ix;
                            break;
                        }
                        default: {
                            this.handleCancel();
                            break;
                        }
                    }
                }
            } else if (ix > -1) {
                this.d_edix = ix;
                this.handleNo(ix);
            } else {
                this.d_edix = ix;
                this.d_editor.init(null);
            }
        }
        finally {
            this.updateActions();
        }
    }

    protected boolean validateEditor(IEditor<T> editor, boolean showWarn, boolean allowModify) {
        return editor.getEditorPanel().validateData(showWarn, allowModify);
    }

    protected boolean handleYes() {
        Object edObj = this.getList().getItem(this.d_edix);
        if (!this.validateEditor(this.d_editor, true, true)) {
            this.d_recs.select(this.d_edix);
            return false;
        }
        this.commit(edObj);
        return true;
    }

    protected void handleNo(int ix) {
        this.d_edix = ix;
        Object edItem = this.d_edix > -1 ? this.getList().getItem(this.d_edix) : null;
        this.d_editor.init(edItem);
    }

    protected void handleCancel() {
        this.d_recs.select(this.d_edix);
    }

    public int showConfirm() {
        Object edObj = this.getList().getItem(this.d_edix);
        String msg = Intl.intl("Save changes to: ") + this.d_mgr.describe(edObj) + Intl.intl("?");
        return JOptionPane.showConfirmDialog(this, msg);
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.handleNo(this.d_edix);
                        this.setVisible(false);
                        break;
                    }
                    this.handleCancel();
                    break;
                }
                case 1: {
                    this.handleNo(this.d_edix);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    private void commit(T edObj) {
        this.d_md.pauseUpdates();
        this.d_editor.commit(edObj);
        this.d_md.resumeUpdates();
    }

    @Override
    public void applyPressed() {
        this.d_md.pauseUpdates();
        if (this.d_editor.isModified()) {
            int ix = this.getList().getSelectedIx();
            Object edObj = this.getList().getItem(ix);
            this.d_editor.commit((ICompElement)edObj);
            this.getList().repaint();
        }
        if (this.d_mgrEditor != null && this.d_mgrEditor.isModified()) {
            this.d_mgrEditor.commit(this.d_mgr);
        }
        this.d_md.resumeUpdates();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return this.validateEditor(this.d_editor, showWarn, allowModify) && (this.d_mgrEditor == null || this.d_mgrEditor.getEditorPanel().validateData(showWarn, allowModify));
    }

    protected void init(MerlinData md, MgrT mgr, IEditor<T> ed, Action[] actions) {
        this.init(md, mgr, ed, null, actions);
    }

    protected void init(MerlinData md, MgrT mgr, IEditor<T> ed, IEditor<MgrT> mgrEditor, Action[] actions) {
        this.d_md = md;
        if (this.d_editor != null) {
            this.d_editor.removeObserver(this);
        }
        this.d_mgr = mgr;
        this.d_editor = ed;
        this.d_mgrEditor = mgrEditor;
        this.d_recs.setModel(mgr, this.d_ren);
        if (this.d_mgrEditor != null) {
            this.d_mgrEditor.init(this.d_mgr);
        }
        this.d_edix = -1;
        if (this.d_mgr.size() > 0) {
            this.d_recs.select(0);
        }
        this.d_actPanel.removeAll();
        for (int i = 0; i < actions.length; ++i) {
            int ix = 0;
            while (true) {
                Object key = ix == 0 ? KEY : KEY + ix;
                ++ix;
                KeyStroke k = (KeyStroke)actions[i].getValue((String)key);
                if (k == null) break;
                this.d_recs.d_list.getActionMap().put("released", actions[i]);
                this.d_recs.d_list.getInputMap().put(k, "released");
            }
            JButton actBtn = new JButton(actions[i]);
            int bottom = i == actions.length - 1 ? 0 : 6;
            GridBagUtil.add(this.d_actPanel, actBtn, 0, i, 1, 1, 0, 0, bottom, 0, 2, 1.0, 0.0);
        }
        this.d_mgrEdPanel.removeAll();
        if (this.d_mgrEditor != null) {
            GridBagUtil.add(this.d_mgrEdPanel, this.d_mgrEditor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 18);
        }
        this.d_edPanel.removeAll();
        GridBagUtil.add(this.d_edPanel, this.d_editor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        this.d_editor.addObserver(this);
        this.pack();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.d_recs.repaint();
    }

    protected Collection<? extends T> getModelColl(MgrT manager) {
        return manager.getSorted();
    }

    public Action newAction(ActionListener listener) {
        return new NewAction(listener);
    }

    @Override
    public void update(Events events) {
        IEventRecord<T> pevents = events.getEvents(this.d_clazz, new Class[0]);
        Set<T> addedObjs = pevents.getAddedObjs();
        if (!addedObjs.isEmpty()) {
            this.getList().updateModelView(this.d_mgr);
            this.getList().select((ICompElement)addedObjs.iterator().next());
            this.d_editor.getEditorPanel().setModified(false);
        }
    }

    public void updateActions() {
    }

    protected void updateActionEnabled(int actionIx, boolean isAvailable) {
        this.d_actions[actionIx].setEnabled(isAvailable);
    }

    protected boolean shouldEnableNew() {
        return this.d_mgr != null;
    }

    protected boolean shouldEnableDelete() {
        return this.d_mgr != null && Delete.testShouldEnable(this.d_md, this.getList().getSelectedIx() > -1);
    }

    protected boolean shouldEnableRename() {
        return this.d_mgr != null && this.getList().getSelectedIx() > -1 && merlin.actions.RenameAction.getIsRenameableFilter(this.d_md).test((INamed)this.getList().getSelectedItem());
    }

    protected boolean shouldEnableImport() {
        return this.d_mgr != null;
    }

    protected boolean shouldEnableOverride() {
        return this.d_mgr != null && this.getList().getSelectedIx() > -1 && this.getMerlinData() != null && !this.getMerlinData().scenarios.getActive().isDefault();
    }

    public static interface IManager<T> {
        public int size();

        public String describe(T var1);

        public Collection<T> getSorted();

        public void filter(Predicate<T> var1);
    }

    private class ManagedListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -414623608016210827L;
        private final Font d_plain = this.getFont();

        private ManagedListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, ManagerDlg.this.d_mgr.describe((ICompElement)((ICompElement)value)), index, isSelected, cellHasFocus);
            if (ManagerDlg.this.d_decorateList) {
                guiUtil.decorateCellRenderer(ManagerDlg.this.d_md, () -> ManagerDlg.this.repaint(), value, this, isSelected, cellHasFocus, true, false);
            } else {
                c.setFont(this.d_plain);
            }
            if (index == ManagerDlg.this.d_edix && ManagerDlg.this.d_editor.isModified()) {
                c.setFont(c.getFont().deriveFont(2));
            }
            return c;
        }
    }

    public class RecordList
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = -1017895551275946059L;
        private final JList<Object> d_list = new JList();
        private final JScrollPane d_jsp;
        private final List<ListSelectionListener> d_listeners;
        private boolean d_suppressNotify;

        public RecordList() {
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(120, 180));
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_jsp, "Center");
            this.d_suppressNotify = false;
            this.d_listeners = new ArrayList<ListSelectionListener>();
        }

        public int getSelectedIx() {
            return this.d_list.getSelectedIndex();
        }

        public T getItem(int ix) {
            return (ICompElement)this.d_list.getModel().getElementAt(ix);
        }

        public T getSelectedItem() {
            int index = this.getSelectedIx();
            if (index >= 0 && index < this.d_list.getModel().getSize()) {
                return this.getItem(index);
            }
            return null;
        }

        public void select(int ix) {
            this.d_list.setSelectedIndex(ix);
            this.valueChanged();
        }

        public void select(T obj) {
            this.d_list.setSelectedValue(obj, true);
            this.valueChanged();
        }

        public void setModel(MgrT mgr, ListCellRenderer<?> ren) {
            this.d_list.setCellRenderer(ren);
            this.d_list.setModel(new DefaultListModel());
            this.updateModelView(mgr);
        }

        public void updateModelView(MgrT mgr) {
            DefaultListModel model = (DefaultListModel)this.d_list.getModel();
            Object selected = this.d_list.getSelectedValue();
            int scrIx = this.d_jsp.getVerticalScrollBar().getValue();
            this.d_suppressNotify = true;
            model.clear();
            for (ICompElement obj : ManagerDlg.this.getModelColl(mgr)) {
                model.addElement(obj);
            }
            this.d_suppressNotify = false;
            int newScrIx = Math.min(scrIx, this.d_jsp.getVerticalScrollBar().getMaximum());
            this.d_jsp.getVerticalScrollBar().setValue(newScrIx);
            if (model.contains(selected)) {
                this.d_list.setSelectedValue(selected, false);
            } else {
                this.d_list.setSelectedIndex(0);
            }
        }

        public void addListener(ListSelectionListener listener) {
            this.d_listeners.add(listener);
        }

        public void removeListener(Object obj) {
            this.d_listeners.remove(obj);
        }

        private void valueChanged() {
            int newIx = this.d_list.getSelectedIndex();
            ListSelectionEvent evt = new ListSelectionEvent(this, newIx, newIx, false);
            this.valueChanged(evt);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.d_suppressNotify) {
                return;
            }
            for (ListSelectionListener obj : this.d_listeners) {
                obj.valueChanged(e);
            }
        }

        public int getNumItems() {
            return this.d_list.getModel().getSize();
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            ManagerDlg.this.d_status = 16;
            ManagerDlg.this.fireButtonPressed(16);
        }
    }

    public class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = -3567948025907869533L;
        private final ActionListener d_listener;

        public NewAction(ActionListener listener) {
            super(Intl.intl("New..."));
            this.d_listener = listener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            this.d_listener.actionPerformed(e);
        }
    }

    protected class RenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 6934870752462657989L;
        private Object d_propName;
        private String d_newMsg;
        private Function<MerlinData, Composite<? super T>> d_getRoot;

        public RenameAction(Object propName, String newMsg, Function<MerlinData, Composite<? super T>> getRoot) {
            super(Intl.intl("Rename..."));
            this.d_propName = propName;
            this.d_newMsg = newMsg;
            this.d_getRoot = getRoot;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            int selIx = ManagerDlg.this.getList().getSelectedIx();
            Object obj = ManagerDlg.this.getList().getItem(selIx);
            MerlinData md = ManagerDlg.this.getMerlinData();
            String suggName = (String)obj.getProperty(this.d_propName);
            String objName = NewObject.promptForName(MerlinApp.getApp().getActiveFrame(), md, suggName, this.d_getRoot.apply(md), ManagerDlg.this.d_clazz, Predicates.alwaysTrue(), this.d_newMsg, this.d_propName);
            if (objName == null || objName.equals(suggName)) {
                return;
            }
            try (MerlinData.WriteLock lock = md.lockWrite();){
                merlin.actions.RenameAction.rename(md, ManagerDlg.this, Arrays.asList(obj), objName);
            }
            ManagerDlg.this.d_editor.init(obj);
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
        }
    }

    protected class LibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;

        public LibraryAction() {
            super(Intl.intl("Add From Library") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            LibraryDlg dlg = new LibraryDlg(ManagerDlg.this.d_owner, ManagerDlg.this.getMerlinData(), () -> ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr));
            dlg.doModal();
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
        }
    }

    protected class DeleteAction
    extends guiAction {
        private static final long serialVersionUID = 719780049719631796L;

        public DeleteAction() {
            super(Intl.intl("Delete..."));
            this.putValue(ManagerDlg.KEY, KeyStroke.getKeyStroke(127, 0, true));
            this.putValue("KEY1", KeyStroke.getKeyStroke(8, 0, true));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ix = ManagerDlg.this.getList().getSelectedIx();
            Object sm = ManagerDlg.this.getList().getItem(ix);
            AMerlinOp op = new AMerlinOp((ICompElement)sm, ix){
                final /* synthetic */ ICompElement val$sm;
                final /* synthetic */ int val$ix;
                {
                    this.val$sm = iCompElement;
                    this.val$ix = n;
                }

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Delete.uiDelete(MerlinApp.getApp(), ManagerDlg.this.getMerlinData(), Arrays.asList(this.val$sm), true);
                    md.ui(() -> {
                        if (ManagerDlg.this.d_md.hierarchy.getParent(this.val$sm) == null) {
                            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
                            ManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                            int newIx = this.val$ix - 1 < 0 && ManagerDlg.this.d_mgr.size() > 0 ? 0 : this.val$ix - 1;
                            ManagerDlg.this.getList().select(newIx);
                            if (newIx == this.val$ix && ManagerDlg.this.getList().getNumItems() > 0) {
                                ManagerDlg.this.d_editor.init(ManagerDlg.this.getList().getItem(newIx));
                            }
                        }
                    });
                }
            };
            UIHook.run(ManagerDlg.this, "ManagerDlg.DeleteAction.actionPerformed", op, 0);
        }
    }
}

