/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import javafx.stage.FileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.MerlinOOS;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.theUtil;

public class LibraryDlg
extends ALibraryDlg<OccProfile> {
    private static final long serialVersionUID = 4159924215120436555L;
    private static final String libExtension = "plib";
    private static final String pthExtension = "pth";
    private final String d_predefinedLibInstallPath;
    private final String d_predefinedLibAppDataPath;
    private static final String CUSTOM_LIB = Intl.intl("Custom");
    private guiComboBox d_predefinedCb;
    private String d_currentLib = "";
    private List<OccProfile> d_libModel;
    private List<OccProfile> d_curModel;
    private MerlinData d_md;
    private boolean d_readOnly;
    private Runnable d_updateMgr;
    private boolean d_cbListenerListening = true;

    public LibraryDlg(JFrame owner, MerlinData md) {
        this(owner, md, null);
    }

    public LibraryDlg(JFrame owner, MerlinData md, Runnable updateMgr) {
        super(owner, Intl.intl("Profile Libraries"));
        this.d_md = md;
        this.d_updateMgr = updateMgr;
        Collection<OccProfile> profiles = md.profiles.flatten(OccProfile.class);
        this.d_curModel = new ArrayList<OccProfile>();
        this.d_curModel.addAll(profiles);
        this.d_libModel = new ArrayList<OccProfile>();
        this.d_predefinedLibInstallPath = new File(MerlinApp.getApp().getInstallDir(), "lib/profiles").getPath();
        this.d_predefinedLibAppDataPath = new File(MerlinApp.getApp().getAppDataDir(), "profiles").getPath();
        this.loadList(this.d_curModel, this.d_modelObjs);
    }

    @Override
    protected void addLibPanel() {
        this.d_predefinedCb = new guiComboBox();
        this.d_predefinedCb.addItemListener(e -> this.listenToCbChanges(e));
        int row = 0;
        this.d_libPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(this.d_libPanel, this.d_libLbl, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_predefinedCb, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_libSP, 0, row++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_newLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_chooseLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_saveLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_libPanel, this.d_deleteLibObjBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
    }

    private void listenToCbChanges(final ItemEvent e) {
        if (e.getStateChange() == 1) {
            Runnable handleSelection = new Runnable(){
                final boolean isListening;
                {
                    this.isListening = LibraryDlg.this.d_cbListenerListening;
                }

                @Override
                public void run() {
                    MerlinApp.getApp().beginWaitCursor();
                    String item = (String)e.getItem();
                    if (this.isListening) {
                        if (LibraryDlg.this.checkSaveNewLib()) {
                            if (item == CUSTOM_LIB) {
                                String curLib = MerlinPrefs.get(MerlinPrefs.LIB_DLG_LAST_LIB);
                                if (curLib != null && LibraryDlg.this.loadLibraryModel(curLib, false)) {
                                    LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                } else {
                                    LibraryDlg.this.resetSelection();
                                }
                            } else {
                                String filePath = new File(LibraryDlg.this.d_predefinedLibInstallPath, item).getPath();
                                if (LibraryDlg.this.loadLibraryModel(filePath, true)) {
                                    LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                } else {
                                    filePath = new File(LibraryDlg.this.d_predefinedLibAppDataPath, item).getPath();
                                    if (LibraryDlg.this.loadLibraryModel(filePath, true)) {
                                        LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                    } else {
                                        LibraryDlg.this.resetSelection();
                                    }
                                }
                            }
                            LibraryDlg.this.d_libUnsaved = false;
                        } else {
                            LibraryDlg.this.setListening(false);
                            LibraryDlg.this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
                            LibraryDlg.this.d_libUnsaved = true;
                            LibraryDlg.this.setListening(true);
                        }
                    }
                    LibraryDlg.this.updateActions();
                    MerlinApp.getApp().endWaitCursor();
                }
            };
            EventQueue.invokeLater(handleSelection);
        }
    }

    private void resetSelection() {
        this.setListening(false);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
        this.d_libModel = new ArrayList<OccProfile>();
        this.loadList(this.d_libModel, this.d_libObjs);
        this.setCurrentLibrary("untitled.plib", false);
        this.setListening(true);
    }

    @Override
    public boolean saveLibrary() {
        File newLibFile = this.serialize(this.d_libModel);
        if (newLibFile == null) {
            return false;
        }
        this.setCurrentLibrary(newLibFile.getAbsolutePath(), false);
        this.d_libUnsaved = false;
        return true;
    }

    private File serialize(List<OccProfile> profiles) {
        MerlinApp app = MerlinApp.getApp();
        guiJFXFileChooser chooser = new guiJFXFileChooser(this.d_md.getNewFilePath(".plib").getFileName().toString(), MerlinPrefs.get(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Library"), "*.plib"));
        File f = chooser.showSaveDialog();
        if (f == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, f.getParent());
        MerlinData tempmd = new MerlinData(false);
        tempmd.profiles.clear();
        tempmd.profiles.addAll(profiles);
        tempmd.setUnitSystem(app.getUnitSystem());
        try (MerlinOOS oos = new MerlinOOS(new FileOutputStream(f));){
            oos.writeObject(tempmd);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    private List<OccProfile> deserialize(String filename, boolean showWarnings) {
        try {
            MerlinIO io = new MerlinIO();
            MerlinIO.OpenResult result = io.openModel(this, filename, (tp, task) -> {}, MerlinOIS.DM_DEFAULT);
            return new ArrayList<OccProfile>(result.data.profiles.flatten(OccProfile.class));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(MerlinApp.getApp().getActiveFrame(), String.format(Intl.intl("The file \"%s\" could not be read."), filename));
            }
            return null;
        }
    }

    public boolean loadLibraryModelFromFile(String filename, boolean showWarnings) {
        List<OccProfile> newLibModel = this.deserialize(filename, showWarnings);
        if (newLibModel != null) {
            this.d_libModel = newLibModel;
        }
        return newLibModel != null;
    }

    @Override
    protected boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Profile Library"), "*.plib"), new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Model File (Read-only)"), "*.pth"));
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        MerlinPrefs.set(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, f.getParent());
        return this.loadLibraryModel(f.getAbsolutePath(), false);
    }

    @Override
    protected void loadLibraryUI() {
        this.loadList(this.d_libModel, this.d_libObjs);
        this.setListening(false);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
        this.setListening(true);
        this.d_libUnsaved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLibraryModel(String filename, boolean predefined) {
        try {
            this.beginWaitCursor();
            if (!this.loadLibraryModelFromFile(filename, true)) {
                boolean bl = false;
                return bl;
            }
            this.setCurrentLibrary(filename, predefined);
            boolean bl = true;
            return bl;
        }
        finally {
            this.endWaitCursor();
        }
    }

    private void setCurrentLibrary(String lib, boolean predefined) {
        this.d_currentLib = lib;
        File f = new File(this.d_currentLib);
        boolean bl = this.d_readOnly = predefined || !FilenameManager.splitFilename(lib)[1].toLowerCase().equals(libExtension);
        if (this.d_readOnly && !predefined) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("Library %s is open for reading only."), f.getName()), Intl.intl("Read-only Access"), 1);
        }
        String libLabel = String.format(Intl.intl("Library: %s"), f.getName());
        String fullLabel = String.format(Intl.intl("Library: %s"), f.getAbsolutePath());
        this.d_libLbl.setText(libLabel);
        this.d_libLbl.setToolTipText(fullLabel);
        if (!predefined) {
            MerlinPrefs.set(MerlinPrefs.LIB_DLG_LAST_LIB, lib);
        }
    }

    private void setListening(boolean listening) {
        this.d_cbListenerListening = listening;
    }

    @Override
    protected void saveToLibrary() {
        Application.getApp().beginWaitCursor();
        if (!this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
        Application.getApp().endWaitCursor();
    }

    @Override
    protected void loadFromLibrary() {
        Application.getApp().beginWaitCursor();
        List<OccProfile> added = this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_curModel);
        if (!added.isEmpty()) {
            this.d_md.pauseUpdates();
            Undo.begin(Intl.intl("New Profile"));
            AddObject.add(this.d_md, this.d_md.profiles, this.d_md.profiles.flatten().size(), added);
            for (OccProfile prof : added) {
                OccProfile.OccShape occShape = (OccProfile.OccShape)prof.getProperty(OccProfile.PROP_SHAPE);
                if (!occShape.type.equals((Object)VehicleShape.ShapeType.POLYGON)) continue;
                VehicleShape vs = occShape.vehicleShape;
                String newName = this.getNewName(vs, this.d_md.vehicleShapes.flatten(VehicleShape.class));
                VehicleShape newVs = vs.clone();
                if (!newName.equals(vs.getName())) {
                    newVs.setName(newName);
                }
                occShape = occShape.modifyVehicleShape(newVs);
                prof.setProperty(OccProfile.PROP_SHAPE, occShape);
                AddObject.add((MerlinData)this.d_md, (Composite)this.d_md.vehicleShapes, (int)this.d_md.vehicleShapes.flatten().size(), (ICompElement[])new VehicleShape[]{newVs});
            }
            Undo.end(this.d_md);
            this.d_md.resumeUpdates();
        }
        Application.getApp().endWaitCursor();
    }

    @Override
    public void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new ArrayList<OccProfile>();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.plib", false);
        this.setListening(false);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
        this.setListening(true);
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    public List<OccProfile> copyListSelection(JList<OccProfile> jlistBeingCopied, JList<OccProfile> jlistCopiedTo, List<OccProfile> containerCopiedTo) {
        List<OccProfile> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<OccProfile, OccProfile> replacements = new LinkedHashMap<OccProfile, OccProfile>();
        for (OccProfile prof : objsToCopy) {
            String newName = this.getNewName(prof, containerCopiedTo);
            OccProfile newProf = prof.clone();
            if (!newName.equals(prof.getName())) {
                newProf.setName(newName);
            }
            replacements.put(prof, newProf);
        }
        for (OccProfile prof : replacements.keySet()) {
            int replIndex = objsToCopy.indexOf(prof);
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (OccProfile)replacements.get(prof));
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo);
        return objsToCopy;
    }

    private String getNewName(INamed namedObj, Collection<? extends INamed> containerCopiedTo) {
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        boolean alreadyExists = false;
        do {
            alreadyExists = false;
            for (INamed iNamed : containerCopiedTo) {
                if (!iNamed.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    private void loadList(List<OccProfile> from, JList<OccProfile> to) {
        to.setListData((OccProfile[])theUtil.toArray(from, OccProfile.class));
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        guiUtil.decorateCellRenderer(this.d_md, list::repaint, value, r, isSelected, cellHasFocus, true, true);
        OccProfile obj = (OccProfile)value;
        r.setText(obj.getName());
    }

    @Override
    protected void deleteModObjs() {
        final List objs = this.d_modelObjs.getSelectedValuesList();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                Delete.uiDelete(MerlinApp.getApp(), md, new HashSet(objs), true);
                LibraryDlg.this.d_curModel.clear();
                LibraryDlg.this.d_curModel.addAll(LibraryDlg.this.d_md.profiles.flatten(OccProfile.class));
                LibraryDlg.this.loadList(LibraryDlg.this.d_curModel, LibraryDlg.this.d_modelObjs);
                if (LibraryDlg.this.d_updateMgr != null) {
                    LibraryDlg.this.d_updateMgr.run();
                }
            }
        };
        UIHook.run(this, "LibraryDlg.DeleteAction.actionPerformed", op, 0);
    }

    @Override
    protected void deleteLibObjs() {
        if (this.deleteObjs(this.d_libObjs, this.d_libModel)) {
            this.d_libUnsaved = true;
        }
    }

    private boolean deleteObjs(JList<OccProfile> jlist, List<OccProfile> domain) {
        List<OccProfile> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        domain.removeAll(objs);
        this.loadList(domain, jlist);
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            if (!this.checkSaveNewLib()) {
                return;
            }
        } else {
            this.init();
        }
        super.setVisible(visible);
    }

    private void init() {
        MerlinApp.getApp().beginWaitCursor();
        this.loadPredefinedLibraries();
        MerlinApp.getApp().endWaitCursor();
    }

    private void loadPredefinedLibraries() {
        File[] installFolderFiles = new File(this.d_predefinedLibInstallPath).listFiles();
        File[] appDataFiles = new File(this.d_predefinedLibAppDataPath).listFiles();
        Consumer<File[]> processFiles = files -> {
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(libExtension)) continue;
                this.d_predefinedCb.add(f.getName());
            }
        };
        processFiles.accept(installFolderFiles);
        processFiles.accept(appDataFiles);
        this.d_predefinedCb.add(CUSTOM_LIB);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
    }
}

