/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.MerlinComboBox;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class ElevatorFloorComboBox
extends MerlinComboBox<Floor> {
    private Collection<Elevator> elevators;

    public ElevatorFloorComboBox(MerlinData md) {
        super(md, Floor.class, (IMerlinObj[])new Floor[0]);
        this.setNullName(Intl.intl("Discharge Floor"));
        this.setElevators(md.elevators.flatten(Elevator.class));
    }

    @Override
    protected List<Floor> getItems(MerlinData md) {
        this.elevators = this.elevators == null ? md.elevators.flatten(Elevator.class) : this.elevators;
        List sortedFloors = this.elevators.stream().flatMap(e -> e.getFloorLevelMap().keySet().stream()).distinct().sorted((f1, f2) -> f1.getWorkingZ().compareTo(f2.getWorkingZ(), 1.0E-6)).collect(Collectors.toList());
        sortedFloors.add(0, null);
        return new ArrayList<Floor>(theUtil.filter(sortedFloors, this.getFilter()));
    }

    public void setElevators(Collection<Elevator> elevators) {
        this.elevators = elevators;
        this.setFilter(this.getFilter());
    }

    private Predicate<Floor> getFilter() {
        if (this.elevators == null || this.elevators.size() == 0) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<Floor>(){

            @Override
            public boolean test(Floor floor) {
                ArrayList<Floor> floors = new ArrayList<Floor>();
                for (Elevator e : ElevatorFloorComboBox.this.elevators) {
                    if (e.getDomain() == null) continue;
                    floors.addAll(e.getFloorLevelMap().keySet());
                }
                return floors.contains(floor) || floor == null;
            }
        };
    }
}

