/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.DistributionDialog;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.value.APopupValEditor;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class DistributionEditor<T extends IMerlinObj>
extends APopupValEditor<IUrn<T>>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private static final int SHOW_SEL_CROSSOVER = 10;
    private final MerlinData d_data;
    private boolean d_modified = false;
    private final JEditorPane d_editor;
    private final String d_desc;
    private final Composite<? extends ICompElement> d_root;
    private final Class<T> d_clazz;
    private final Predicate<T> d_filter;
    private List<T> d_availObjs;
    private Function<MerlinData, Collection<T>> d_getExtraObjs;

    public DistributionEditor(MerlinData md, String desc, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<T> availFilter) {
        super(IUrn.class);
        this.d_data = md;
        this.d_desc = desc;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.getHtmlLabel("", e -> this.editValue());
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
        this.d_editor.setPreferredSize(new Dimension(160, this.d_editor.getPreferredSize().height));
        this.setValue(UrnUtil.newUrn(Collections.emptyMap()));
        this.updateAvailable();
        this.setModified(false);
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this.d_editor, 1.0);
    }

    @Override
    public boolean editValue() {
        IUrn val = (IUrn)this.getValue();
        this.updateAvailable();
        boolean showSelDef = this.d_availObjs.size() > 10 && val != null && val.getWeights().values().stream().anyMatch(d -> d != 0.0);
        ArrayList modelData = new ArrayList();
        if (!this.d_availObjs.isEmpty()) {
            Map<Object, Object> valuesMap = val != null ? val.getWeights() : Collections.emptyMap();
            for (IMerlinObj obj : this.d_availObjs) {
                Double weight = valuesMap.getOrDefault(obj, 0.0);
                modelData.add(new Pair<Double, IMerlinObj>(weight, obj));
            }
        }
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        DistributionDialog dlg = new DistributionDialog(parent, this.d_desc, modelData, this.d_root, this.d_getExtraObjs, showSelDef);
        this.applyButtonLabels(dlg);
        if (dlg.doModal() != 1) {
            return false;
        }
        this.setValue(UrnUtil.newUrn(dlg.getDistributionData()));
        return true;
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    public void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        IUrn val = (IUrn)this.getValue();
        if (val != null && !this.d_availObjs.isEmpty()) {
            Map weights = val.getWeights();
            LinkedIdentityHashMap distribution = new LinkedIdentityHashMap(weights);
            distribution.keySet().retainAll(new IdentityHashSet<T>(this.d_availObjs));
            double total = DistributionEditor.sum(distribution.values());
            if (theUtil.lt(total, 1.0, 1.0E-6)) {
                assert (!this.d_availObjs.isEmpty());
                IMerlinObj firstObj = (IMerlinObj)this.d_availObjs.get(0);
                double fracForFirst = distribution.containsKey(firstObj) ? (Double)distribution.get(firstObj) : 0.0;
                double remain = 1.0 - (total -= fracForFirst);
                distribution.put(firstObj, remain);
            }
            this.setValue(UrnUtil.newUrn(distribution));
        }
        this.updateDesc();
    }

    public void setExtraObjs(Function<MerlinData, Collection<T>> getExtraObjs) {
        this.d_getExtraObjs = getExtraObjs;
    }

    private static double sum(Collection<Double> values) {
        double total = 0.0;
        for (Double frac : values) {
            total += frac.doubleValue();
        }
        return total;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    private List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, ObjSorter.INSTANCE);
        if (this.d_getExtraObjs != null) {
            ArrayList<T> allObjs = new ArrayList<T>(theUtil.filter(this.d_getExtraObjs.apply((MerlinData)this.d_root.getDomain()), this.d_filter));
            allObjs.addAll(all);
            all = allObjs;
        }
        return all;
    }

    public List<T> getAvailable() {
        return this.d_availObjs;
    }

    public void setAvailable(List<T> avail) {
        this.d_availObjs = avail;
        this.updateDesc();
    }

    @Override
    public void loadValue(IUrn<T> value) {
        this.updateDesc();
    }

    @Override
    protected IUrn<T> saveValue(Mediator domain) {
        return (IUrn)this.getValue();
    }

    protected void updateDesc() {
        boolean isShortened;
        Map dist;
        String desc = null;
        Map map = dist = this.getValue() != null ? ((IUrn)this.getValue()).getWeights() : null;
        if (dist == null) {
            desc = Intl.intl("[mixed]");
        } else if (dist.isEmpty()) {
            desc = Intl.intl("[none]");
        } else if (dist.size() == 1) {
            desc = MerlinUtil.getName((IMerlinObj)dist.keySet().iterator().next());
        } else {
            ArrayList objList = new ArrayList(dist.keySet());
            Collections.sort(objList, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    double frac1 = (Double)dist.get(o1);
                    double frac2 = (Double)dist.get(o2);
                    int comp = Double.compare(frac2, frac1);
                    if (comp != 0) {
                        return comp;
                    }
                    comp = MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
                    return comp;
                }
            });
            StringBuffer descBuffer = new StringBuffer();
            for (IMerlinObj obj : objList) {
                if (!descBuffer.isEmpty()) {
                    descBuffer.append("; ");
                }
                descBuffer.append(String.format(Intl.intl("%.1f%% %s"), dist.get(obj) * 100.0, MerlinUtil.getName(obj)));
            }
            desc = descBuffer.toString();
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = thunderheadeng.gui.guiUtil.shorten(desc, 150, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (this.d_availObjs.size() > 1 || dist != null && dist.isEmpty() && !this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText(desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.updateDesc();
    }

    private static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        private ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

