/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.SearchField;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.leanGuiTable;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DistributionDialog<T extends IMerlinObj>
extends guiDialog
implements Validateable {
    private static final long serialVersionUID = 1L;
    private final leanGuiTable d_table;
    private final Composite<? extends ICompElement> d_root;
    private final SearchField<T> d_searchFld;
    private final guiCheckBox d_showOnlyNonZero;
    private final guiCheckBox d_showPathBox;
    private final HTMLBtn d_showingCountLbl;
    private final guiLabel d_statusMsg;
    private TableRowSorter<TableModel> d_nonZeroRowSorter;

    public DistributionDialog(Window parent, String desc, List<Pair<Double, T>> modelData, Composite<? extends ICompElement> root, final Function<MerlinData, Collection<T>> getExtraObjs, boolean showOnlySelDef) {
        super(parent, desc, 9);
        this.d_root = root;
        this.d_showOnlyNonZero = new guiCheckBox(Intl.intl("Display only non-zero rows"), showOnlySelDef);
        this.d_showOnlyNonZero.setToolTipText(Intl.intl("If checked, only rows with non-zero distributions are displayed. Uncheck to display all available rows."));
        this.d_showPathBox = new guiCheckBox(Intl.intl("Show group labels"), false);
        this.d_showPathBox.setToolTipText(Intl.intl("If checked, group labels are shown with the names of the objects."));
        ArrayList convertedData = new ArrayList();
        convertedData = modelData.stream().map(pear -> new Pair<Double, IMerlinObj>((Double)pear.v1 * 100.0, (IMerlinObj)pear.v2)).collect(Collectors.toList());
        ObjTableModel tm = new ObjTableModel(convertedData);
        this.d_table = new leanGuiTable(tm, 0);
        this.d_table.setRowSelectionAllowed(true);
        this.d_table.setColumnSelectionAllowed(true);
        this.d_table.getColumnModel().getColumn(0).setHeaderValue(Intl.intl("%"));
        this.d_showPathBox.addItemListener(e -> this.getModel().fireTableRowsUpdated(0, this.getModel().getRowCount() - 1));
        JButton evenDistBtn = new JButton(Intl.intl("Distribute Evenly..."));
        evenDistBtn.addActionListener(e -> this.distributeEvenly(evenDistBtn));
        JButton clearBtn = new JButton(Intl.intl("Clear..."));
        clearBtn.addActionListener(e -> this.clearDistribution(clearBtn));
        this.d_searchFld = new SearchField<IMerlinObj>(() -> tm.getAllModelObjects().stream(), obj -> this.format(obj));
        this.d_searchFld.addObserver((o, evt) -> {
            if (evt.equals(SearchField.SHOW_ALL_MATCHES)) {
                this.d_showOnlyNonZero.setSelected(false);
            }
            this.updateRowFilter();
            this.updateTableHyperlink();
        }, false);
        this.d_nonZeroRowSorter = new TableRowSorter(tm);
        this.d_nonZeroRowSorter.setComparator(1, (a, b) -> this.format((IMerlinObj)a).compareTo(this.format((IMerlinObj)b)));
        this.d_table.setRowSorter(null);
        this.d_table.setRowSorter(this.d_nonZeroRowSorter);
        this.d_showOnlyNonZero.addActionListener(e -> {
            this.updateRowFilter();
            this.updateTableHyperlink();
        });
        this.d_showingCountLbl = new HTMLBtn("");
        this.d_showingCountLbl.setToolTipText(Intl.intl("Click to display all."));
        this.d_showingCountLbl.addActionListener(e -> {
            if (this.d_showOnlyNonZero.isSelected() || !this.d_searchFld.isEmpty()) {
                this.d_searchFld.clear();
            }
            this.d_showOnlyNonZero.setSelected(false);
            this.updateRowFilter();
            this.updateTableHyperlink();
        });
        TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
        objCol.setHeaderValue(desc);
        objCol.setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (getExtraObjs != null && ((Collection)getExtraObjs.apply((MerlinData)DistributionDialog.this.d_root.getDomain())).contains(value)) {
                    comp.setFont(comp.getFont().deriveFont(2));
                }
                this.setText(DistributionDialog.this.format((IMerlinObj)value));
                return comp;
            }
        });
        this.d_statusMsg = new guiLabel("");
        this.d_statusMsg.setForeground(Color.BLACK);
        this.d_statusMsg.setFont(this.d_statusMsg.getFont().deriveFont(1));
        this.d_table.getModel().addTableModelListener(e -> this.updateTableStatusMessage());
        JScrollPane sp = new JScrollPane(this.d_table);
        sp.setPreferredSize(new Dimension(150, 120));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addFilledRow(this.d_searchFld);
        gb.addRow(sp, new double[]{1.0, 1.0}, 0);
        gb.addFilledRow(this.d_statusMsg);
        gb.addRow(clearBtn, evenDistBtn);
        gb.addFilledRow(this.d_showingCountLbl);
        gb.addRow(this.d_showOnlyNonZero, 0);
        gb.addRow(this.d_showPathBox, 0);
        this.updateTableHyperlink();
        this.updateTableStatusMessage();
        this.setResizable(true);
        this.updateRowFilter();
        this.updateTableHyperlink();
    }

    private void updateTableStatusMessage() {
        double percent = this.getModel().getSum();
        this.d_statusMsg.setText(String.format(Intl.intl("Total distribution: %.1f%%"), percent));
    }

    private void updateRowFilter() {
        RowFilter<TableModel, Integer> rf = new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                IFilteredCollection objs;
                Double val;
                Object object;
                if (!DistributionDialog.this.d_showOnlyNonZero.isSelected() && DistributionDialog.this.d_searchFld.isEmpty()) {
                    return true;
                }
                boolean show = true;
                if (DistributionDialog.this.d_showOnlyNonZero.isSelected() && (object = entry.getValue(0)) instanceof Double && (val = (Double)object) == 0.0) {
                    show = false;
                }
                if (!DistributionDialog.this.d_searchFld.isEmpty() && !(objs = theUtil.filter(DistributionDialog.this.getModel().getAllModelObjects(), DistributionDialog.this.d_searchFld.getFilter())).contains(entry.getValue(1))) {
                    show = false;
                }
                return show;
            }
        };
        this.d_nonZeroRowSorter.setRowFilter(rf);
    }

    private ObjTableModel<T> getModel() {
        return (ObjTableModel)this.d_table.getModel();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        return this.getModel().validateDistData(this, showWarn, allowModify);
    }

    private List<T> getSelectedItems() {
        int[] selRows = this.d_table.getSelectedRows();
        ArrayList<IMerlinObj> items = new ArrayList<IMerlinObj>(selRows.length);
        for (int selRow : selRows) {
            items.add((IMerlinObj)this.getModel().getValueAt(this.d_nonZeroRowSorter.convertRowIndexToModel(selRow), 1));
        }
        return items;
    }

    private List<T> getViewItems() {
        ArrayList<IMerlinObj> items = new ArrayList<IMerlinObj>(this.d_table.getRowCount());
        for (int i = 0; i < this.d_table.getRowCount(); ++i) {
            items.add((IMerlinObj)this.getModel().getValueAt(this.d_nonZeroRowSorter.convertRowIndexToModel(i), 1));
        }
        return items;
    }

    private void getActionItems(Component c, List<Action> additionalActions, String selName, String visName, String allName, Consumer<Collection<T>> consumer) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(additionalActions);
        if (this.d_table.getSelectedRowCount() > 0) {
            actions.add(new guiAction(selName, e -> consumer.accept(this.getSelectedItems())));
        }
        if (this.d_table.getRowSorter().getViewRowCount() < this.d_table.getRowSorter().getModelRowCount()) {
            actions.add(new guiAction(visName, e -> consumer.accept(this.getViewItems())));
        }
        actions.add(new guiAction(allName, e -> consumer.accept(this.getModel().getAllModelObjects())));
        if (actions.size() > 1) {
            JPopupMenu menu = new JPopupMenu();
            for (Action action : actions) {
                menu.add(action);
            }
            menu.show(c, 0, c.getHeight());
        } else {
            ((Action)actions.get(0)).actionPerformed(null);
        }
    }

    private void distributeEvenly(Component c) {
        ArrayList<Action> additionalActions = new ArrayList<Action>();
        double sum = this.getModel().getSum();
        BiConsumer<Collection, Double> distRemaining = (items, remaining) -> {
            if (items.isEmpty()) {
                return;
            }
            ArrayList<Object> changedIndices = new ArrayList();
            ArrayList<Integer> clearedIndices = new ArrayList<Integer>();
            boolean isFullDist = theUtil.eq(remaining, 100.0, 1.0E-6);
            double dist = remaining / (double)items.size();
            changedIndices = isFullDist ? this.getModel().setDistributionsForEachObject((Collection<T>)items, dist) : this.getModel().addDistributionsForEachObject((Collection<T>)items, dist);
            ArrayList<T> sub = new ArrayList<T>(this.getModel().getAllModelObjects());
            if (sub.removeAll((Collection<?>)items) && isFullDist) {
                clearedIndices = this.getModel().setDistributionsForEachObject(sub, 0.0);
            }
            changedIndices.forEach((Consumer<Object>)((Consumer<Integer>)i -> this.getModel().fireTableCellUpdated((int)i, 0)));
            clearedIndices.forEach(i -> this.getModel().fireTableCellUpdated((int)i, 0));
        };
        double remaining2 = 100.0 - sum;
        if (theUtil.lt(sum, 100.0, 1.0E-6) && sum > 0.0) {
            if (this.d_table.getSelectedRowCount() > 0) {
                additionalActions.add(new guiAction(String.format(Intl.intl("Distribute remaining %.1f%% to selected rows"), remaining2), e -> distRemaining.accept(this.getSelectedItems(), remaining2)));
            }
            if (this.d_table.getRowSorter().getViewRowCount() < this.d_table.getRowSorter().getModelRowCount()) {
                additionalActions.add(new guiAction(String.format(Intl.intl("Distribute remaining %.1f%% to displayed rows"), remaining2), e -> distRemaining.accept(this.getViewItems(), remaining2)));
            }
        }
        this.getActionItems(c, additionalActions, Intl.intl("Distribute 100.0% to selected rows"), Intl.intl("Distribute 100.0% to displayed rows"), Intl.intl("Distribute 100.0% to all rows"), items -> distRemaining.accept((Collection)items, 100.0));
    }

    private void clearDistribution(Component c) {
        this.getActionItems(c, Collections.emptyList(), Intl.intl("Clear selected rows"), Intl.intl("Clear displayed rows"), Intl.intl("Clear all rows"), items -> {
            if (items.isEmpty()) {
                return;
            }
            ArrayList<Integer> clearedItems = this.getModel().setDistributionsForEachObject((Collection<T>)items, 0.0);
            clearedItems.forEach(i -> this.getModel().fireTableCellUpdated((int)i, 0));
        });
    }

    private String format(T mobj) {
        if (this.d_showPathBox.isSelected()) {
            return MerlinUtil.getNameWithBreadcrumbs(this.d_root, mobj);
        }
        return MerlinUtil.getName(mobj);
    }

    public Map<T, Double> getDistributionData() {
        return this.getModel().getDistributionData();
    }

    private void updateTableHyperlink() {
        if (this.d_showOnlyNonZero.isSelected() || !this.d_searchFld.isEmpty()) {
            this.d_showingCountLbl.setText(String.format(Intl.intl("Displaying %1$d/%2$d rows"), this.d_table.getRowCount(), this.d_table.getModel().getRowCount()));
            this.d_showingCountLbl.setVisible(true);
        } else {
            this.d_showingCountLbl.setVisible(false);
        }
    }

    protected class ObjTableModel<T>
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Pair<Double, T>> d_modelData;

        public ObjTableModel() {
            this(Collections.emptyList());
        }

        public ObjTableModel(List<Pair<Double, T>> data) {
            this.d_modelData = data;
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Double.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public int getRowCount() {
            return this.d_modelData.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        private Map<T, Double> getDistributionData() {
            HashMap data = new HashMap();
            for (Pair<Double, T> item : this.d_modelData) {
                if ((Double)item.v1 == 0.0) continue;
                data.put(item.v2, (Double)item.v1 / 100.0);
            }
            return Collections.unmodifiableMap(data);
        }

        protected Collection<T> getAllModelObjects() {
            return this.d_modelData.stream().map(p -> p.v2).collect(Collectors.toList());
        }

        protected boolean validateDistData(Component parent, boolean showWarn, boolean allowModify) {
            Iterator<Pair<Double, T>> iter = this.d_modelData.iterator();
            while (iter.hasNext()) {
                double val = (Double)iter.next().v1;
                if (!(val < 0.0) && !(val > 100.0)) continue;
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(parent, Intl.intl("Each percentage must be >= 0 and <= 100."));
                }
                return false;
            }
            double totalPercent = this.getSum();
            if (!theUtil.eq(totalPercent, 100.0, 1.0E-6)) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(parent, Intl.intl("The total distribution must add to 100%."));
                }
                return false;
            }
            return true;
        }

        private boolean isTableFiltered(int rowIndex) {
            return DistributionDialog.this.d_nonZeroRowSorter.getViewRowCount() != DistributionDialog.this.d_nonZeroRowSorter.getModelRowCount() && rowIndex < DistributionDialog.this.d_nonZeroRowSorter.getViewRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.d_modelData.get((int)rowIndex).v1;
            }
            return this.d_modelData.get((int)rowIndex).v2;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ArrayList<Integer> viewUpdated = new ArrayList<Integer>();
            if (columnIndex == 0 && (aValue instanceof Double || aValue == null)) {
                double dVal = aValue == null ? 0.0 : (Double)aValue;
                Double dist = (Double)this.d_modelData.get((int)rowIndex).v1;
                Object obj = this.d_modelData.get((int)rowIndex).v2;
                if (dist.equals(dVal)) {
                    return;
                }
                this.d_modelData.set(rowIndex, new Pair(dVal, obj));
                viewUpdated.add(rowIndex);
            }
            viewUpdated.forEach(i -> this.fireTableCellUpdated((int)i, columnIndex));
        }

        protected double getSum() {
            double sum = 0.0;
            for (Pair<Double, T> par : this.d_modelData) {
                sum += ((Double)par.v1).doubleValue();
            }
            return sum;
        }

        protected ArrayList<Integer> setDistributionsForEachObject(Collection<T> objs, Double newDist) {
            return this.modDistributionForEachObject(objs, newDist, false);
        }

        protected ArrayList<Integer> addDistributionsForEachObject(Collection<T> objs, Double newDist) {
            return this.modDistributionForEachObject(objs, newDist, true);
        }

        private ArrayList<Integer> modDistributionForEachObject(Collection<T> objs, Double newDist, boolean add) {
            if (DistributionDialog.this.d_table.isEditing()) {
                DistributionDialog.this.d_table.getCellEditor().cancelCellEditing();
            }
            ArrayList<Integer> viewUpdated = new ArrayList<Integer>();
            this.d_modelData.forEach(pair -> {
                if (objs.contains(pair.v2)) {
                    int ix = this.d_modelData.indexOf(pair);
                    this.d_modelData.set(ix, new Pair(add ? (Double)pair.v1 + newDist : newDist, pair.v2));
                    int viewIx = DistributionDialog.this.d_nonZeroRowSorter.convertRowIndexToView(ix);
                    if (viewIx >= 0 && viewIx < DistributionDialog.this.d_nonZeroRowSorter.getViewRowCount()) {
                        viewUpdated.add(ix);
                    }
                }
            });
            return viewUpdated;
        }
    }
}

