/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AssistedEvacTeam;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.WrappedComp;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.CmdButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class AssistedEvacTeamsPanel
extends guiPanel
implements IEditor<AssistedEvacTeam> {
    private static final long serialVersionUID = 2301484831104927628L;
    private final JFrame d_owner;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final MerlinData d_md;
    private final guiComboBox<Priority> d_cbOccsOrder;
    private final guiListEditor d_agentOrderList;
    private final guiListEditor d_allAgentsList;
    private final guiListEditor d_assistants;
    private final guiListEditor d_clients;
    private AssistedEvacTeam d_dataObj;
    private boolean d_isModified = false;

    public AssistedEvacTeamsPanel(JFrame owner, ILabelGenerator labels) {
        this.setLayout(new GridBagLayout());
        this.d_md = MerlinApp.getApp().getData();
        this.d_owner = owner;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        WrappedComp<guiLabel> nameLbl = labels.lbl(AssistedEvacTeam.PROP_NAME);
        WrappedComp<guiLabel> descLbl = labels.lbl(AssistedEvacTeam.PROP_DESC);
        WrappedComp<guiLabel> nonListPriorityLbl = labels.lbl(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER);
        WrappedComp<guiLabel> priorityLbl = labels.lbl(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, Intl.intl("Client Priority"), "");
        WrappedComp<guiLabel> allAgentsLbl = labels.lbl(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, Intl.intl("Select occupants to be added"), "");
        WrappedComp<guiLabel> clientsLbl = labels.lbl(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, Intl.intl("Occupants requesting assistance from this team"), "");
        WrappedComp<guiLabel> assistentsLbl = labels.lbl(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, Intl.intl("Occupants assisting this team"), "");
        this.d_agentOrderList = new guiListEditor(priorityLbl, true, true, false);
        this.d_allAgentsList = new guiListEditor(allAgentsLbl, false, false, true);
        this.d_clients = new guiListEditor(clientsLbl, false, false, false);
        this.d_assistants = new guiListEditor(assistentsLbl, false, false, false);
        this.d_cbOccsOrder = new guiComboBox<Priority>(Priority.values());
        this.d_cbOccsOrder.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 8827736446601217852L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Priority p = (Priority)((Object)value);
                this.setText(p.name);
                this.setToolTipText(p.tt);
                return this;
            }
        });
        this.d_cbOccsOrder.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.d_cbOccsOrder.setToolTipText(this.d_cbOccsOrder.getSelectedItem().tt);
        });
        guiPanel priorityDistPnl = new guiPanel(new GridBagLayout());
        guiPanel priorityListPnl = new guiPanel(new BorderLayout());
        priorityListPnl.add((Component)this.d_agentOrderList, "Center");
        CardLayout cardLayout = new CardLayout();
        guiPanel cardPanel = new guiPanel(cardLayout);
        cardPanel.add((Component)priorityDistPnl, Priority.DISTANCE.name);
        cardPanel.add((Component)priorityListPnl, Priority.LIST.name);
        JTabbedPane tb = new JTabbedPane();
        guiPanel priorityPnl = new guiPanel(new GridBagLayout());
        GridBagHelper gb = new GridBagHelper(priorityPnl);
        gb.addRow(nonListPriorityLbl, this.d_cbOccsOrder, 0);
        gb.addFilledRow(new guiSeparator());
        gb.addRow(cardPanel, new double[]{1.0, 1.0}, new int[]{0, 0});
        priorityPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        Function<guiListEditor, guiPanel> newListPanel = list -> {
            guiPanel pnl = new guiPanel(new GridBagLayout());
            GridBagHelper gb2 = new GridBagHelper(pnl);
            gb2.addRow(list, new double[]{1.0, 1.0}, 0);
            pnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            return pnl;
        };
        tb.addTab(Intl.intl("Priority"), priorityPnl);
        tb.addTab(Intl.intl("Assistants"), newListPanel.apply(this.d_assistants));
        tb.addTab(Intl.intl("Clients"), newListPanel.apply(this.d_clients));
        gb = new GridBagHelper(this);
        gb.addRow(nameLbl, this.d_name, 1.0, GridBagHelper.REMAINING);
        gb.addRow(descLbl, this.d_desc, 1.0, GridBagHelper.REMAINING);
        gb.addRow(tb, new int[]{0, 0}, new double[]{1.0, 1.0});
        this.d_cbOccsOrder.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            Priority selItem = this.d_cbOccsOrder.getSelectedItem();
            cardLayout.show(cardPanel, selItem.name);
            this.d_isModified = true;
        });
        this.d_cbOccsOrder.setSelectedItem((Object)Priority.DISTANCE);
    }

    @Override
    public void init(AssistedEvacTeam dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            this.d_name.setText(dataObj.getProperty(AssistedEvacTeam.PROP_NAME));
            this.d_desc.setText(dataObj.getProperty(AssistedEvacTeam.PROP_DESC));
            List<EgressAgent> order = dataObj.getProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER);
            if (order.isEmpty()) {
                this.d_cbOccsOrder.setSelectedItem((Object)Priority.DISTANCE);
            } else {
                this.d_cbOccsOrder.setSelectedItem((Object)Priority.LIST);
            }
            Collection<EgressAgent> allAgents = md.agents.flatten(EgressAgent.class);
            this.loadClients(allAgents, order, dataObj);
            this.loadAssistants(allAgents, dataObj);
            this.d_dataObj = dataObj;
        }
        this.setEnabled(dataObj != null);
        this.setModified(false);
        this.repaint();
    }

    @Override
    public AssistedEvacTeam commit(final AssistedEvacTeam dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Edit Assisted Evacuation Team"));
                        Undo.insertUndoEntry_restore(md, dataObj);
                        dataObj.setProperty(AssistedEvacTeam.PROP_DESC, AssistedEvacTeamsPanel.this.d_desc.getText());
                        if (AssistedEvacTeamsPanel.this.d_cbOccsOrder.getSelectedItem() == Priority.DISTANCE) {
                            dataObj.setProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, new ArrayList());
                        } else {
                            dataObj.setProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, AssistedEvacTeamsPanel.this.d_agentOrderList.save());
                        }
                        Undo.end(MerlinApp.getApp().getData());
                    }
                }
            };
            UIHook.run(this, "AssistedEvacTeamsPanel.commit", op, 0);
        }
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public boolean isModified() {
        return this.d_isModified || super.isModified();
    }

    @Override
    public void setModified(boolean isModified) {
        this.d_isModified = isModified;
        super.setModified(isModified);
    }

    public void loadClients(Collection<EgressAgent> allAgents, List<EgressAgent> agentOrder, AssistedEvacTeam team) {
        ArrayList<EgressAgent> clients = new ArrayList<EgressAgent>();
        IdentityHashMap behaviors = new IdentityHashMap();
        Function<Behavior, Boolean> isTeamClient = behavior -> {
            for (WaitForAssistance ao : behavior.flatten(WaitForAssistance.class)) {
                if (!ao.getTeamFilter().test(team)) continue;
                return true;
            }
            return false;
        };
        allAgents.forEach(agent -> {
            boolean client = (Boolean)behaviors.computeIfAbsent(agent.getBehavior(), isTeamClient);
            if (client) {
                clients.add((EgressAgent)agent);
            }
        });
        this.d_clients.load(clients, team);
        this.d_agentOrderList.load(agentOrder, team);
        this.d_allAgentsList.load(allAgents, team);
    }

    private void loadAssistants(Collection<EgressAgent> allAgents, AssistedEvacTeam team) {
        ArrayList<EgressAgent> assistants = new ArrayList<EgressAgent>();
        IdentityHashMap behaviors = new IdentityHashMap();
        Function<Behavior, Boolean> joinsTeam = behavior -> {
            for (AssistOccupants ao : behavior.flatten(AssistOccupants.class)) {
                if (ao.get(AssistOccupants.TEAM) != team) continue;
                return true;
            }
            return false;
        };
        allAgents.forEach(agent -> {
            boolean teamPlayer = (Boolean)behaviors.computeIfAbsent(agent.getBehavior(), joinsTeam);
            if (teamPlayer) {
                assistants.add((EgressAgent)agent);
            }
        });
        this.d_assistants.load(assistants, team);
    }

    public class guiListEditor
    extends guiPanel {
        private static final long serialVersionUID = 2300576624701571051L;
        private final FilteredListModel<EgressAgent> d_listModel;
        private JList<EgressAgent> d_list;
        private CmdButton d_rowUp;
        private CmdButton d_rowDown;
        private CmdButton d_removeBtn;
        private JButton d_addBtn;
        private guiCheckBox d_ckFilterToRequests;
        private boolean d_filterEnabled;
        private Predicate<EgressAgent> d_agentFilter = Predicates.alwaysTrue();
        private Predicate<EgressAgent> d_additionalFilter = Predicates.alwaysTrue();

        public guiListEditor(String title, boolean upDownButton, boolean addRemoveButton, boolean filterCheckBox) {
            this(new guiLabel(title), upDownButton, addRemoveButton, filterCheckBox);
        }

        public guiListEditor(Component descLbl, boolean upDownButton, boolean addRemoveButton, boolean filterCheckBox) {
            this.d_filterEnabled = filterCheckBox;
            this.d_listModel = new FilteredListModel<EgressAgent>(EgressAgent.class, Predicates.alwaysTrue());
            this.d_list = new JList<EgressAgent>(this.d_listModel);
            this.d_list.setCellRenderer(new JLabelWithColor());
            this.d_ckFilterToRequests = new guiCheckBox("<html>" + Intl.intl("Only show occupants who request assistance<br>from this team"));
            if (this.d_filterEnabled) {
                this.d_ckFilterToRequests.addItemListener(e -> this.syncFilter());
            }
            JScrollPane listScroller = new JScrollPane(this.d_list);
            listScroller.setPreferredSize(new Dimension(150, 150));
            this.setLayout(new GridBagLayout());
            int nextRow = 0;
            GridBagUtil.add(this, descLbl, 0, nextRow++, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 11);
            GridBagUtil.add(this, listScroller, 0, nextRow++, 1, 4, 0, 0, 0, 0, 1, 1.0, 1.0, 11);
            nextRow += 4;
            if (this.d_filterEnabled) {
                GridBagUtil.add(this, this.d_ckFilterToRequests, 0, nextRow++, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 11);
            }
            this.createActions(upDownButton, addRemoveButton);
        }

        public Predicate<EgressAgent> getFilter() {
            return this.d_additionalFilter;
        }

        public void setFilter(Predicate<EgressAgent> filter) {
            if (this.d_additionalFilter == filter) {
                return;
            }
            this.d_additionalFilter = filter;
            this.syncFilter();
        }

        public void load(Collection<EgressAgent> input, AssistedEvacTeam dataObj) {
            if (input == null) {
                return;
            }
            Predicate<Behavior> behaviorFilter = Filters.cache(behavior -> {
                for (WaitForAssistance wfa : behavior.flatten(WaitForAssistance.class)) {
                    if (!wfa.getTeamFilter().test(dataObj)) continue;
                    return true;
                }
                return false;
            });
            this.d_agentFilter = agent -> behaviorFilter.test(agent.getBehavior());
            this.d_listModel.clear();
            if (this.d_filterEnabled) {
                this.d_ckFilterToRequests.setSelected(true);
            }
            input.forEach(a -> this.d_listModel.addElement(a));
            this.syncFilter();
        }

        private void syncFilter() {
            Predicate<Object> filter = this.d_ckFilterToRequests.isSelected() ? this.d_agentFilter : Predicates.alwaysTrue();
            filter = Predicates.and(filter, this.d_additionalFilter);
            this.d_listModel.setFilter(filter);
        }

        public List<EgressAgent> save() {
            Object[] wrapedAgents = this.d_listModel.toArray();
            return Stream.of(wrapedAgents).map(o -> (EgressAgent)o).collect(Collectors.toList());
        }

        public List<EgressAgent> getSelectedItems() {
            return this.d_list.getSelectedValuesList();
        }

        public List<EgressAgent> getAllItems() {
            return this.d_listModel.getAllItems();
        }

        public Object[] getAllItemsArray() {
            return this.d_listModel.toArray();
        }

        public void addItem(EgressAgent item) {
            this.d_listModel.addElement(item);
        }

        private void createActions(boolean upDownButton, boolean removeButton) {
            int nextRow = 1;
            if (removeButton) {
                this.d_addBtn = new CmdButton(new Add());
                this.d_removeBtn = new CmdButton(new Remove());
                GridBagUtil.add(this, this.d_addBtn, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
                GridBagUtil.add(this, this.d_removeBtn, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
            }
            if (upDownButton) {
                this.d_rowUp = new CmdButton(new MoveRowUp(this.d_list, this.d_listModel));
                this.d_rowDown = new CmdButton(new MoveRowDown(this.d_list, this.d_listModel));
                GridBagUtil.add(this, this.d_rowUp, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
                GridBagUtil.add(this, this.d_rowDown, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
            }
        }

        public class JLabelWithColor
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 538053496624961872L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                guiUtil.decorateCellRenderer(AssistedEvacTeamsPanel.this.d_md, list::repaint, value, this, isSelected, cellHasFocus, true, true);
                return c;
            }
        }

        public class Add
        extends AbstractCommand {
            public Add() {
                super(Intl.intl("Add..."), "");
            }

            @Override
            public void execute() {
                super.execute();
                AddOccDlg dlg = new AddOccDlg(AssistedEvacTeamsPanel.this.d_owner, Intl.intl("Add occupants to be assisted"), AssistedEvacTeamsPanel.this.d_dataObj);
                if (dlg.doModal() == 1) {
                    AssistedEvacTeamsPanel.this.d_isModified = true;
                }
            }
        }

        public class Remove
        extends AbstractCommand {
            public Remove() {
                super(Intl.intl("Remove"), "");
            }

            @Override
            public void execute() {
                super.execute();
                List<EgressAgent> selItems = guiListEditor.this.getSelectedItems();
                selItems.forEach(eaw -> guiListEditor.this.d_listModel.removeElement(eaw));
                AssistedEvacTeamsPanel.this.d_isModified = true;
            }
        }

        public class MoveRowUp
        extends AbstractCommand {
            private DefaultListModel<Object> d_model;
            private JList<?> d_list;

            public MoveRowUp(JList<?> list, DefaultListModel<Object> model) {
                super(Intl.intl("Move Up"), "graphics/Up16.gif");
                this.d_list = list;
                this.d_model = model;
            }

            @Override
            public void execute() {
                super.execute();
                int moveIdx = this.d_list.getSelectedIndex();
                if (moveIdx == -1) {
                    return;
                }
                if (moveIdx > 0) {
                    int from = moveIdx;
                    int to = moveIdx - 1;
                    Object aObject = this.d_model.getElementAt(from);
                    Object bObject = this.d_model.getElementAt(to);
                    this.d_model.set(from, bObject);
                    this.d_model.set(to, aObject);
                    this.d_list.setSelectedIndex(moveIdx - 1);
                    this.d_list.ensureIndexIsVisible(moveIdx - 1);
                    AssistedEvacTeamsPanel.this.d_isModified = true;
                }
            }
        }

        public class MoveRowDown
        extends AbstractCommand {
            private DefaultListModel<Object> d_model;
            private JList<?> d_list;

            public MoveRowDown(JList<?> list, DefaultListModel<Object> model) {
                super(Intl.intl("Move Down"), "graphics/Down16.gif");
                this.d_list = list;
                this.d_model = model;
            }

            @Override
            public void execute() {
                super.execute();
                int moveIdx = this.d_list.getSelectedIndex();
                if (moveIdx == -1) {
                    return;
                }
                if (moveIdx < guiListEditor.this.d_listModel.getSize() - 1) {
                    int from = moveIdx;
                    int to = moveIdx + 1;
                    Object aObject = this.d_model.getElementAt(from);
                    Object bObject = this.d_model.getElementAt(to);
                    this.d_model.set(from, bObject);
                    this.d_model.set(to, aObject);
                    this.d_list.setSelectedIndex(moveIdx + 1);
                    this.d_list.ensureIndexIsVisible(moveIdx + 1);
                    AssistedEvacTeamsPanel.this.d_isModified = true;
                }
            }
        }
    }

    private static enum Priority {
        LIST(Intl.intl("Specified in the list below"), "<html>" + Intl.intl("Listed clients are assisted in the listed order.<br>Unlisted clients are assisted afterward based on distance.")),
        DISTANCE(Intl.intl("Distance to assistants"), Intl.intl("Clients closest to assistants are assisted first."));

        public final String name;
        public final String tt;

        private Priority(String name, String tt) {
            this.name = name;
            this.tt = tt;
        }
    }

    public class AddOccDlg
    extends guiDialog {
        private static final long serialVersionUID = 274142287731916959L;

        public AddOccDlg(Window owner, String title, AssistedEvacTeam dataObj) {
            super(owner, title, 9);
            AssistedEvacTeamsPanel.this.d_allAgentsList.d_ckFilterToRequests.setSelected(true);
            this.setDialogComponent(AssistedEvacTeamsPanel.this.d_allAgentsList);
            this.setResizable(true);
            IdentityHashSet<EgressAgent> currSel = new IdentityHashSet<EgressAgent>(AssistedEvacTeamsPanel.this.d_agentOrderList.getAllItems());
            AssistedEvacTeamsPanel.this.d_allAgentsList.setFilter(Filters.reject(currSel));
        }

        @Override
        public int doModal() {
            int result = super.doModal();
            if (result == 1) {
                List<EgressAgent> selectedAgents = AssistedEvacTeamsPanel.this.d_allAgentsList.getSelectedItems();
                selectedAgents.forEach(eaw -> {
                    AssistedEvacTeamsPanel.this.d_agentOrderList.addItem((EgressAgent)eaw);
                    AssistedEvacTeamsPanel.this.d_isModified = true;
                });
            }
            AssistedEvacTeamsPanel.this.d_agentOrderList.setFilter(Predicates.alwaysTrue());
            return result;
        }
    }

    public static class FilteredListModel<T>
    extends DefaultListModel {
        private static final long serialVersionUID = 7527165985890393986L;
        private final List<T> d_allElements = new ArrayList<T>();
        private Predicate<T> d_filter;

        public FilteredListModel(Class<T> clazz, Predicate<T> filter) {
            this.d_filter = filter;
        }

        public List<T> getAllItems() {
            return this.d_allElements;
        }

        public void setFilter(Predicate<T> filter) {
            if (filter == this.d_filter) {
                return;
            }
            this.d_filter = filter;
            this.syncFilter();
        }

        private void syncFilter() {
            super.removeAllElements();
            for (Object element : theUtil.filter(this.d_allElements, this.d_filter)) {
                super.addElement(element);
            }
        }

        public void showAll() {
            this.setFilter(Predicates.alwaysTrue());
        }

        public void add(int index, Object element) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeElementAt(int index) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeElement(Object obj) {
            boolean removed = this.d_allElements.remove(obj);
            if (this.d_filter.test(obj)) {
                super.removeElement(obj);
            }
            return removed;
        }

        public void addElement(Object element) {
            this.d_allElements.add(element);
            if (this.d_filter.test(element)) {
                super.addElement(element);
            }
        }

        @Override
        public void clear() {
            this.removeAllElements();
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
            this.d_allElements.clear();
        }
    }
}

