/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.stage.FileChooser;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.AnimRetargetMode;
import merlin.data.animation.AnimType;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationTransform;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.IdlePlayback;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import merlin.gui.MerlinUDF;
import merlin.gui.StrTagsField;
import merlin.gui.guiUtil;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.table.ObjectTableModel;
import thunderheadeng.gui.table.PopupTableCell;
import thunderheadeng.gui.table.TableColProp;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class AnimationsPanel
extends guiPanel
implements IEditor<Animation> {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_BASE_POSE_WARNING = String.format(Intl.intl("WARNING: Only leave %s blank if you're sure the animation file also contains the avatar or the avatar's T-pose."), AAnimationClip.RETARGET_SOURCE.name);
    private static final String RETARGET_MODE_WARNING = Intl.intl("WARNING: Manually specified retarget mode will be overridden by changes.");
    private final NameField d_name = new NameField();
    private final guiComboBox<AnimType> d_type;
    private final StrTagsField d_tags;
    private final CardLayout d_cardLayout;
    private final JPanel d_cardPanel;
    private final IdleClipPanel d_idleClipPnl;
    private final MoveClipPanel d_moveClipPnl;
    private final PivotClipPanel d_pivotClipPnl;
    public static final Predicate<String> NAME_FILTER = new NameFilter();

    public AnimationsPanel(Window owner) {
        this.d_name.setEditable(false);
        this.d_type = guiUtil.newCombo(type -> new Pair<String, String>(type.displayName, type.description), Arrays.stream(AnimType.values()).filter(type -> type != AnimType.PIVOT).collect(Collectors.toList()));
        this.d_type.setEnabled(false);
        this.d_tags = new StrTagsField();
        this.d_tags.setEmptyAllowed(false);
        this.d_tags.setNullAllowed(false);
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.d_idleClipPnl = new IdleClipPanel();
        this.d_idleClipPnl.setBorder(border);
        this.d_moveClipPnl = new MoveClipPanel();
        this.d_moveClipPnl.setBorder(border);
        this.d_pivotClipPnl = new PivotClipPanel();
        this.d_pivotClipPnl.setBorder(border);
        this.d_cardLayout = new CardLayout();
        this.d_cardPanel = new JPanel(this.d_cardLayout);
        this.d_cardPanel.add((Component)this.d_idleClipPnl, AnimType.IDLE.jsonName);
        this.d_cardPanel.add((Component)this.d_moveClipPnl, AnimType.MOVE.jsonName);
        this.d_cardPanel.add((Component)this.d_pivotClipPnl, AnimType.PIVOT.jsonName);
        this.d_type.addItemListener(evt -> this.d_cardLayout.show(this.d_cardPanel, this.d_type.getSelectedItem().jsonName));
        this.setLayout(new MigLayout("insets 0, gap 6, wrap 2", "[fill][fill,grow]", "[][][][grow]"));
        this.add(guiUtil.lblProp(Intl.intl("Name"), Intl.intl("The name of the animation.")));
        this.add(this.d_name);
        this.add(guiUtil.lblProp(Animation.TYPE.getDisplayName(), Animation.TYPE.getDisplayDesc()));
        this.add(this.d_type);
        this.add(guiUtil.lblProp(Animation.TAGS.getDisplayName(), Animation.TAGS.getDisplayDesc()));
        this.add(this.d_tags);
        this.add((Component)this.d_cardPanel, "span, grow");
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Animation anim) {
        if (anim != null) {
            this.setVisible(true);
            this.d_name.setValue(anim.getName());
            this.d_tags.setValue(anim.getTags());
            this.d_type.setSelectedItem((Object)anim.getType());
            this.d_idleClipPnl.init(anim);
            this.d_moveClipPnl.init(anim);
            this.d_pivotClipPnl.init(anim);
            this.d_cardLayout.show(this.d_cardPanel, anim.getType().jsonName);
        } else {
            this.setVisible(false);
        }
        this.setModified(false);
    }

    @Override
    public Animation commit(Animation anim) {
        if (anim != null) {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.insertEntry_breakChain(md);
                    this.commitAnimation(anim, true);
                    md.animations.saveToDB(anim, false);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), String.format(Intl.intl("Error saving animation to the database:\n\t%s"), e.getLocalizedMessage()), Intl.intl("Animation Database Error"), 0);
                }
            });
            UIHook.run(this, "AnimationsPanel.commit", op, 0);
        }
        this.init(anim);
        return anim;
    }

    private void commitAnimation(Animation anim, boolean changeModified) {
        if (anim == null) {
            return;
        }
        anim.setType(this.d_type.getSelectedItem());
        anim.setTags((Set)this.d_tags.getValue());
        switch (anim.getType()) {
            case IDLE: {
                this.d_idleClipPnl.commit(anim, changeModified);
                break;
            }
            case MOVE: {
                this.d_moveClipPnl.commit(anim, changeModified);
                break;
            }
            case PIVOT: {
                this.d_pivotClipPnl.commit(anim, changeModified);
            }
        }
    }

    private static void insertUndoOp(MerlinData md, Animation anim) {
        Undo.insertEntry(md, new Undo.RestoreOp(anim, anim.getRestoreObj()));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return super.validateData(showWarn, allowModify);
    }

    public static FileChooserField newClipField() {
        return new FileChooserField(false, new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.md5anim"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_MD5ANIM);
    }

    public static FileChooserField newBasePoseField() {
        return new FileChooserField(false, new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.glb", "*.gltf", "*.md5mesh"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_GLB, FileFilters.EXT_FILTER_GLTF, FileFilters.EXT_FILTER_MD5MESH);
    }

    public static guiCheckBox newAnimHasBasePoseCheckbox() {
        guiCheckBox d_animationHasBasePose = new guiCheckBox(Intl.intl("Clip file also contains avatar or base pose"));
        d_animationHasBasePose.setToolTipText(String.format(Intl.intl("Indicates that the animation file also contains a T-pose or A-pose for the animation's avatar.\nThis is usually the case if the animation file also contains the avatar itself. If this is\nunchecked, %s must be specified."), AAnimationClip.RETARGET_SOURCE.name));
        return d_animationHasBasePose;
    }

    private static PopupTableCell<String> makeFileChooserCellEditor(FileChooser.ExtensionFilter ... filters) {
        return new PopupTableCell<String>(curr -> {
            Path currPath = curr != null ? Paths.get(curr, new String[0]) : null;
            guiJFXFileChooser chooser = new guiJFXFileChooser(currPath != null && currPath.getFileName() != null ? currPath.getFileName().toString() : null, currPath != null && currPath.getParent() != null ? currPath.getParent().toString() : MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, filters);
            File result = chooser.showOpenDialog();
            if (result == null) {
                return null;
            }
            return result.toString();
        }, f -> f != null ? Paths.get(f, new String[0]).getFileName().toString() : "");
    }

    private static PopupTableCell<AnimationTransform> makeAnimTransformCellEditor(Component parent) {
        return new PopupTableCell<AnimationTransform>(curr -> {
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("Animation Transform"), 9);
            AnimationTransformPanel panel = new AnimationTransformPanel();
            panel.setValue(curr != null ? curr : new AnimationTransform());
            dlg.setDialogComponent(panel);
            if (dlg.doModal() == 1) {
                return panel.getValue();
            }
            return null;
        }, xform -> {
            if (xform != null) {
                return String.format(Intl.intl("x%s, %s about %s, %s"), xform.getScale().get(Unit.ONE), xform.getRotation().toString(), xform.getRotationAxis().toString(), xform.getTranslation().convert(MerlinApp.getApp().getUnitSystem().getLength()).toString());
            }
            return "";
        });
    }

    public static class NameField
    extends ValueField<String> {
        private static final long serialVersionUID = 1L;

        public NameField() {
            this("");
        }

        public NameField(String defValue) {
            super(NameField.getFormatterFactory(false), defValue);
        }

        private static JFormattedTextField.AbstractFormatterFactory getFormatterFactory(boolean allowEmpty) {
            guiFormattedFld.Formatter<String> formatter = new guiFormattedFld.Formatter<String>(new NameFormat());
            formatter.setNullAllowed(allowEmpty);
            formatter.setFilter(NAME_FILTER);
            return new DefaultFormatterFactory(formatter);
        }

        private static class NameFormat
        extends AFormat<String> {
            private static final long serialVersionUID = 1L;

            private NameFormat() {
            }

            @Override
            protected String parse(String text) throws ParseException {
                return FilenameManager.formatFilename(text);
            }

            @Override
            protected String toString(String val) {
                return val;
            }
        }
    }

    private static class IdleClipPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final FileChooserField d_clip = AnimationsPanel.newClipField();
        private final guiComboBox<IdlePlayback> d_idlePlayback = guiUtil.newCombo(type -> new Pair<String, String>(type.displayName, type.description), IdlePlayback.values());
        private final guiUnitDoubleField d_frameOffset = new MerlinUDF(Unit.ONE, DoubleVR.above(0.0, true));
        private final guiCheckBox d_animationHasBasePose = AnimationsPanel.newAnimHasBasePoseCheckbox();
        private final FileChooserField d_basePoseSource = AnimationsPanel.newBasePoseField();
        private final guiUnitDoubleField d_scale = new MerlinUDF(Unit.ONE, DoubleVR.above(0.0, false));
        private final guiUnitDoubleField d_xOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_yOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_zOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotXAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotYAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotZAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotAngle = new MerlinUDF(SI.RADIAN, DoubleVR.between(0.0, Math.PI * 2));
        private final JLabel d_retargetModeWarning = new guiLabel(RETARGET_MODE_WARNING);

        public IdleClipPanel() {
            guiLabel basePoseSrcLbl = guiUtil.lblProp(AAnimationClip.RETARGET_SOURCE.getDisplayName(), AAnimationClip.RETARGET_SOURCE.getDisplayDesc());
            guiUtil.link((AbstractButton)this.d_animationHasBasePose, true, basePoseSrcLbl, this.d_basePoseSource);
            this.setLayout(new MigLayout("insets 0, gap 6"));
            this.add(this.add(guiUtil.lblProp(AAnimationClip.FILE.getDisplayName(), AAnimationClip.FILE.getDisplayDesc())));
            this.add((Component)this.d_clip, "wrap, span, grow");
            this.add((Component)this.d_animationHasBasePose, "wrap, span");
            this.add(basePoseSrcLbl);
            this.add((Component)this.d_basePoseSource, "wrap, span, grow");
            this.add(guiUtil.lblProp(IdleAnimationClip.IDLE_PLAYBACK.getDisplayName(), IdleAnimationClip.IDLE_PLAYBACK.getDisplayDesc()));
            this.add(this.d_idlePlayback, "wrap, span, grow");
            this.add(guiUtil.lblProp(AAnimationClip.FRAME_OFFSET.getDisplayName(), AAnimationClip.FRAME_OFFSET.getDisplayDesc()));
            this.add((Component)this.d_frameOffset, "wrap, span, grow");
            this.add(guiUtil.lblProp(Intl.intl("Scale"), Intl.intl("Scale applied to the model during animation.")));
            this.add((Component)this.d_scale, "wrap, span, grow");
            this.add(guiUtil.lblProp(Intl.intl("Rotation"), Intl.intl("Rotation about an axis applied to the model during animation using the right-hand rule.")));
            this.add(this.d_rotAngle);
            this.add(guiUtil.lblProp(Intl.intl("X"), Intl.intl("X-Component of the rotation axis.")));
            this.add(this.d_rotXAxis);
            this.add(guiUtil.lblProp(Intl.intl("Y"), Intl.intl("Y-Component of the rotation axis.")));
            this.add(this.d_rotYAxis);
            this.add(guiUtil.lblProp(Intl.intl("Z"), Intl.intl("Z-Component of the rotation axis.")));
            this.add((Component)this.d_rotZAxis, "wrap");
            this.add((Component)guiUtil.lblProp(Intl.intl("Offset"), Intl.intl("Translational offset applied to the model during animation.")), "span 2, grow");
            this.add(guiUtil.lblProp(Intl.intl("X"), Intl.intl("X-Component of the translation.")));
            this.add(this.d_xOffset);
            this.add(guiUtil.lblProp(Intl.intl("Y"), Intl.intl("Y-Component of the translation.")));
            this.add(this.d_yOffset);
            this.add(guiUtil.lblProp(Intl.intl("Z"), Intl.intl("Z-Component of the translation.")));
            this.add((Component)this.d_zOffset, "wrap");
            this.add((Component)this.d_retargetModeWarning, "wrap, span, grow");
        }

        public void init(Animation anim) {
            IdleAnimationClip idleClip = anim.getIdleClip();
            this.d_clip.setSelectedFile(idleClip.getPath());
            this.d_idlePlayback.setSelectedItem((Object)idleClip.getIdlePlayback());
            this.d_frameOffset.setValue(idleClip.getFrameOffset());
            this.d_animationHasBasePose.setSelected(!idleClip.getRetargetMode().requiresExternalBasePoseSource || idleClip.getRetargetSource() == null || idleClip.getRetargetSource().isEmpty());
            this.d_basePoseSource.setSelectedFile(idleClip.getRetargetSource());
            AnimationTransform transform = idleClip.getTransform();
            this.d_scale.setValue(transform.getScale());
            this.d_rotAngle.setValue(transform.getRotation());
            Vector3d rotAxis = transform.getRotationAxis();
            this.d_rotXAxis.setValue(new UnitDouble(rotAxis.x, Unit.ONE));
            this.d_rotYAxis.setValue(new UnitDouble(rotAxis.y, Unit.ONE));
            this.d_rotZAxis.setValue(new UnitDouble(rotAxis.z, Unit.ONE));
            UnitPoint3D offset = transform.getTranslation();
            this.d_xOffset.setValue(offset.xu());
            this.d_yOffset.setValue(offset.yu());
            this.d_zOffset.setValue(offset.zu());
            this.d_retargetModeWarning.setVisible(idleClip.getRetargetMode().manuallyCreated);
        }

        public void commit(Animation anim, boolean changeModified) {
            IdleAnimationClip idleClip = anim.getIdleClip().clone();
            idleClip.setPath(this.d_clip.getSelectedFile());
            idleClip.setIdlePlayback(this.d_idlePlayback.getSelectedItem());
            idleClip.setFrameOffset((UnitDouble)this.d_frameOffset.getValue());
            idleClip.setRetargetSource(this.d_animationHasBasePose.isSelected() ? null : this.d_basePoseSource.getSelectedFile());
            UnitPoint3D translation = new UnitPoint3D((UnitDouble)this.d_xOffset.getValue(), (UnitDouble)this.d_yOffset.getValue(), (UnitDouble)this.d_zOffset.getValue());
            Vector3d rotAxis = new Vector3d(((UnitDouble)this.d_rotXAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotYAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotZAxis.getValue()).getRawValue());
            rotAxis.normalize();
            idleClip.setTransform(new AnimationTransform((UnitDouble)this.d_scale.getValue(), (UnitDouble)this.d_rotAngle.getValue(), rotAxis, translation));
            if (idleClip.getRetargetSource() == null || idleClip.getRetargetSource().isEmpty()) {
                idleClip.setRetargetMode(AnimRetargetMode.SELF);
            } else {
                idleClip.setRetargetMode(AnimRetargetMode.OTHER);
            }
            anim.setIdleClip(idleClip);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (Util3D.isVecZero(new Vector3d(((UnitDouble)this.d_rotXAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotYAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotZAxis.getValue()).getRawValue()))) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Rotation axis cannot be zero."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private static class MoveClipPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final HashMap<AnimDirection, guiCheckBox> d_directions = new HashMap(AnimDirection.values().length);
        private final ObjectTableModel<MoveAnimationClip> d_tableModel;
        private final guiTable d_table;
        private final guiTableEditor d_tableEditor;
        private final MultiLineLabel d_emptyBasePoseWarningLbl;
        private final MultiLineLabel d_retargetModeWarning;

        public MoveClipPanel() {
            for (AnimDirection dir : AnimDirection.values()) {
                guiCheckBox checkBox = new guiCheckBox(dir.displayName);
                checkBox.addActionListener(e -> this.d_directions.get((Object)dir.opposite()).setEnabled(!checkBox.isSelected()));
                this.d_directions.put(dir, checkBox);
            }
            PopupTableCell<String> clipEditor = AnimationsPanel.makeFileChooserCellEditor(new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.md5anim"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_MD5ANIM);
            guiTable.UnitDoubleEditor frameEditor = new guiTable.UnitDoubleEditor(Unit.ONE, Filters.acceptAll(), false);
            guiTable.UnitDoubleEditor naturalSpeedEditor = new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getLength().divide(MerlinApp.getApp().getUnitSystem().getTime()), Filters.acceptAll(), false);
            guiTable.UnitDoubleEditor topSpeedEditor = new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getLength().divide(MerlinApp.getApp().getUnitSystem().getTime()), Filters.acceptAll(), true);
            PopupTableCell<String> meshEditor = AnimationsPanel.makeFileChooserCellEditor(new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.glb", "*.gltf", "*.md5mesh"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_GLB, FileFilters.EXT_FILTER_GLTF, FileFilters.EXT_FILTER_MD5MESH);
            PopupTableCell<AnimationTransform> xformEditor = AnimationsPanel.makeAnimTransformCellEditor(this);
            Pair<guiTable, ObjectTableModel<MoveAnimationClip>> pair = guiTableUtil.objectTable(MoveAnimationClip::new, List.of(new TableColProp<MoveAnimationClip>(AAnimationClip.FILE.getDisplayName(), AAnimationClip.FILE.getDisplayDesc(), String.class, clip -> clip.getPath(), (clip, val) -> clip.setPath(val instanceof String ? (String)val : ""), clipEditor), new TableColProp<MoveAnimationClip>(AAnimationClip.RETARGET_SOURCE.getDisplayName(), AAnimationClip.RETARGET_SOURCE.getDisplayDesc(), String.class, clip -> clip.getRetargetSource(), (clip, val) -> clip.setRetargetSource(val instanceof String ? (String)val : ""), meshEditor), new TableColProp<MoveAnimationClip>(AAnimationClip.FRAME_OFFSET.getDisplayName(), AAnimationClip.FRAME_OFFSET.getDisplayDesc(), UnitDouble.class, clip -> clip.getFrameOffset(), (clip, val) -> clip.setFrameOffset(val instanceof UnitDouble ? (UnitDouble)val : new UnitDouble(0.0, Unit.ONE)), frameEditor, new DefaultTableCellRenderer()), new TableColProp<MoveAnimationClip>(MoveAnimationClip.NATURAL_SPEED.getDisplayName(), MoveAnimationClip.NATURAL_SPEED.getDisplayDesc(), UnitDouble.class, clip -> clip.getNaturalSpeed(), (clip, val) -> clip.setNaturalSpeed((UnitDouble)val), naturalSpeedEditor, new DefaultTableCellRenderer()), new TableColProp<MoveAnimationClip>(MoveAnimationClip.TOP_SPEED.getDisplayName(), MoveAnimationClip.TOP_SPEED.getDisplayDesc(), UnitDouble.class, clip -> clip.getTopSpeed().isInfinite() ? null : clip.getTopSpeed(), (clip, val) -> clip.setTopSpeed(val instanceof UnitDouble ? (UnitDouble)val : new UnitDouble(Double.POSITIVE_INFINITY, clip.getTopSpeed().getUnit())), topSpeedEditor, new DefaultTableCellRenderer()), new TableColProp<MoveAnimationClip>(AAnimationClip.TRANSFORM.getDisplayName(), AAnimationClip.TRANSFORM.getDisplayDesc(), AnimationTransform.class, clip -> clip.getTransform(), (clip, val) -> clip.setTransform(val instanceof AnimationTransform ? (AnimationTransform)val : new AnimationTransform()), xformEditor)), 24);
            this.d_table = (guiTable)pair.v1;
            this.d_tableModel = (ObjectTableModel)pair.v2;
            this.d_table.getTableHeader().setReorderingAllowed(false);
            this.d_tableEditor = new guiTableEditor(this.d_table, 30);
            this.d_table.autoSizeColumns(this.d_table.getPreferredScrollableViewportSize().height);
            this.d_tableEditor.setPreferredSize(new Dimension(this.d_tableEditor.getPreferredSize().width, 200));
            this.d_emptyBasePoseWarningLbl = new MultiLineLabel(EMPTY_BASE_POSE_WARNING);
            this.d_retargetModeWarning = new MultiLineLabel(RETARGET_MODE_WARNING);
            this.setLayout(new MigLayout("insets 0, gap 6", "[][][][][][fill, grow]", "[][][grow][]"));
            this.add(guiUtil.lblProp(Animation.DIRECTION.getDisplayName(), Animation.DIRECTION.getDisplayDesc()));
            this.add(this.d_directions.get((Object)AnimDirection.FORWARD));
            this.add(this.d_directions.get((Object)AnimDirection.UP));
            this.add(this.d_directions.get((Object)AnimDirection.LEFT));
            this.add((Component)guiUtil.lblHtml(Intl.intl("NOTE: This animation may be used for other directions\nif no animation with the same tags exists for those directions."), ""), "span 2 2, grow, wrap");
            this.add((Component)this.d_directions.get((Object)AnimDirection.BACKWARD), "skip");
            this.add(this.d_directions.get((Object)AnimDirection.DOWN));
            this.add((Component)this.d_directions.get((Object)AnimDirection.RIGHT), "wrap");
            this.add((Component)guiUtil.lblProp(Animation.MOVE_CLIPS.getDisplayName(), Animation.MOVE_CLIPS.getDisplayDesc()), "top");
            this.add((Component)this.d_tableEditor, "wrap, span, grow");
            this.add((Component)this.d_retargetModeWarning, "wrap, span, grow, w 0::");
            this.add((Component)this.d_emptyBasePoseWarningLbl, "wrap, span, grow, w 0::");
            this.d_tableModel.addTableModelListener(evt -> this.syncDynamicLabels());
        }

        public void init(Animation anim) {
            for (AnimDirection dir : AnimDirection.values()) {
                this.d_directions.get((Object)dir).setSelected(anim.getDirections().contains((Object)dir));
                this.d_directions.get((Object)dir.opposite()).setEnabled(!anim.getDirections().contains((Object)dir));
            }
            List clips = anim.getMoveClips().stream().map(m -> m.clone()).collect(Collectors.toList());
            this.d_tableModel.setRows(clips);
            this.d_retargetModeWarning.setVisible(false);
            for (MoveAnimationClip clip : anim.getMoveClips()) {
                if (!clip.getRetargetMode().manuallyCreated) continue;
                this.d_retargetModeWarning.setVisible(true);
            }
            this.syncDynamicLabels();
        }

        private void syncDynamicLabels() {
            this.d_emptyBasePoseWarningLbl.setVisible(this.d_tableModel.getRows().stream().anyMatch(clip -> clip.getRetargetSource() == null || clip.getRetargetSource().trim().isEmpty()));
        }

        public void commit(Animation anim, boolean changeModified) {
            HashSet<AnimDirection> directions = new HashSet<AnimDirection>();
            for (AnimDirection dir : AnimDirection.values()) {
                if (!this.d_directions.get((Object)dir).isSelected()) continue;
                directions.add(dir);
            }
            anim.setDirections(directions);
            List<MoveAnimationClip> clips = this.d_tableModel.getRows();
            for (MoveAnimationClip clip : clips) {
                if (clip.getRetargetSource() == null || clip.getRetargetSource().isEmpty()) {
                    clip.setRetargetMode(AnimRetargetMode.SELF);
                    continue;
                }
                clip.setRetargetMode(AnimRetargetMode.OTHER);
            }
            anim.setMoveClips(clips);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            boolean hasDirection = false;
            for (guiCheckBox checkBox : this.d_directions.values()) {
                if (!checkBox.isSelected()) continue;
                hasDirection = true;
                break;
            }
            if (!hasDirection) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("At least one direction must be selected."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            if (this.d_tableModel.getRowCount() <= 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("At least one animation clip must be added."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            for (MoveAnimationClip clip : this.d_tableModel.getRows()) {
                Path clipPath;
                Path path = clipPath = clip.getPath() != null ? Paths.get(clip.getPath(), new String[0]) : null;
                if (clipPath != null && Files.exists(clipPath, new LinkOption[0]) && Files.isRegularFile(clipPath, new LinkOption[0])) continue;
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Animation clip file must be selected."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            for (MoveAnimationClip clip : this.d_tableModel.getRows()) {
                if (clip.getNaturalSpeed() != null) continue;
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Natural speed must be specified."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private static class PivotClipPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final HashMap<AnimDirection, guiCheckBox> d_directions = new HashMap(AnimDirection.values().length);
        private final ObjectTableModel<PivotAnimationClip> d_tableModel;
        private final guiTable d_table;
        private final guiTableEditor d_tableEditor;
        private final MultiLineLabel d_emptyBasePoseWarningLbl;
        private final MultiLineLabel d_retargetModeWarning;

        public PivotClipPanel() {
            for (AnimDirection dir : AnimDirection.values()) {
                guiCheckBox checkBox = new guiCheckBox(dir.displayName);
                checkBox.addActionListener(e -> this.d_directions.get((Object)dir.opposite()).setEnabled(!checkBox.isSelected()));
                this.d_directions.put(dir, checkBox);
            }
            PopupTableCell<String> clipEditor = AnimationsPanel.makeFileChooserCellEditor(new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.md5anim"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_MD5ANIM);
            guiTable.UnitDoubleEditor frameEditor = new guiTable.UnitDoubleEditor(Unit.ONE, Filters.acceptAll(), false);
            guiTable.UnitDoubleEditor naturalSpeedEditor = new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getAngle().divide(MerlinApp.getApp().getUnitSystem().getTime()), Filters.acceptAll(), false);
            guiTable.UnitDoubleEditor topSpeedEditor = new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getAngle().divide(MerlinApp.getApp().getUnitSystem().getTime()), Filters.acceptAll(), true);
            PopupTableCell<String> meshEditor = AnimationsPanel.makeFileChooserCellEditor(new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.glb", "*.gltf", "*.md5mesh"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_GLB, FileFilters.EXT_FILTER_GLTF, FileFilters.EXT_FILTER_MD5MESH);
            PopupTableCell<AnimationTransform> xformEditor = AnimationsPanel.makeAnimTransformCellEditor(this);
            Pair<guiTable, ObjectTableModel<PivotAnimationClip>> pair = guiTableUtil.objectTable(PivotAnimationClip::new, List.of(new TableColProp<PivotAnimationClip>(AAnimationClip.FILE.getDisplayName(), AAnimationClip.FILE.getDisplayDesc(), String.class, clip -> clip.getPath(), (clip, val) -> clip.setPath(val instanceof String ? (String)val : ""), clipEditor), new TableColProp<PivotAnimationClip>(AAnimationClip.RETARGET_SOURCE.getDisplayName(), AAnimationClip.RETARGET_SOURCE.getDisplayDesc(), String.class, clip -> clip.getRetargetSource(), (clip, val) -> clip.setRetargetSource(val instanceof String ? (String)val : ""), meshEditor), new TableColProp<PivotAnimationClip>(AAnimationClip.FRAME_OFFSET.getDisplayName(), AAnimationClip.FRAME_OFFSET.getDisplayDesc(), UnitDouble.class, clip -> clip.getFrameOffset(), (clip, val) -> clip.setFrameOffset(val instanceof UnitDouble ? (UnitDouble)val : new UnitDouble(0.0, Unit.ONE)), frameEditor, new DefaultTableCellRenderer()), new TableColProp<PivotAnimationClip>(PivotAnimationClip.NATURAL_SPEED.getDisplayName(), PivotAnimationClip.NATURAL_SPEED.getDisplayDesc(), UnitDouble.class, clip -> clip.getNaturalSpeed(), (clip, val) -> clip.setNaturalSpeed((UnitDouble)val), naturalSpeedEditor, new DefaultTableCellRenderer()), new TableColProp<PivotAnimationClip>(PivotAnimationClip.TOP_SPEED.getDisplayName(), PivotAnimationClip.TOP_SPEED.getDisplayDesc(), UnitDouble.class, clip -> clip.getTopSpeed().isInfinite() ? null : clip.getTopSpeed(), (clip, val) -> clip.setTopSpeed(val instanceof UnitDouble ? (UnitDouble)val : new UnitDouble(Double.POSITIVE_INFINITY, clip.getTopSpeed().getUnit())), topSpeedEditor, new DefaultTableCellRenderer()), new TableColProp<PivotAnimationClip>(AAnimationClip.TRANSFORM.getDisplayName(), AAnimationClip.TRANSFORM.getDisplayDesc(), AnimationTransform.class, clip -> clip.getTransform(), (clip, val) -> clip.setTransform(val instanceof AnimationTransform ? (AnimationTransform)val : new AnimationTransform()), xformEditor)), 24);
            this.d_table = (guiTable)pair.v1;
            this.d_tableModel = (ObjectTableModel)pair.v2;
            this.d_table.getTableHeader().setReorderingAllowed(false);
            this.d_tableEditor = new guiTableEditor(this.d_table, 30);
            this.d_table.autoSizeColumns(this.d_table.getPreferredScrollableViewportSize().height);
            this.d_tableEditor.setPreferredSize(new Dimension(this.d_tableEditor.getPreferredSize().width, 200));
            this.d_emptyBasePoseWarningLbl = new MultiLineLabel(EMPTY_BASE_POSE_WARNING);
            this.d_retargetModeWarning = new MultiLineLabel(RETARGET_MODE_WARNING);
            this.setLayout(new MigLayout("insets 0, gap 6", "[][][][][fill, grow]", "[][][grow][]"));
            this.add(guiUtil.lblProp(Animation.DIRECTION.getDisplayName(), Animation.DIRECTION.getDisplayDesc()));
            this.add(this.d_directions.get((Object)AnimDirection.FORWARD));
            this.add(this.d_directions.get((Object)AnimDirection.UP));
            this.add((Component)this.d_directions.get((Object)AnimDirection.LEFT), "wrap");
            this.add((Component)this.d_directions.get((Object)AnimDirection.BACKWARD), "skip");
            this.add(this.d_directions.get((Object)AnimDirection.DOWN));
            this.add((Component)this.d_directions.get((Object)AnimDirection.RIGHT), "wrap");
            this.add((Component)guiUtil.lblProp(Animation.PIVOT_CLIPS.getDisplayName(), Animation.PIVOT_CLIPS.getDisplayDesc()), "top");
            this.add((Component)this.d_tableEditor, "wrap, span, grow");
            this.add((Component)this.d_retargetModeWarning, "wrap, span, grow, w 0::");
            this.add((Component)this.d_emptyBasePoseWarningLbl, "wrap, span, grow, w 0::");
            this.d_tableModel.addTableModelListener(evt -> this.syncDynamicLabels());
        }

        private void syncDynamicLabels() {
            this.d_emptyBasePoseWarningLbl.setVisible(this.d_tableModel.getRows().stream().anyMatch(clip -> clip.getRetargetSource() == null || clip.getRetargetSource().trim().isEmpty()));
        }

        public void init(Animation anim) {
            for (AnimDirection dir : AnimDirection.values()) {
                this.d_directions.get((Object)dir).setSelected(anim.getDirections().contains((Object)dir));
                this.d_directions.get((Object)dir.opposite()).setEnabled(!anim.getDirections().contains((Object)dir));
            }
            List clips = anim.getPivotClips().stream().map(m -> m.clone()).collect(Collectors.toList());
            this.d_tableModel.setRows(clips);
            this.d_retargetModeWarning.setVisible(false);
            for (PivotAnimationClip clip : anim.getPivotClips()) {
                if (!clip.getRetargetMode().manuallyCreated) continue;
                this.d_retargetModeWarning.setVisible(true);
            }
            this.syncDynamicLabels();
        }

        public void commit(Animation anim, boolean changeModified) {
            HashSet<AnimDirection> directions = new HashSet<AnimDirection>();
            for (AnimDirection dir : AnimDirection.values()) {
                if (!this.d_directions.get((Object)dir).isSelected()) continue;
                directions.add(dir);
            }
            anim.setDirections(directions);
            List<PivotAnimationClip> clips = this.d_tableModel.getRows();
            for (PivotAnimationClip clip : clips) {
                if (clip.getRetargetSource() == null || clip.getRetargetSource().isEmpty()) {
                    clip.setRetargetMode(AnimRetargetMode.SELF);
                    continue;
                }
                clip.setRetargetMode(AnimRetargetMode.OTHER);
            }
            anim.setPivotClips(clips);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            boolean hasDirection = false;
            for (guiCheckBox checkBox : this.d_directions.values()) {
                if (!checkBox.isSelected()) continue;
                hasDirection = true;
                break;
            }
            if (!hasDirection) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("At least one direction must be selected."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            if (this.d_tableModel.getRowCount() <= 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("At least one animation clip must be added."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            for (PivotAnimationClip clip : this.d_tableModel.getRows()) {
                Path clipPath;
                Path path = clipPath = clip.getPath() != null ? Paths.get(clip.getPath(), new String[0]) : null;
                if (clipPath != null && Files.exists(clipPath, new LinkOption[0]) && !Files.isDirectory(clipPath, new LinkOption[0])) continue;
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Animation clip file must be selected."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            for (PivotAnimationClip clip : this.d_tableModel.getRows()) {
                if (clip.getNaturalSpeed() != null) continue;
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Natural speed must be specified."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            return true;
        }
    }

    public static class FileChooserField
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final ValueField<Path> d_field;
        private final JButton d_browseButton;

        public FileChooserField(boolean allowEmpty, FileChooser.ExtensionFilter ... filters) {
            this.d_field = new ValueField<Object>(FileChooserField.getFormatterFactory(allowEmpty), null);
            this.d_field.setAccurateValidate(true);
            this.d_browseButton = new JButton("...");
            this.d_browseButton.addActionListener(e -> {
                Path path = (Path)this.d_field.getValue();
                guiJFXFileChooser chooser = new guiJFXFileChooser(path != null && path.getFileName() != null ? path.getFileName().toString() : null, path != null && path.getParent() != null ? path.getParent().toString() : MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, filters);
                File f = chooser.showOpenDialog();
                if (f == null) {
                    return;
                }
                MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
                this.setSelectedFile(f.getPath());
                this.setModified(true);
            });
            this.setLayout(new MigLayout("insets 0, gap 6", "[fill,grow][fill]"));
            this.add(this.d_field);
            this.add(this.d_browseButton);
        }

        private static JFormattedTextField.AbstractFormatterFactory getFormatterFactory(boolean allowEmpty) {
            Function<Boolean, guiFormattedFld.Formatter> newFormatter = display -> {
                guiFormattedFld.Formatter<Path> formatter = new guiFormattedFld.Formatter<Path>(new PathFormat((boolean)display));
                formatter.setNullAllowed(allowEmpty);
                formatter.setFilter(new PathFilter());
                formatter.setCursorInstallPosition((ftf, oldLength, oldPosition) -> {
                    BoundedRangeModel hrange = ftf.getHorizontalVisibility();
                    ftf.setScrollOffset(hrange.getExtent());
                    int oldPosFromEnd = oldLength - oldPosition;
                    int newPos = ftf.getDocument().getLength() - oldPosFromEnd;
                    if (newPos >= 0 && newPos <= ftf.getDocument().getLength()) {
                        ftf.setCaretPosition(newPos);
                    } else {
                        ftf.setCaretPosition(ftf.getDocument().getLength());
                    }
                });
                return formatter;
            };
            guiFormattedFld.Formatter defFormatter = newFormatter.apply(false);
            guiFormattedFld.Formatter displayFormatter = newFormatter.apply(true);
            return new DefaultFormatterFactory(defFormatter, displayFormatter);
        }

        public String getSelectedFile() {
            return this.d_field.getValue() != null ? ((Path)this.d_field.getValue()).toString() : null;
        }

        public void setSelectedFile(String path) {
            this.d_field.setValue(path == null || path.trim().isEmpty() ? null : Paths.get(path, new String[0]));
        }

        private static class PathFormat
        extends AFormat<Path> {
            private static final long serialVersionUID = 1L;
            private final boolean d_display;

            private PathFormat(boolean display) {
                this.d_display = display;
            }

            @Override
            protected Path parse(String text) throws ParseException {
                try {
                    return Paths.get(text, new String[0]);
                }
                catch (InvalidPathException e) {
                    throw new ParseException(e.getLocalizedMessage(), 0);
                }
            }

            @Override
            protected String toString(Path val) {
                return this.d_display ? Optional.ofNullable(val.getFileName()).map(p -> p.toString()).orElse("") : val.toString();
            }
        }

        private static class PathFilter
        implements Predicate<Path> {
            private PathFilter() {
            }

            @Override
            public boolean test(Path t) {
                return Files.exists(t, new LinkOption[0]) && Files.isRegularFile(t, new LinkOption[0]);
            }

            public String toString() {
                return Intl.intl("A valid path must be specified.");
            }
        }
    }

    private static class AnimationTransformPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final guiUnitDoubleField d_scale = new MerlinUDF(Unit.ONE, DoubleVR.above(0.0, false));
        private final guiUnitDoubleField d_xOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_yOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_zOffset = new MerlinUDF((Unit)SI.METER, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotXAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotYAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotZAxis = new MerlinUDF(Unit.ONE, DoubleVR.unbounded());
        private final guiUnitDoubleField d_rotAngle = new MerlinUDF(SI.RADIAN, DoubleVR.between(0.0, Math.PI * 2));

        public AnimationTransformPanel() {
            this.setLayout(new MigLayout("insets 0, gap 6"));
            this.add(guiUtil.lblProp(Intl.intl("Scale"), Intl.intl("Scale applied to the model during animation.")));
            this.add((Component)this.d_scale, "wrap, span, grow");
            this.add(guiUtil.lblProp(Intl.intl("Rotation"), Intl.intl("Rotation about an axis applied to the model during animation using the right-hand rule.")));
            this.add(this.d_rotAngle);
            this.add(guiUtil.lblProp(Intl.intl("X"), Intl.intl("X-Component of the rotation axis.")));
            this.add(this.d_rotXAxis);
            this.add(guiUtil.lblProp(Intl.intl("Y"), Intl.intl("Y-Component of the rotation axis.")));
            this.add(this.d_rotYAxis);
            this.add(guiUtil.lblProp(Intl.intl("Z"), Intl.intl("Z-Component of the rotation axis.")));
            this.add((Component)this.d_rotZAxis, "wrap");
            this.add((Component)guiUtil.lblProp(Intl.intl("Offset"), Intl.intl("Translational offset applied to the model during animation.")), "span 2, grow");
            this.add(guiUtil.lblProp(Intl.intl("X"), Intl.intl("X-Component of the translation.")));
            this.add(this.d_xOffset);
            this.add(guiUtil.lblProp(Intl.intl("Y"), Intl.intl("Y-Component of the translation.")));
            this.add(this.d_yOffset);
            this.add(guiUtil.lblProp(Intl.intl("Z"), Intl.intl("Z-Component of the translation.")));
            this.add((Component)this.d_zOffset, "wrap");
        }

        public AnimationTransform getValue() {
            UnitPoint3D translation = new UnitPoint3D((UnitDouble)this.d_xOffset.getValue(), (UnitDouble)this.d_yOffset.getValue(), (UnitDouble)this.d_zOffset.getValue());
            Vector3d rotAxis = new Vector3d(((UnitDouble)this.d_rotXAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotYAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotZAxis.getValue()).getRawValue());
            rotAxis.normalize();
            return new AnimationTransform((UnitDouble)this.d_scale.getValue(), (UnitDouble)this.d_rotAngle.getValue(), rotAxis, translation);
        }

        public void setValue(AnimationTransform xform) {
            this.d_scale.setValue(xform.getScale());
            this.d_rotAngle.setValue(xform.getRotation());
            Vector3d rotAxis = xform.getRotationAxis();
            this.d_rotXAxis.setValue(new UnitDouble(rotAxis.x, Unit.ONE));
            this.d_rotYAxis.setValue(new UnitDouble(rotAxis.y, Unit.ONE));
            this.d_rotZAxis.setValue(new UnitDouble(rotAxis.z, Unit.ONE));
            UnitPoint3D offset = xform.getTranslation();
            this.d_xOffset.setValue(offset.xu());
            this.d_yOffset.setValue(offset.yu());
            this.d_zOffset.setValue(offset.zu());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (Util3D.isVecZero(new Vector3d(((UnitDouble)this.d_rotXAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotYAxis.getValue()).getRawValue(), ((UnitDouble)this.d_rotZAxis.getValue()).getRawValue()))) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Rotation axis cannot be zero."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private static class NameFilter
    implements Predicate<String> {
        private NameFilter() {
        }

        @Override
        public boolean test(String t) {
            try {
                Paths.get(t, new String[0]);
                return true;
            }
            catch (InvalidPathException e) {
                return false;
            }
        }

        public String toString() {
            return Intl.intl("A valid name must be specified.");
        }
    }
}

