/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import merlin.Intl;
import merlin.gui.CheckboxTableCellRenderer;
import merlin.gui.MultiStateBooleanTableCell;
import merlin.gui.SearchField;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public abstract class ABooleanListDlg<T>
extends guiDialog {
    public static final int OPT_SHOW_GROUPS = 1;
    public static final int OPT_SHOW_GROUPS_BY_DEFAULT = 2;
    public static final int OPT_ALLOW_ANY = 4;
    public static final int OPT_REQUIRE_NONEMPTY = 8;
    private static final long serialVersionUID = 1L;
    private final thunderheadeng.gui.SearchField<T> d_filter;
    private final guiRadioButton d_anyBtn;
    private final guiRadioButton d_chooseBtn;
    private final guiTable d_table;
    private final CheckboxTableCellRenderer d_enabledHeaderRenderer;
    private final MultiStateBooleanTableCell d_enabledCell;
    private final JButton d_clearSelBtn;
    private final guiLabel d_countLbl;
    private final Semaphore d_lock;
    private final guiCheckBox d_showOnlySelected;
    private final guiCheckBox d_showPathBox;
    private final HTMLBtn d_showingCountLbl;
    private int d_options;
    private List<T> d_availObjs = Collections.emptyList();

    protected ABooleanListDlg(Window parent, String title, String tableHeader, String label, int options, boolean showSelDef) {
        this(parent, title, tableHeader, label, options, showSelDef, null);
    }

    protected ABooleanListDlg(Window parent, String title, String tableHeader, String label, int options, boolean showSelDef, TableCellRenderer baseCellRenderer) {
        super(parent, title, 9);
        this.d_options = options;
        this.d_filter = new thunderheadeng.gui.SearchField<Object>(() -> this.d_availObjs.stream(), obj -> this.format(obj));
        this.d_anyBtn = new guiRadioButton(Intl.intl("Any"));
        this.d_chooseBtn = new guiRadioButton(Intl.intl("Choose"));
        this.d_showOnlySelected = new guiCheckBox(Intl.intl("Display only selected rows"));
        this.d_showOnlySelected.setToolTipText(Intl.intl("If checked, only selected rows are displayed in the list. Uncheck to display all available rows."));
        this.d_showingCountLbl = new HTMLBtn("");
        this.d_showingCountLbl.addActionListener(e -> {
            this.d_filter.clear();
            this.d_showOnlySelected.setSelected(false);
            this.updateTable();
        });
        this.d_clearSelBtn = new JButton(Intl.intl("Clear"));
        this.d_clearSelBtn.setToolTipText(Intl.intl("Clears the entire selection, including hidden rows."));
        this.d_clearSelBtn.addActionListener(e -> this.getModel().setSelObjs(Collections.emptySet()));
        if (showSelDef) {
            this.d_showOnlySelected.setSelected(true);
        }
        this.d_showOnlySelected.addActionListener(e -> {
            if (this.d_showOnlySelected.isSelected() && !this.d_filter.isEmpty()) {
                this.d_filter.clear();
            } else {
                this.updateTable();
            }
        });
        this.d_filter.addObserver((fld, evt) -> {
            if (evt == SearchField.SHOW_ALL_MATCHES) {
                this.d_showOnlySelected.setSelected(false);
            }
            this.updateTable();
        }, false);
        this.d_showPathBox = new guiCheckBox(Intl.intl("Show group labels"), (this.d_options & 2) != 0);
        this.d_showPathBox.setToolTipText(Intl.intl("If checked, group labels are shown with the names of the objects."));
        this.d_lock = new Semaphore(1);
        this.d_countLbl = new guiLabel("test");
        this.d_countLbl.setFont(this.d_countLbl.getFont().deriveFont(1));
        guiButtonGroup btnGroup = new guiButtonGroup(this.d_anyBtn, this.d_chooseBtn);
        if ((this.d_options & 4) == 0) {
            this.d_anyBtn.setVisible(false);
            this.d_chooseBtn.setVisible(false);
            this.d_chooseBtn.setSelected(true);
        } else {
            this.d_anyBtn.setVisible(true);
            this.d_chooseBtn.setVisible(true);
            this.d_chooseBtn.setSelected(false);
        }
        ObjTableModel tm = new ObjTableModel();
        this.d_table = new guiTable(tm, 0);
        this.d_table.setRowSelectionAllowed(true);
        this.d_table.setColumnSelectionAllowed(false);
        this.d_table.setShowVerticalLines(false);
        this.d_enabledHeaderRenderer = new CheckboxTableCellRenderer();
        this.d_enabledCell = new MultiStateBooleanTableCell();
        TableColumn enabledCol = this.d_table.getColumnModel().getColumn(0);
        enabledCol.setHeaderValue(Boolean.FALSE);
        enabledCol.setHeaderRenderer(this.d_enabledHeaderRenderer);
        enabledCol.setCellRenderer(this.d_enabledCell);
        enabledCol.setCellEditor(this.d_enabledCell);
        TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
        objCol.setHeaderValue(tableHeader);
        MouseAdapter selColList = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col;
                if (SwingUtilities.isLeftMouseButton(e) && (col = ABooleanListDlg.this.d_table.columnAtPoint(e.getPoint())) == 1) {
                    int row = ABooleanListDlg.this.d_table.rowAtPoint(e.getPoint());
                    Boolean val = (Boolean)ABooleanListDlg.this.d_table.getValueAt(row, 0);
                    val = val != null ? !val.booleanValue() : true;
                    ABooleanListDlg.this.d_table.setValueAt(val, row, 0);
                }
            }
        };
        this.d_table.addMouseListener(selColList);
        TableCellRenderer objCellRend = baseCellRenderer != null ? baseCellRenderer : new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(ABooleanListDlg.this.format(value));
                return comp;
            }
        };
        objCol.setCellRenderer(objCellRend);
        this.d_enabledHeaderRenderer.addActionListener(e -> {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            IListenerStripper listeners = this.stripModelListeners(this.d_table);
            LinkedIdentityHashSet<T> allSel = new LinkedIdentityHashSet<T>(this.getModel().getSelObjs());
            List<T> shownObjs = this.getModel().getAvailObjs();
            if (this.d_enabledHeaderRenderer.isSelected()) {
                allSel.addAll(shownObjs);
            } else {
                allSel.removeAll(shownObjs);
            }
            this.getModel().setSelObjs(allSel);
            this.d_lock.release();
            listeners.restore();
            this.handleTableChanged();
        });
        this.d_table.getModel().addTableModelListener(e -> this.handleTableChanged());
        this.d_showPathBox.addItemListener(e -> {
            if (this.d_filter.isEmpty()) {
                this.d_table.repaint();
            } else {
                this.updateTable();
            }
        });
        LinkStatus.link((AbstractButton)this.d_chooseBtn, this.d_table, this.d_countLbl, this.d_showPathBox, this.d_showOnlySelected, this.d_filter, this.d_showingCountLbl);
        ItemListener btnListener = e -> {
            if (e.getStateChange() == 1) {
                this.handleTableChanged();
            }
        };
        btnGroup.stream().forEach(btn -> btn.addItemListener(btnListener));
        JScrollPane sp = new JScrollPane(this.d_table);
        if (this.d_showPathBox.isSelected()) {
            sp.setPreferredSize(new Dimension(300, 150));
        } else {
            sp.setPreferredSize(new Dimension(200, 120));
        }
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        if (label != null) {
            HTMLLabel lbl = new HTMLLabel(label, 200);
            lbl.setMinimumSize(new Dimension(1, lbl.getPreferredSize().height));
            lbl.setPreferredWidth(1);
            lbl.setWrapEnabled(true);
            lbl.setOpenLinksAsWebpages(false);
            gb.addFilledRow(lbl);
        }
        if ((this.d_options & 4) == 4) {
            gb.addRow(this.d_anyBtn);
            gb.addRow(this.d_chooseBtn);
            gb.indent();
        }
        gb.addFilledRow(this.d_filter);
        gb.addRow(sp, new double[]{1.0, 1.0});
        guiPanel gbpnl = new guiPanel();
        GridBagHelper gbcount = new GridBagHelper(gbpnl);
        gbcount.addRow(this.d_countLbl, this.d_clearSelBtn);
        gb.addRow(new Object[]{gbpnl, GridBagHelper.Anchor.CENTER, 0});
        gb.addFilledRow(this.d_showingCountLbl);
        gb.addRow(this.d_showOnlySelected);
        if ((this.d_options & 1) != 0) {
            gb.addRow(this.d_showPathBox);
        }
        enabledCol.sizeWidthToFit();
        this.setResizable(true);
    }

    private void handleTableChanged() {
        int count = this.getModel().getEnabledCount();
        String text = count == 1 ? Intl.intl("1 row selected") : String.format(Intl.intl("%d rows selected"), count);
        this.d_countLbl.setText(text);
        if (this.getModel().getAvailObjs().size() < this.d_availObjs.size()) {
            this.d_showingCountLbl.setText(String.format(Intl.intl("Displaying %1$d/%2$d rows"), this.getModel().getAvailObjs().size(), this.d_availObjs.size()));
            this.d_showingCountLbl.setVisible(true);
            this.d_showingCountLbl.setToolTipText(Intl.intl("Click to display all rows"));
        } else {
            this.d_showingCountLbl.setVisible(false);
        }
        this.d_clearSelBtn.setEnabled(this.d_chooseBtn.isSelected() && !this.getModel().getSelObjs().isEmpty());
        if (!this.d_lock.tryAcquire()) {
            return;
        }
        boolean allEnabled = this.getModel().areAllEnabled();
        this.d_enabledHeaderRenderer.setSelected(allEnabled);
        this.d_table.getTableHeader().repaint();
        this.d_table.repaint();
        this.d_lock.release();
    }

    public abstract String format(T var1);

    protected boolean isShowPath() {
        return this.d_showPathBox.isSelected();
    }

    private IListenerStripper stripModelListeners(JTable table) {
        ObjTableModel<T> model = this.getModel();
        return guiUtil.stripListeners(model::addTableModelListener, model::getTableModelListeners, model::removeTableModelListener);
    }

    public void setAvailObjs(List<T> availObjs) {
        this.d_availObjs = availObjs;
        this.updateTable();
    }

    public void setObjectSelectionState(Set<T> selObjs) {
        this.setObjectSelectionState(selObjs, Collections.emptySet());
    }

    public void setObjectSelectionState(Set<T> selObjs, Set<T> semiSelObjs) {
        boolean anyAllowed;
        this.updateTable(selObjs, semiSelObjs);
        boolean bl = anyAllowed = (this.d_options & 4) != 0;
        if (selObjs == null) {
            this.d_anyBtn.setSelected(false);
            this.d_chooseBtn.setSelected(false);
        } else if (selObjs.isEmpty() && anyAllowed) {
            this.d_anyBtn.setSelected(true);
        } else {
            this.d_chooseBtn.setSelected(true);
        }
    }

    private void updateTable() {
        Set<T> selObjs = this.getModel().getSelObjs();
        Set<T> semiSelObjs = this.getModel().getSemiSelObjs();
        this.updateTable(selObjs, semiSelObjs);
    }

    private void updateTable(Set<T> selObjs, Set<T> semiSelObjs) {
        Predicate filter = this.d_showOnlySelected.isSelected() && selObjs != null ? Filters.accept(selObjs).or(Filters.accept(semiSelObjs)) : Predicates.alwaysTrue();
        filter = Predicates.and(filter, this.d_filter.getFilter());
        IFilteredCollection<T> availObjs = theUtil.filter(this.d_availObjs, filter);
        ObjTableModel<T> model = this.getModel();
        model.setAvailObjs(new ArrayList<T>(availObjs), selObjs != null ? selObjs : Collections.emptySet(), semiSelObjs != null ? semiSelObjs : Collections.emptySet());
        this.handleTableChanged();
    }

    public <T2> Set<T2> getSelectedObjs(Class<T2> clazz) {
        if (this.d_anyBtn.isSelected()) {
            return Collections.EMPTY_SET;
        }
        if (this.d_chooseBtn.isSelected()) {
            return new LinkedIdentityHashSet<T2>(theUtil.filter(this.getModel().getSelObjs(), clazz));
        }
        return null;
    }

    public <T2> Set<T2> getSemiSelectedObjs(Class<T2> clazz) {
        if (this.d_anyBtn.isSelected()) {
            return Collections.EMPTY_SET;
        }
        if (this.d_chooseBtn.isSelected()) {
            return new LinkedIdentityHashSet<T2>(theUtil.filter(this.getModel().getSemiSelObjs(), clazz));
        }
        return null;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if ((this.d_options & 8) != 0 && this.getModel().getSelObjs().isEmpty()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("At least one object must be selected."), Intl.intl("Invalid Selection"), 0);
            }
            return false;
        }
        if (showWarn && this.d_chooseBtn.isSelected() && this.getModel().getAvailObjs().size() != this.d_availObjs.size()) {
            IdentityHashSet listedObjs = new IdentityHashSet(this.getModel().getAvailObjs());
            if (this.getModel().getSelObjs().stream().anyMatch(o -> !listedObjs.contains(o))) {
                int option = JOptionPane.showConfirmDialog(this, Intl.intl("Some selected rows are not displayed in the list. Do you want to continue anyway?\nClick No to cancel and see the entire selection for review."), Intl.intl("Hidden Selected Rows"), 1);
                if (option == 1) {
                    if (allowModify) {
                        this.d_filter.clear();
                        this.d_showOnlySelected.setSelected(true);
                        this.updateTable();
                    }
                    return false;
                }
                if (option != 0) {
                    return false;
                }
            }
        }
        return true;
    }

    private ObjTableModel<T> getModel() {
        return (ObjTableModel)this.d_table.getModel();
    }

    private static class ObjTableModel<T>
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<T> d_availObjs;
        private Set<T> d_selObjs;
        private Set<T> d_semiSelObjs;

        public ObjTableModel() {
            this(Collections.emptyList(), Collections.emptySet(), Collections.emptySet());
        }

        public ObjTableModel(List<T> availObjs, Collection<T> initSelObjs, Collection<T> semiSelObjs) {
            this.d_availObjs = availObjs;
            this.d_selObjs = new LinkedIdentityHashSet<T>(initSelObjs);
            this.d_semiSelObjs = new LinkedIdentityHashSet<T>(semiSelObjs);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        public void setAvailObjs(List<T> objs, Collection<T> selObjs, Collection<T> semiSelObjs) {
            this.d_availObjs = objs;
            if (selObjs != this.d_selObjs) {
                this.d_selObjs = new LinkedIdentityHashSet<T>(selObjs);
            }
            if (semiSelObjs != this.d_semiSelObjs) {
                this.d_semiSelObjs = new LinkedIdentityHashSet<T>(semiSelObjs);
            }
            this.fireTableDataChanged();
        }

        public List<T> getAvailObjs() {
            return Collections.unmodifiableList(this.d_availObjs);
        }

        public Set<T> getSelObjs() {
            return Collections.unmodifiableSet(this.d_selObjs);
        }

        public Set<T> getSemiSelObjs() {
            return Collections.unmodifiableSet(this.d_semiSelObjs);
        }

        public void setSelObjs(Collection<T> selObjs) {
            this.d_selObjs = new LinkedIdentityHashSet<T>(selObjs);
            this.d_semiSelObjs = new LinkedIdentityHashSet<T>(this.d_semiSelObjs);
            this.d_semiSelObjs.removeAll(this.d_selObjs);
            if (!this.d_availObjs.isEmpty()) {
                this.fireTableRowsUpdated(0, this.d_availObjs.size() - 1);
            }
        }

        public void setSemiSelObjs(Collection<T> semiSelObjs) {
            this.d_semiSelObjs = new LinkedIdentityHashSet<T>(semiSelObjs);
            this.d_selObjs = new LinkedIdentityHashSet<T>(this.d_selObjs);
            this.d_selObjs.removeAll(this.d_semiSelObjs);
            if (!this.d_availObjs.isEmpty()) {
                this.fireTableRowsUpdated(0, this.d_availObjs.size() - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public int getRowCount() {
            return this.d_availObjs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> {
                    if (this.d_selObjs.contains(this.d_availObjs.get(rowIndex))) {
                        yield Boolean.TRUE;
                    }
                    if (this.d_semiSelObjs.contains(this.d_availObjs.get(rowIndex))) {
                        yield null;
                    }
                    yield Boolean.FALSE;
                }
                case 1 -> (Boolean)this.d_availObjs.get(rowIndex);
                default -> null;
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Boolean bval = (Boolean)aValue;
                    if (bval != null && bval.booleanValue()) {
                        this.d_selObjs.add(this.d_availObjs.get(rowIndex));
                        this.d_semiSelObjs.remove(this.d_availObjs.get(rowIndex));
                    } else {
                        this.d_selObjs.remove(this.d_availObjs.get(rowIndex));
                        this.d_semiSelObjs.remove(this.d_availObjs.get(rowIndex));
                    }
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public boolean areAllEnabled() {
            return !this.d_availObjs.isEmpty() && this.d_availObjs.stream().allMatch(o -> this.d_selObjs.contains(o));
        }

        public int getEnabledCount() {
            return this.d_selObjs.size();
        }
    }
}

