/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class GeomLocator {
    public static final int INCLUDE_INVISIBLE = 1;
    public static final int INCLUDE_DISABLED = 2;
    public static final int EXCLUDE_FINITE = 4;
    private final MerlinData d_data;
    private final RTree<IDisplayableGeomSrc> d_finite;
    private final Set<IDisplayableGeomSrc> d_infinite;

    public GeomLocator(MerlinData data) {
        this.d_data = data;
        this.d_finite = new RTree(2, 16);
        this.d_infinite = new LinkedIdentityHashSet<IDisplayableGeomSrc>();
    }

    public AABox getBounds() {
        return this.d_finite.getBoundingBox();
    }

    public void pauseCondensing() {
        this.d_finite.pauseCondensing();
    }

    public void resumeCondensing() {
        this.d_finite.resumeCondensing();
    }

    public void add(IDisplayableGeomSrc geom) {
        AABox bounds = geom.getBounds();
        if (bounds == null || bounds.isInfinite()) {
            this.d_infinite.add(geom);
        } else {
            this.d_finite.insert(bounds, geom);
        }
    }

    public void add(Collection<? extends IDisplayableGeomSrc> searchGeom) {
        for (IDisplayableGeomSrc iDisplayableGeomSrc : searchGeom) {
            this.add(iDisplayableGeomSrc);
        }
    }

    public boolean remove(IDisplayableGeomSrc geom) {
        this.pauseCondensing();
        boolean result = true;
        if (!this.d_infinite.remove(geom)) {
            result = this.d_finite.remove(geom);
        }
        this.resumeCondensing();
        return result;
    }

    public boolean remove(Collection<? extends IDisplayableGeomSrc> searchGeom) {
        this.pauseCondensing();
        boolean result = true;
        for (IDisplayableGeomSrc iDisplayableGeomSrc : searchGeom) {
            result &= this.remove(iDisplayableGeomSrc);
        }
        this.resumeCondensing();
        return result;
    }

    public void update(IDisplayableGeomSrc geom) {
        this.remove(geom);
        this.add(geom);
    }

    public void find(ITest<AABox> test, IResult<? super IDisplayableGeomSrc> result, int options) {
        if ((options & 4) == 0) {
            this.find(test, result, this.d_finite, options);
        }
        this.find(result, this.d_infinite, options);
    }

    public <T extends IDisplayableGeomSrc> Collection<T> find(ITest<AABox> test, Class<T> type, int options) {
        return this.find(test, type, Predicates.alwaysTrue(), options);
    }

    public <T extends IDisplayableGeomSrc> void find(ITest<AABox> test, Class<T> type, int options, Consumer<T> result) {
        this.find(test, type, Predicates.alwaysTrue(), options, result);
    }

    public <T extends IDisplayableGeomSrc> Collection<T> find(ITest<AABox> test, Class<T> type, Predicate<T> filter, int options) {
        ArrayList result = new ArrayList();
        this.find(test, type, filter, options, result::add);
        return result;
    }

    public <T extends IDisplayableGeomSrc> void find(ITest<AABox> test, Class<T> type, Predicate<T> filter, int options, Consumer<T> result) {
        this.find(test, (? super IDisplayableGeomSrc obj, Containment ctmt) -> {
            if (type.isInstance(obj) && filter.test((IDisplayableGeomSrc)type.cast(obj))) {
                result.accept((IDisplayableGeomSrc)type.cast(obj));
            }
        }, options);
    }

    private void find(ITest<AABox> test, final IResult<? super IDisplayableGeomSrc> result, RTree<IDisplayableGeomSrc> finiteGeom, final int options) {
        IResult<IDisplayableGeomSrc> res = result;
        if ((options & 1) == 0 || (options & 2) == 0) {
            res = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if ((options & 1) == 0 && !GeomLocator.this.isVisible(obj)) {
                        return;
                    }
                    if ((options & 2) == 0 && !GeomLocator.this.isEnabled(obj)) {
                        return;
                    }
                    result.mark(obj, ctmt);
                }
            };
        }
        finiteGeom.find(test, res);
    }

    private void find(IResult<? super IDisplayableGeomSrc> result, Set<IDisplayableGeomSrc> infiniteGeom, int options) {
        for (IDisplayableGeomSrc geom : infiniteGeom) {
            if ((options & 1) == 0 && !this.isVisible(geom) || (options & 2) == 0 && !this.isEnabled(geom)) continue;
            result.mark(geom, Containment.INTERSECTS);
        }
    }

    private boolean isVisible(IDisplayableGeomSrc geom) {
        return this.d_data.isVisible(geom);
    }

    protected boolean isEnabled(IDisplayableGeomSrc obj) {
        if (obj instanceof ICompElement) {
            Object enabled = ((ICompElement)((Object)obj)).getProperty(MerlinData.ENABLED);
            return enabled instanceof Boolean ? (Boolean)enabled : true;
        }
        return true;
    }

    public void reset() {
        this.d_finite.clear();
    }
}

