/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.util.ArrayList;
import java.util.Set;
import merlin.data.MerlinData;
import merlin.geom.GeomLocator;
import thunderheadeng.geometry.AABox;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.LinkedIdentityHashSet;

public class GeomLocation {
    private final GeomLocator d_locator;
    private Set<IDisplayableGeomSrc> d_dirtyGeom;

    public GeomLocation(MerlinData data) {
        this.d_locator = new GeomLocator(data);
        this.clearDirty();
    }

    private void clearDirty() {
        this.d_dirtyGeom = new LinkedIdentityHashSet<IDisplayableGeomSrc>();
    }

    public AABox getBounds() {
        return this.d_locator.getBounds();
    }

    public void add(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void remove(IDisplayableGeomSrc geom) {
        this.d_locator.remove(geom);
        this.d_dirtyGeom.remove(geom);
    }

    public void update(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public GeomLocator getLocator() {
        this.updateDirty();
        return this.d_locator;
    }

    public synchronized void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        ArrayList<IDisplayableGeomSrc> dirty = new ArrayList<IDisplayableGeomSrc>(this.d_dirtyGeom);
        this.clearDirty();
        int count = dirty.size();
        for (int m = 0; m < count; ++m) {
            this.d_locator.update(dirty.get(m));
        }
    }
}

