/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;

public class VariantUtil {
    public static <ValType> IVariant<ValType> newVariant(List<DiscreteVariant.Entry<ValType>> vals) {
        assert (vals.size() >= 1 && vals.get((int)0).t.getValue(SI.SECOND) == 0.0);
        Object initVal = vals.get((int)0).val;
        if (vals.size() == 1) {
            return VariantUtil.newVariant(initVal, new DiscreteVariant.Entry[0]);
        }
        ArrayList<DiscreteVariant.Entry<ValType>> entries = new ArrayList<DiscreteVariant.Entry<ValType>>(vals);
        entries.remove(0);
        return VariantUtil.newVariant(initVal, entries);
    }

    public static <ValType> IVariant<ValType> newVariant(ValType initVal, DiscreteVariant.Entry<ValType> ... vals) {
        return VariantUtil.newVariant(initVal, Arrays.asList(vals));
    }

    public static <ValType> IVariant<ValType> newVariant(ValType initVal, List<DiscreteVariant.Entry<ValType>> vals) {
        vals = new ArrayList<DiscreteVariant.Entry<ValType>>(vals);
        Collections.sort(vals);
        if (!vals.isEmpty() && vals.get((int)0).t.equals(new UnitDouble(0.0, SI.SECOND))) {
            initVal = vals.get((int)0).val;
            vals = vals.subList(1, vals.size());
        }
        if (vals.isEmpty()) {
            return new ConstVariant<ValType>(initVal);
        }
        return new DiscreteVariant<ValType>(initVal, vals.toArray(new DiscreteVariant.Entry[vals.size()]));
    }

    public static <ValType> ValType getInitialValue(IVariant<ValType> var) {
        return var.getInitialValue();
    }

    public static <ValType> IVariant<ValType> setInitialValue(IVariant<ValType> var, ValType initVal) {
        if (var instanceof ConstVariant) {
            return VariantUtil.newVariant(initVal, new DiscreteVariant.Entry[0]);
        }
        if (var instanceof DiscreteVariant) {
            return VariantUtil.newVariant(initVal, ((DiscreteVariant)var).entries);
        }
        assert (false);
        return null;
    }

    public static <ValType> List<DiscreteVariant.Entry<ValType>> getDiscreteValues(IVariant<ValType> var, boolean includeT0) {
        return var.getDiscreteValues(includeT0);
    }

    public static String describeUDVariant(IVariant<UnitDouble> variant, IUnitSrc unitType) {
        return VariantUtil.describeVariant(variant, v -> MerlinUtil.format(v, unitType));
    }

    public static <T> String describeVariant(IVariant<T> variant, Function<T, String> formatVal) {
        if (variant instanceof ConstVariant) {
            ConstVariant cvar = (ConstVariant)variant;
            return String.format(Intl.intl("Always %s"), formatVal.apply(cvar.value));
        }
        if (variant instanceof DiscreteVariant) {
            DiscreteVariant dvar = (DiscreteVariant)variant;
            return String.format(Intl.intl("t(0) = %s, ..."), formatVal.apply(dvar.initVal));
        }
        return "";
    }
}

