/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.property.CompositeProp;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Property;
import thunderheadeng.util.TypeFilter;

public class ScenarioRoot
extends Composite<Scenario>
implements IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<Scenario> ACTIVE_SCENARIO = ((DisplayProps.Builder)DisplayProps.build((Object)"ACTIVE_SCENARIO", Scenario.class, null, Intl.intl("Active Scenario"), Intl.intl("Specifies the active scenario")).attrFormatValue(s -> s.getName())).attrToProp();
    public static final PropertyDefs<ScenarioRoot> LOCAL_PROPS = new PropertyDefs<Composite>(ScenarioRoot.class, Composite.PROP_TYPES, ACTIVE_SCENARIO);
    @SkipDep
    private Scenario d_default;
    @SkipDep
    private Scenario d_activeScenario;
    private transient boolean d_updateLock = false;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(Scenario.class);
    private static final DepCallback<MerlinData, ScenarioRoot, Scenario, Scenario> ACTIVE_SCENARIO_CALLBACK = Dependencies.newDependency(ACTIVE_SCENARIO, DLink.WEAK, Scenario.class, (md, src, scenario) -> Stream.of(scenario), Predicates.alwaysTrue(), (md, src, val, old, replacement) -> {
        assert (old == src.d_activeScenario);
        return replacement != null ? replacement : src.d_default;
    });

    public ScenarioRoot() {
        super(Intl.intl("Scenarios"));
        this.setActive(this.addDefault());
    }

    public ScenarioRoot(String name) {
        super(name);
    }

    @Override
    public ScenarioRoot clone() {
        ScenarioRoot clone = (ScenarioRoot)super.clone();
        clone.d_default = null;
        clone.d_activeScenario = null;
        return clone;
    }

    @Override
    public ScenarioRoot getRestoreObj() {
        ScenarioRoot restore = (ScenarioRoot)super.getRestoreObj();
        restore.d_default = this.d_default;
        restore.d_activeScenario = this.d_activeScenario;
        return restore;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj instanceof ScenarioRoot) {
            ScenarioRoot comp = (ScenarioRoot)obj;
            this.pauseUpdates();
            super.restoreFrom(obj);
            this.d_default = comp.d_default;
            this.setActive(comp.d_activeScenario);
            this.resumeUpdates();
        }
    }

    @Override
    public boolean getScenariosSupported() {
        return false;
    }

    public <ObjT extends ICompElement, ValT> Property<ValT> getDefaultScenarioValue(ObjT obj, IDisplayProp<ValT> prop) {
        Property<ValT> val;
        if (!this.d_activeScenario.isDefault() && (val = this.d_default.getObjValue(obj, prop)).isSupported()) {
            return val;
        }
        Optional<Nullable<ValT>> optVal = obj.getNullableProp(prop.asProp());
        if (optVal.isEmpty()) {
            return Property.notSupported();
        }
        return Property.of(optVal.get().val);
    }

    public <ObjT extends ICompElement, ValT> Property<ScenarioValue<ValT>> getScenarioValue(Scenario scenario, ObjT obj, IDisplayProp<ValT> prop) {
        if (scenario.isDefault()) {
            Property<ValT> val = this.getDefaultScenarioValue(obj, prop);
            if (!val.isSupported()) {
                return Property.notSupported();
            }
            return Property.of(new ScenarioValue<ValT>(true, val.get()));
        }
        if (!scenario.isOverridden(obj, prop)) {
            Property<ScenarioValue<ValT>> defVal = this.getScenarioValue(this.getDefault(), obj, prop);
            return defVal.isSupported() ? Property.of(new ScenarioValue(false, defVal.get().value)) : Property.notSupported();
        }
        Property<ValT> val = scenario.getObjValue(obj, prop);
        return val.isSupported() ? Property.of(new ScenarioValue<ValT>(true, val.get())) : Property.notSupported();
    }

    public <ObjT extends ICompElement, ValT> void setDefaultScenarioValue(ObjT obj, IDisplayProp<ValT> prop, ValT value) {
        if (!this.d_activeScenario.isDefault() && this.d_activeScenario.isOverridden(obj, prop)) {
            this.d_default.setObjValue(obj, prop, value);
            return;
        }
        obj.setProp(prop.asProp(), value);
    }

    public <ObjT extends ICompElement, ValT> boolean setScenarioValue(Scenario scenario, ObjT obj, IDisplayProp<ValT> prop, ValT value) {
        if (!scenario.isDefault() && !scenario.isOverridden(obj, prop)) {
            return false;
        }
        if (scenario.isDefault()) {
            this.setDefaultScenarioValue(obj, prop, value);
            return true;
        }
        scenario.setObjValue(obj, prop, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Scenario scenario) {
        if (this.d_activeScenario == scenario) {
            return;
        }
        this.pauseUpdates();
        assert (!this.d_updateLock);
        this.d_updateLock = true;
        try {
            this.d_activeScenario = scenario;
            this.changedEvt(ACTIVE_SCENARIO);
            if (scenario.isDefault()) {
                for (ICompElement obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> obj.setProp((IPropertySet.Prop)entry.v1, entry.v2));
                }
                scenario.clearAllObjValues();
            } else {
                record ObjPropVal(ICompElement obj, IDisplayProp prop, Object val) {
                }
                ArrayList moveToDefault = new ArrayList();
                for (ICompElement obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> {
                        Optional objVal;
                        IDisplayProp prop = (IDisplayProp)entry.v1;
                        if (!this.d_default.isObjValueDefined(obj, prop) && (objVal = obj.getNullableProp(prop.asProp())).isPresent()) {
                            Object toStore = objVal.get().val;
                            moveToDefault.add(new ObjPropVal(obj, prop, toStore));
                        }
                    });
                }
                ArrayList clearFromDefault = new ArrayList();
                for (ICompElement obj : this.d_default.getCustomizedObjects()) {
                    this.d_default.streamCustomVals(obj).forEach(entry -> {
                        IDisplayProp prop = (IDisplayProp)entry.v1;
                        if (!scenario.isObjValueDefined(obj, prop)) {
                            obj.setProp((IPropertySet.Prop)((Object)prop), entry.v2);
                            clearFromDefault.add(new Pair<ICompElement, IDisplayProp>(obj, prop));
                        }
                    });
                }
                clearFromDefault.stream().forEach(p -> this.d_default.clearObjValue((ICompElement)p.v1, (IDisplayProp)p.v2));
                moveToDefault.forEach(v -> this.d_default.setObjValue(v.obj, v.prop, v.val));
                for (ICompElement obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> {
                        IDisplayProp prop = (IDisplayProp)entry.v1;
                        obj.setProp((IPropertySet.Prop)((Object)prop), entry.v2);
                    });
                }
            }
        }
        finally {
            this.d_updateLock = false;
            this.resumeUpdates();
        }
    }

    public Scenario getActive() {
        return this.d_activeScenario;
    }

    @Override
    public PropertyDefs<ScenarioRoot> getAllLocalProperties() {
        return LOCAL_PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return LOCAL_PROPS.props();
        }
        return super.getPropTypes(options);
    }

    @Override
    public Object getProperty(Object property) {
        if (property == ACTIVE_SCENARIO) {
            return this.d_activeScenario;
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == ACTIVE_SCENARIO) {
            this.setActive((Scenario)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public void notifyObjModified(ICompElement obj, Object[] changes) {
        boolean isGenericChange;
        if (this.d_updateLock || this.d_activeScenario.isDefault()) {
            return;
        }
        if (!this.d_activeScenario.isOverridden(obj)) {
            return;
        }
        BiConsumer<IDisplayProp, Boolean> updateProp = (overrideProp, expectPresent) -> {
            Object toStore;
            Optional objVal = obj.getNullableProp(overrideProp.asProp());
            if (objVal.isPresent()) {
                toStore = objVal.get().val;
            } else {
                assert (!expectPresent.booleanValue()) : String.format("The property, %s, was customized in scenario %s, but isn't supported by %s.", overrideProp.asProp().key, this.d_activeScenario.getName(), obj.getClass().getSimpleName());
                toStore = overrideProp.asProp().defVal;
            }
            this.d_activeScenario.setObjValue(obj, overrideProp, toStore);
        };
        boolean bl = isGenericChange = changes.length == 0 || Stream.of(changes).anyMatch(c -> c == EventChannel.EVT_GENERAL);
        if (isGenericChange) {
            this.d_activeScenario.streamCustomProps(obj).toList().forEach(prop -> updateProp.accept((IDisplayProp)prop, false));
        } else {
            Stream.of(changes).map(change -> ScenarioUtil.asScenarioProp(change)).filter(sprop -> sprop.isPresent()).map(sprop -> (IDisplayProp)sprop.get()).filter(sprop -> this.d_activeScenario.isOverridden(obj, sprop)).forEach(prop -> updateProp.accept((IDisplayProp)prop, true));
        }
    }

    public Stream<? extends IDisplayProp<?>> streamActiveOverrides(ICompElement obj) {
        return this.d_activeScenario.streamCustomProps(obj);
    }

    public boolean anyOverriden(Collection<? extends IDomainObject> objs) {
        Collection<Scenario> scenarios = this.flatten(Scenario.class);
        Collection<ICompElement> flattenedObjs = MerlinUtil.flatten(objs, ICompElement.class);
        return scenarios.stream().filter(scenario -> !scenario.isDefault()).anyMatch(scenario -> flattenedObjs.stream().anyMatch(scenario::isOverridden));
    }

    public boolean setOverrides(MerlinData md, ICompElement obj, Collection<? extends IDisplayProp<?>> overrides) {
        if (this.d_activeScenario.isDefault()) {
            return false;
        }
        this.setOverrides(md, obj, Map.of(this.d_activeScenario, overrides));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrides(MerlinData md, ICompElement obj, Map<Scenario, ? extends Collection<? extends IDisplayProp<?>>> scenarioOverrides) {
        assert (scenarioOverrides.values().stream().noneMatch(prop -> prop instanceof CompositeProp));
        this.pauseUpdates();
        assert (!this.d_updateLock);
        this.d_updateLock = true;
        try {
            ArrayList<ScenarioChange> scenarioChanges = new ArrayList<ScenarioChange>();
            ArrayList newObjVals = new ArrayList();
            for (Map.Entry<Scenario, Collection<IDisplayProp<?>>> scenarioEntry : scenarioOverrides.entrySet()) {
                Scenario scenario = scenarioEntry.getKey();
                if (scenario.isDefault()) continue;
                Collection<IDisplayProp<?>> overrides = scenarioEntry.getValue();
                scenario.streamCustomProps(obj).forEach(prop -> {
                    Property defVal;
                    if (overrides.contains(prop)) {
                        return;
                    }
                    scenarioChanges.add(new ScenarioChange(scenario, (IDisplayProp<?>)prop, Property.notSupported()));
                    if (this.d_activeScenario == scenario && (defVal = this.d_default.getObjValue(obj, prop)).isSupported()) {
                        newObjVals.add(new Pair((IDisplayProp)prop, defVal.get()));
                        scenarioChanges.add(new ScenarioChange(this.d_default, (IDisplayProp<?>)prop, Property.notSupported()));
                    }
                });
                for (IDisplayProp<?> overrideProp : overrides) {
                    if (scenario.isObjValueDefined(obj, overrideProp)) continue;
                    Optional<Nullable<?>> objVal = obj.getNullableProp(overrideProp.asProp());
                    Property newVal = objVal.isPresent() ? Property.of(objVal.get().val) : Property.of(overrideProp.asProp().defVal);
                    scenarioChanges.add(new ScenarioChange(scenario, overrideProp, newVal));
                    if (this.d_activeScenario != scenario) continue;
                    scenarioChanges.add(new ScenarioChange(this.d_default, overrideProp, newVal));
                }
            }
            if (!scenarioChanges.isEmpty()) {
                Undo.insertEntry(md, new ApplyScenarioOverrides(obj, scenarioChanges).perform());
            }
            if (!newObjVals.isEmpty()) {
                boolean restoreWhole;
                boolean bl = restoreWhole = obj instanceof IRestorable && newObjVals.stream().map(p -> (IDisplayProp)p.v1).anyMatch(prop -> obj.isWrapperProp(prop));
                if (restoreWhole) {
                    Undo.insertUndoEntry_restore(md, (IRestorable)((Object)obj));
                } else {
                    newObjVals.stream().map(pair -> (IDisplayProp)pair.v1).forEach(prop -> Undo.insertUndoEntry_propRestore(md, Collections.singleton(obj), prop));
                }
                newObjVals.stream().forEach(pair -> obj.setProperty(pair.v1, pair.v2));
            }
        }
        finally {
            this.d_updateLock = false;
            this.resumeUpdates();
        }
    }

    public Scenario getDefault() {
        return this.d_default;
    }

    private Scenario addDefault() {
        Scenario def = new Scenario();
        this.add(def);
        assert (this.d_default == def);
        return def;
    }

    @Override
    public void clear() {
        this.pauseUpdates();
        this.d_default = null;
        this.d_activeScenario = null;
        super.clear();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean remove(ICompElement obj) {
        Scenario scenario;
        assert (obj != this.d_activeScenario) : "The active scenario must not be removed without using the dependency system.";
        if (obj instanceof Scenario && (scenario = (Scenario)obj).isDefault()) {
            if (scenario != this.d_default) {
                assert (false) : "Trying to remove a default scenario that is not currently the registered default.";
                return false;
            }
            this.d_default = null;
        }
        return super.remove(obj);
    }

    @Override
    public void add(ICompElement obj) {
        this.checkForAdd(obj);
        super.add(obj);
    }

    public void insert(Scenario[] objs, int[] insertPositions) {
        Stream.of(objs).forEach(this::checkForAdd);
        super.insert((ICompElement[])objs, insertPositions);
    }

    @Override
    public void insert(Collection<? extends ICompElement> objs, int insertPos) {
        objs.forEach(this::checkForAdd);
        super.insert(objs, insertPos);
    }

    private void checkForAdd(ICompElement obj) {
        Scenario scenario;
        if (obj instanceof Scenario && (scenario = (Scenario)obj).isDefault()) {
            assert (this.d_default == null || this.d_default == scenario) : "Trying to add a default scenario when there is already one defined.";
            this.d_default = scenario;
        }
    }

    @Override
    protected void restoreFromLoad(Composite<Scenario> obj) {
        assert (obj instanceof ScenarioRoot);
        if (obj instanceof ScenarioRoot) {
            ScenarioRoot root = (ScenarioRoot)obj;
            this.pauseUpdates();
            this.d_activeScenario = null;
            super.restoreFrom(obj);
            this.d_default = root.d_default;
            this.d_activeScenario = root.d_activeScenario;
            this.changedEvt(ACTIVE_SCENARIO);
            this.resumeUpdates();
        }
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new ScenarioRoot(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Scenario Group");
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.setActive(this.addDefault());
        this.resumeUpdates();
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        deps.add(this, this.d_activeScenario, ACTIVE_SCENARIO_CALLBACK);
    }

    public record ScenarioValue<ValT>(boolean customized, ValT value) {
    }

    private record ScenarioChange(Scenario scenario, IDisplayProp<?> prop, Property<?> val) {
    }

    private record ApplyScenarioOverrides(ICompElement obj, List<ScenarioChange> scenarioChanges) implements Undo.UndoOp
    {
        @Override
        public boolean isMajor() {
            return true;
        }

        @Override
        public Undo.UndoOp perform() {
            List<ScenarioChange> restoreChanges = this.scenarioChanges.stream().map(scenarioChange -> {
                Property<?> restoreVal = scenarioChange.scenario.getObjValue(this.obj, scenarioChange.prop);
                return new ScenarioChange(scenarioChange.scenario, scenarioChange.prop, restoreVal);
            }).toList();
            for (ScenarioChange scenarioChange2 : this.scenarioChanges) {
                if (!scenarioChange2.val.isSupported()) {
                    scenarioChange2.scenario.clearObjValue(this.obj, scenarioChange2.prop);
                    continue;
                }
                scenarioChange2.scenario.setObjValue(this.obj, scenarioChange2.prop, scenarioChange2.val.get());
            }
            return new ApplyScenarioOverrides(this.obj, restoreChanges);
        }
    }
}

