/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Icon;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.ScenarioUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Property;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class Scenario
extends NamedMerlinObj
implements ICompElement,
IRestorable,
ICyclicSurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME = Intl.intl("Default");
    public static final int BAR_HEIGHT = 16;
    public static final int BAR_WIDTH = 4;
    public static final DisplayProp<String> DESCRIPTION = DisplayProps.build((Object)"DESCRIPTION", "", Intl.intl("Description"), "").attrToProp();
    public static final DisplayProp<Color> PROP_COLOR = DisplayProps.build((Object)"Scenario.COLOR", Color.class, Color.ORANGE, Intl.intl("Color"), "").attrToProp();
    public static final DisplayProp<Map<ICompElement, Map<Object, Object>>> OBJ_VALUES = ((DisplayProps.Builder)DisplayProps.buildGeneric("OBJ_VALUES", Map.class, theUtil.emptyMap((ICompElement)null, (Map)null), Intl.intl("Description"), "").attrCloneValue(Scenario::cloneObjValues)).attrToProp();
    private static final PropertyDefs<Scenario> PROPS = new PropertyDefs<Scenario>(Scenario.class, List.of(), NamedMerlinObj.NAME, DESCRIPTION, PROP_COLOR, OBJ_VALUES);
    private boolean d_isDefault = false;
    private String d_description = "";
    private Color d_color = Color.ORANGE;
    @SkipDep
    private Map<ICompElement, Map<Object, Object>> d_objValues = new LinkedIdentityHashMap<ICompElement, Map<Object, Object>>();
    private static final DepCallback<MerlinData, Scenario, Set<ICompElement>, ICompElement> OBJ_VALUES_CALLBACK = new DepCallback<MerlinData, Scenario, Set<ICompElement>, ICompElement>(DLink.WEAK, ICompElement.class, (md, scenario, val) -> val.stream(), (Predicate)null, new DepCallback.IReplaceDep<MerlinData, Scenario, Set<ICompElement>, ICompElement>(){

        @Override
        public Set<ICompElement> get(MerlinData mediator, Scenario src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertUndoEntry(MerlinData mediator, Scenario src, ICompElement ref) {
            Map prevVals = src.d_objValues.getOrDefault(ref, Collections.emptyMap());
            if (prevVals.isEmpty()) {
                assert (false);
                return;
            }
            Runnable undo = () -> {
                src.d_objValues.put(ref, prevVals);
                src.changedEvt(OBJ_VALUES);
            };
            Runnable redo = () -> src.clearObjValues(ref);
            Undo.insertEntry(mediator, new Undo.CustomOp(undo, redo));
        }

        @Override
        public void set(MerlinData mediator, Scenario src, Set<ICompElement> val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ICompElement> replace(MerlinData md, Scenario src, Set<ICompElement> val, ICompElement old, ICompElement replacement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceDependency(MerlinData md, Scenario src, ICompElement old, ICompElement replacement) {
            src.clearObjValues(old);
        }
    });

    protected Scenario() {
        this(DEFAULT_NAME);
        this.d_isDefault = true;
        this.d_color = Color.DARK_GRAY;
    }

    public Scenario(String name) {
        super(name);
        this.d_color = theUtil.newMidrangeColor();
    }

    public Icon newDecaratorIcon() {
        return this.isDefault() ? new ColorIcon(new Color(0, 0, 0, 0), 4, 16, 0) : new ColorIcon(this.getColor(), 4, 16, 0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (!this.isDefault() && this.d_color == null) {
            this.d_color = theUtil.newMidrangeColor();
        }
    }

    private static Object key(IDisplayProp<?> prop) {
        return prop.getKey();
    }

    private static Object key(Object prop) {
        Object object;
        if (prop instanceof IDisplayProp) {
            IDisplayProp dprop = (IDisplayProp)prop;
            object = Scenario.key(dprop);
        } else {
            object = prop;
        }
        return object;
    }

    @Override
    public Scenario clone() {
        Scenario clone = (Scenario)super.clone();
        if (clone.d_isDefault) {
            clone.d_isDefault = false;
            clone.d_objValues = new LinkedIdentityHashMap<ICompElement, Map<Object, Object>>();
        } else {
            clone.d_objValues = Scenario.cloneObjValues(this.d_objValues);
        }
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        Scenario clone = (Scenario)super.clone();
        clone.d_objValues = Scenario.cloneObjValues(this.d_objValues);
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Scenario)) {
            return;
        }
        Scenario scenario = (Scenario)obj;
        this.pauseUpdates();
        this.d_isDefault = scenario.d_isDefault;
        this.setDescription(scenario.d_description);
        this.setColor(scenario.d_color);
        this.setObjValues(scenario.d_objValues);
        this.resumeUpdates();
    }

    private static Map<ICompElement, Map<Object, Object>> cloneObjValues(Map<ICompElement, Map<Object, Object>> values) {
        LinkedIdentityHashMap<ICompElement, Map<Object, Object>> newValues = new LinkedIdentityHashMap<ICompElement, Map<Object, Object>>(values);
        newValues.replaceAll((key, map) -> new LinkedHashMap(map));
        return newValues;
    }

    @Override
    public boolean getScenariosSupported() {
        return false;
    }

    @Override
    public boolean isSetNameSupported() {
        return super.isSetNameSupported() && !this.isDefault();
    }

    protected <T> boolean setObjValue(ICompElement obj, IDisplayProp<T> prop, T value) {
        return this.setObjValueImpl(obj, Scenario.key(prop), value);
    }

    private <T> boolean setObjValueImpl(ICompElement obj, Object key, T value) {
        Map objVals = this.d_objValues.computeIfAbsent(obj, o -> new LinkedHashMap());
        boolean modified = objVals.isEmpty();
        T old = objVals.put(key, value);
        boolean bl = modified = modified || !Objects.equals(old, value);
        if (modified) {
            this.changedEvt(OBJ_VALUES);
        }
        return modified;
    }

    protected <T> boolean clearObjValue(ICompElement obj, IDisplayProp<T> prop) {
        return this.clearObjValues(obj, Collections.singleton(prop));
    }

    protected boolean clearObjValues(ICompElement obj, Set<? extends IDisplayProp<?>> props) {
        if (props.isEmpty()) {
            return false;
        }
        Map<Object, Object> objVals = this.d_objValues.get(obj);
        if (objVals == null) {
            return false;
        }
        if (objVals.keySet().removeAll(theUtil.map(props, Scenario::key))) {
            if (objVals.isEmpty()) {
                this.d_objValues.remove(obj);
            }
            this.changedEvt(OBJ_VALUES);
            return true;
        }
        return false;
    }

    protected boolean clearObjValues(ICompElement obj) {
        if (this.d_objValues.remove(obj) != null) {
            this.changedEvt(OBJ_VALUES);
            return true;
        }
        return false;
    }

    protected <T> boolean isObjValueDefined(ICompElement obj, Object prop) {
        return this.d_objValues.getOrDefault(obj, Collections.emptyMap()).containsKey(Scenario.key(prop));
    }

    public boolean isOverridden(ICompElement obj, Object prop) {
        return this.isObjValueDefined(obj, prop);
    }

    public boolean isOverridden(ICompElement obj) {
        return this.d_objValues.containsKey(obj);
    }

    public <T> Property<T> getObjValue(ICompElement obj, IDisplayProp<T> prop) {
        Map<Object, Object> vals = this.d_objValues.get(obj);
        if (vals == null) {
            return Property.notSupported();
        }
        Object key = Scenario.key(prop);
        if (vals.containsKey(key)) {
            return Property.of(vals.get(key));
        }
        return Property.notSupported();
    }

    protected <T> void clearAllObjValues() {
        boolean modified = !this.d_objValues.isEmpty();
        this.d_objValues.clear();
        if (modified) {
            this.changedEvt(OBJ_VALUES);
        }
    }

    public final boolean isDefault() {
        return this.d_isDefault;
    }

    public PropertyDefs<Scenario> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS.props();
    }

    public void setDescription(String desc) {
        if (this.d_description.equals(desc)) {
            return;
        }
        this.d_description = desc;
        this.changedEvt(DESCRIPTION);
    }

    public String getDescription() {
        return this.d_description;
    }

    public void setColor(Color c) {
        if (this.d_color.equals(c)) {
            return;
        }
        this.d_color = c;
        this.changedEvt(PROP_COLOR);
    }

    public Color getColor() {
        return this.d_color;
    }

    private void setObjValues(Map<ICompElement, Map<Object, Object>> values) {
        if (this.d_objValues.equals(values)) {
            return;
        }
        this.d_objValues = values;
        this.changedEvt(OBJ_VALUES);
    }

    public Set<ICompElement> getCustomizedObjects() {
        return Collections.unmodifiableSet(this.d_objValues.keySet());
    }

    public Stream<? extends IDisplayProp<?>> streamCustomProps(ICompElement obj) {
        Map vals = this.d_objValues.getOrDefault(obj, Collections.emptyMap());
        if (vals.isEmpty()) {
            return Stream.empty();
        }
        return vals.keySet().stream().map(key -> this.getPropForKey(obj, key)).filter(prop -> prop != null);
    }

    private IDisplayProp<?> getPropForKey(ICompElement obj, Object key) {
        Object prop = obj.getAllLocalProperties().getProp(key);
        if (prop == null) {
            return null;
        }
        return ScenarioUtil.asScenarioProp(prop).orElse(null);
    }

    public Stream<Pair<IDisplayProp<?>, Object>> streamCustomVals(ICompElement obj) {
        Map vals = this.d_objValues.getOrDefault(obj, Collections.emptyMap());
        if (vals.isEmpty()) {
            return Stream.empty();
        }
        return vals.entrySet().stream().map(entry -> {
            Object val = entry.getValue();
            IDisplayProp<?> prop = this.getPropForKey(obj, entry.getKey());
            return prop != null ? new Pair(prop, val) : null;
        }).filter(pair -> pair != null);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == DESCRIPTION) {
            this.setDescription((String)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_COLOR) {
            this.setColor((Color)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == DESCRIPTION) {
            return this.getDescription();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_COLOR) {
            return this.getColor();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (!(comparable instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)comparable;
        return this.getSetName().equals(other.getSetName());
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        deps.add(this, this.d_objValues.keySet(), OBJ_VALUES_CALLBACK);
        for (Map.Entry<ICompElement, Map<Object, Object>> entry : this.d_objValues.entrySet()) {
            ICompElement obj = entry.getKey();
            Map<Object, Object> values = entry.getValue();
            PropertyDefs<? extends ICompElement> props = obj.getAllLocalProperties();
            for (Map.Entry<Object, Object> valEntry : values.entrySet()) {
                Object val = valEntry.getValue();
                IDisplayProp<?> prop = this.getPropForKey(obj, valEntry.getKey());
                if (prop == null) continue;
                props.streamDependencies(obj, prop.asProp()).forEach(dep -> this.takeDepSnapshot(deps, obj, prop, (DepCallback)dep, val));
            }
        }
    }

    private <SrcT extends ICompElement, ValT, RefT> void takeDepSnapshot(DepList<MerlinData> deps, SrcT source, IDisplayProp<ValT> prop, DepCallback<MerlinData, SrcT, ValT, RefT> dep, ValT scenarioVal) {
        DepCallback.ReplaceDependencyVal<MerlinData, ICompElement, Object, Object> replace = dep.replDep()::replace;
        DepCallback<MerlinData, ICompElement, Object, Object> wrappedDep = new DepCallback<MerlinData, ICompElement, Object, Object>(dep.link(), dep.refType(), dep.streamRefs(), dep.getReplFilter(), new DepCallback.ReplaceDep<MerlinData, ICompElement, Object, Object>((md, src) -> {
            Property val = this.getObjValue((ICompElement)src, prop);
            assert (val.isSupported());
            return val.orElse(null);
        }, (md, src, ref) -> Undo.insertEntry(md, new ScenarioPropRestore<ICompElement, Object>(this, (ICompElement)src, prop, scenarioVal)), (md, src, newVal) -> this.setObjValue((ICompElement)src, prop, (Object)newVal), replace));
        deps.add(source, scenarioVal, wrappedDep);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private record ScenarioPropRestore<SrcT extends ICompElement, ValT>(Scenario scenario, SrcT src, IDisplayProp<ValT> prop, ValT restoreVal) implements Undo.UndoOp
    {
        @Override
        public boolean isMajor() {
            return true;
        }

        @Override
        public Undo.UndoOp perform() {
            Property<ValT> newRestoreVal = this.scenario.getObjValue((ICompElement)this.src, this.prop);
            assert (newRestoreVal.isSupported());
            this.scenario.setObjValue((ICompElement)this.src, this.prop, this.restoreVal);
            return new ScenarioPropRestore<SrcT, ValT>(this.scenario, this.src, this.prop, newRestoreVal.orElse(this.prop.asProp().defVal));
        }
    }
}

