/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import merlin.data.property.IPropBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;

public class TypedProps {
    public static <T> Builder<T> build(Object key, Class<T> type, T defVal) {
        return (Builder)new Builder<T>().init(key, type, defVal);
    }

    public static <T> Builder<T> build(Object key, Class<T> type) {
        return TypedProps.build(key, type, null);
    }

    public static <T> Builder<T> buildGeneric(Object key, Class type, T defVal) {
        return TypedProps.build(key, type, defVal);
    }

    public static Builder<UnitDouble> build(Object key, UnitDouble defVal) {
        return TypedProps.build(key, UnitDouble.class, defVal);
    }

    public static Builder<Double> build(Object key, double defVal) {
        return TypedProps.build(key, Double.class, defVal);
    }

    public static Builder<Float> build(Object key, float defVal) {
        return TypedProps.build(key, Float.class, Float.valueOf(defVal));
    }

    public static Builder<Integer> build(Object key, int defVal) {
        return TypedProps.build(key, Integer.class, defVal);
    }

    public static Builder<Long> build(Object key, long defVal) {
        return TypedProps.build(key, Long.class, defVal);
    }

    public static Builder<Short> build(Object key, short defVal) {
        return TypedProps.build(key, Short.class, defVal);
    }

    public static Builder<Byte> build(Object key, byte defVal) {
        return TypedProps.build(key, Byte.class, defVal);
    }

    public static Builder<Character> build(Object key, char defVal) {
        return TypedProps.build(key, Character.class, Character.valueOf(defVal));
    }

    public static Builder<Boolean> build(Object key, boolean defVal) {
        return TypedProps.build(key, Boolean.class, defVal);
    }

    public static Builder<String> build(Object key, String defVal) {
        return TypedProps.build(key, String.class, defVal);
    }

    public static class Builder<T>
    extends TBuilder<T, TypedProp<T>, Builder<T>> {
    }

    public static class TBuilder<T, PropT extends TypedProp<T>, BuilderT extends TBuilder<T, PropT, BuilderT>>
    implements IPropBuilder<T, PropT> {
        protected Object key;
        protected Class<T> type;
        protected T defVal;
        protected Set<Object> markers = new HashSet<Object>();

        protected BuilderT init(Object key, Class<T> type, T defVal) {
            this.key = key;
            this.type = type;
            this.defVal = defVal;
            return (BuilderT)this;
        }

        public BuilderT attrMarkers(Object ... markers) {
            return this.attrMarkers(Arrays.asList(markers));
        }

        public BuilderT attrMarkers(Collection<Object> markers) {
            this.markers = new HashSet<Object>(markers);
            return (BuilderT)this;
        }

        public BuilderT attrAddMarkers(Object ... markers) {
            this.markers.addAll(Arrays.asList(markers));
            return (BuilderT)this;
        }

        @Override
        public PropT attrToProp() {
            return (PropT)new TypedProp<T>(this.key, this.type, this.defVal, this.markers);
        }
    }
}

