/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.property.CompositeProp;
import merlin.data.property.CompositeProps;
import merlin.data.property.CompositeValue;
import merlin.data.property.IDisplayProp;
import merlin.data.scenario.ScenarioUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;

public class PropertyDefs<ObjT extends ICompElement> {
    private static final Logger LOGGER = Logger.getLogger(PropertyDefs.class.getSimpleName());
    private final Class<ObjT> d_type;
    private final Collection<? extends PropertyDefs<? extends ICompElement>> d_inheritProps;
    private final SequencedSet<Object> d_allProps = new LinkedHashSet<Object>();
    private final Map<Object, Object> d_keyPropLookup = new HashMap<Object, Object>();
    private final SequencedSet<IDisplayProp<?>> d_allScenarioProps = new LinkedHashSet();
    private final SequencedSet<IDisplayProp<?>> d_displayScenarioProps = new LinkedHashSet();
    private final SequencedSet<IDisplayProp<?>> d_storageScenarioProps = new LinkedHashSet();
    private final Set<Object> d_wrapperProps = new HashSet<Object>();
    private final Set<Object> d_wrappedProps = new HashSet<Object>();
    private final Map<IPropertySet.Prop<?>, List<DepCallback<MerlinData, ? super ObjT, ?, ?>>> d_dependencies = new LinkedHashMap();
    private final Map<IPropertySet.Prop<?>, Function<? super ObjT, ? extends Stream<? extends DepCallback<MerlinData, ? super ObjT, ?, ?>>>> d_dependencyStreams = new LinkedHashMap();

    public PropertyDefs(Class<ObjT> type, PropertyDefs<? super ObjT> props, Object ... allProps) {
        this(type, (Collection<PropertyDefs<ICompElement>>)List.of(props), Stream.of(allProps));
    }

    public PropertyDefs(Class<ObjT> type, Collection<? extends PropertyDefs<? extends ICompElement>> inheritProps, Object ... allProps) {
        this(type, inheritProps, Stream.of(allProps));
    }

    public PropertyDefs(Class<ObjT> type, Collection<? extends PropertyDefs<? extends ICompElement>> inheritProps, Collection<?> props, Object ... additionalProps) {
        this(type, inheritProps, props.stream(), Stream.of(additionalProps));
    }

    public PropertyDefs(Class<ObjT> type, Collection<? extends PropertyDefs<? extends ICompElement>> inheritProps, Stream<?> ... propStreams) {
        this(type, inheritProps, Stream.concat(inheritProps.stream().flatMap(props -> props.stream()), Stream.of(propStreams).reduce(Stream::concat).orElse(Stream.empty())).collect(Collectors.toCollection(() -> new LinkedHashSet())));
    }

    public static <ObjT extends ICompElement> PropertyDefs<ObjT> explicitProps(Class<ObjT> type, Collection<? extends PropertyDefs<? extends ICompElement>> inheritProps, Stream<?> ... propStreams) {
        return new PropertyDefs<ObjT>(type, inheritProps, Stream.of(propStreams).reduce(Stream::concat).orElse(Stream.empty()).collect(Collectors.toCollection(() -> new LinkedHashSet())));
    }

    private PropertyDefs(Class<ObjT> type, Collection<? extends PropertyDefs<? extends ICompElement>> inheritProps, SequencedSet<Object> allProps) {
        this.d_type = type;
        this.d_inheritProps = inheritProps;
        allProps.forEach(this::add);
    }

    public <PropT> PropT add(PropT newProp) {
        return this.add(newProp, true);
    }

    public <PropT> PropT add(PropT newProp, boolean allowScenario) {
        IPropertySet.Prop pprop;
        assert (!new TypeFilter<PropT>(Stream.class, Collection.class, PropertyDefs.class).test(newProp)) : String.format("%s<%s>: Unexpected property type %s.", PropertyDefs.class.getSimpleName(), this.d_type.getSimpleName(), PropertyDefs.formatProp(newProp));
        if (!this.d_allProps.add(newProp)) {
            return newProp;
        }
        if (allowScenario) {
            ScenarioUtil.asScenarioProp(newProp).ifPresent(p -> {
                assert (p.getKey() instanceof Serializable) : String.format("%s<%s>: All scenario properties must have serializable keys. Property=%s, Type=%s", PropertyDefs.class.getSimpleName(), this.d_type.getSimpleName(), p.getDisplayName(), p.getKey().getClass().getSimpleName());
                this.d_allScenarioProps.add((IDisplayProp<?>)p);
                this.d_displayScenarioProps.add((IDisplayProp<?>)p);
                this.d_storageScenarioProps.add((IDisplayProp<?>)p);
            });
        }
        BiConsumer<Object, Object> mapProp = (key, prop) -> {
            Object existing = this.d_keyPropLookup.put(key, prop);
            assert (existing == null) : String.format("%s<%s>: Multiple properties assigned to the same key: %s.", PropertyDefs.class.getSimpleName(), this.d_type.getSimpleName(), key.toString());
        };
        if (newProp instanceof IPropertySet.Prop) {
            pprop = (IPropertySet.Prop)newProp;
            mapProp.accept(pprop.key, pprop);
        } else {
            mapProp.accept(newProp, newProp);
        }
        if (newProp instanceof IPropertySet.Prop) {
            Optional<Function> optStreamDeps;
            pprop = (IPropertySet.Prop)newProp;
            Optional<Collection> deps = this.d_inheritProps.stream().map(inherit -> inherit.getDependencies(pprop)).filter(dependencies -> !dependencies.isEmpty()).findFirst();
            if (deps.isPresent()) {
                deps.get().forEach(dep -> this.registerDependency(pprop, (DepCallback)dep));
            }
            if ((optStreamDeps = this.d_inheritProps.stream().map(inherit -> inherit.getDependencyStream(pprop)).filter(getStream -> getStream != null).findFirst()).isPresent()) {
                this.registerDependencyStream(pprop, optStreamDeps.get());
            }
        }
        if (newProp instanceof CompositeProp || this.d_inheritProps.stream().anyMatch(inherit -> inherit.isWrapperProp(newProp))) {
            this.markWrapperProps(newProp);
        }
        if (newProp instanceof CompositeProp) {
            CompositeProp cprop = (CompositeProp)newProp;
            assert (IRestorable.class.isAssignableFrom(this.d_type)) : String.format("%s must implement %s in order to restore composite properties.", this.d_type.getName(), IRestorable.class.getSimpleName());
            cprop.props.forEach(childProp -> this.markWrappedProp(cprop, (IDisplayProp<?>)childProp));
            this.d_storageScenarioProps.remove(cprop);
        }
        return newProp;
    }

    private void markWrappedProp(CompositeProp wrapper, IDisplayProp<?> prop) {
        assert (this.d_allProps.contains(prop)) : String.format("%s: Wrapped property must be added before registering the composite wrapper. Composite property=%s, Wrapped property=%s", this, PropertyDefs.formatProp(wrapper), PropertyDefs.formatProp(prop));
        assert (!wrapper.testMarker(MerlinData.SCENARIO_MARKER) || prop.testMarker(MerlinData.SCENARIO_MARKER)) : String.format("%s: If composite properties are marked for scenarios, their wrapped properties must be as well: Composite property=%s, Wrapped property=%s", this, PropertyDefs.formatProp(wrapper), PropertyDefs.formatProp(prop));
        this.d_wrappedProps.add(prop);
        this.d_displayScenarioProps.remove(prop);
        if (prop instanceof CompositeProp) {
            CompositeProp cprop = (CompositeProp)prop;
            cprop.props.forEach(childProp -> this.markWrappedProp(cprop, (IDisplayProp<?>)childProp));
        }
    }

    public String toString() {
        return String.format("%s<%s>", PropertyDefs.class.getSimpleName(), this.d_type.getSimpleName());
    }

    private static String formatProp(Object prop) {
        String string;
        if (prop instanceof IPropertySet.Prop) {
            IPropertySet.Prop p = (IPropertySet.Prop)prop;
            string = MerlinUtil.format(p);
        } else {
            string = prop.toString();
        }
        return string;
    }

    public Class<ObjT> getObjType() {
        return this.d_type;
    }

    public boolean markWrapperProps(Object ... props) {
        boolean allAdded = true;
        for (Object prop : props) {
            if (!this.d_allProps.contains(prop)) {
                allAdded = false;
                continue;
            }
            assert (IRestorable.class.isAssignableFrom(this.d_type)) : String.format("%s must implement %s in order to restore wrapper properties.", this.d_type.getName(), IRestorable.class.getSimpleName());
            this.d_wrapperProps.add(prop);
        }
        return allAdded;
    }

    public boolean isWrapperProp(Object prop) {
        return this.d_wrapperProps.contains(prop);
    }

    public boolean isWrappedProp(Object prop) {
        return this.d_wrappedProps.contains(prop);
    }

    public SequencedSet<Object> props() {
        return Collections.unmodifiableSequencedSet(this.d_allProps);
    }

    public Stream<Object> stream() {
        return this.d_allProps.stream();
    }

    public SequencedSet<IDisplayProp<?>> getScenarioProps(ScenarioProps filter) {
        return Collections.unmodifiableSequencedSet(switch (filter.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.d_allScenarioProps;
            case 2 -> this.d_storageScenarioProps;
            case 1 -> this.d_displayScenarioProps;
        });
    }

    public Object getProp(Object key) {
        assert (this.d_keyPropLookup.containsKey(key)) : String.format("%s: Trying to retrieve properties associated with an unknown property key: %s. Not fixing this may lead to unknown errors in the data model.", this, key);
        return this.d_keyPropLookup.get(key);
    }

    public boolean contains(Object prop) {
        return this.d_allProps.contains(prop);
    }

    public CompositeProp registerCompositeScenarioProperty(IDisplayProp<?> ... props) {
        return (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(props).attrMarkScenarioSupported()).attrStoreIn(this);
    }

    public <T, RefT> void registerDependency(IPropertySet.Prop<T> prop, DepCallback<MerlinData, ? super ObjT, T, RefT> dep) {
        assert (this.d_allProps.contains(prop)) : String.format("%s: Dependencies can only be registered for supported properties. Property=%s", this, PropertyDefs.formatProp(prop));
        this.d_dependencies.computeIfAbsent(prop, p -> new ArrayList()).add(dep);
    }

    public <T, RefT> void registerDependencyStream(IPropertySet.Prop<T> prop, Function<? super ObjT, ? extends Stream<? extends DepCallback<MerlinData, ? super ObjT, T, RefT>>> streamDeps) {
        assert (this.d_allProps.contains(prop)) : String.format("%s: Dependencies can only be registered for supported properties. Property=%s", this, PropertyDefs.formatProp(prop));
        this.d_dependencyStreams.put(prop, streamDeps);
    }

    public <T> Stream<? extends DepCallback<MerlinData, ? super ObjT, T, ?>> streamDependencies(ObjT obj, IPropertySet.Prop<T> prop) {
        return this.d_dependencyStreams.getOrDefault(prop, o -> this.d_dependencies.getOrDefault(prop, List.of()).stream()).apply((ICompElement)obj);
    }

    protected <T> Collection<DepCallback<MerlinData, ? super ObjT, T, ?>> getDependencies(IPropertySet.Prop<T> prop) {
        return this.d_dependencies.getOrDefault(prop, List.of());
    }

    protected <T> Function<? super ObjT, ? extends Stream<? extends DepCallback<MerlinData, ? super ObjT, T, ?>>> getDependencyStream(IPropertySet.Prop<T> prop) {
        return this.d_dependencyStreams.get(prop);
    }

    public void takeDepSnapshot(ObjT obj, DepList<MerlinData> deps) {
        Optional<Nullable<?>> val;
        for (Map.Entry<IPropertySet.Prop<?>, List<DepCallback<MerlinData, ObjT, ?, ?>>> entry : this.d_dependencies.entrySet()) {
            if (this.d_dependencyStreams.containsKey(entry.getKey()) || !(val = obj.getNullableProp(entry.getKey())).isPresent()) continue;
            for (DepCallback<MerlinData, ? super ObjT, ?, ?> dep2 : entry.getValue()) {
                deps.add(obj, val.get().val, dep2);
            }
        }
        for (Map.Entry<IPropertySet.Prop<?>, Object> entry : this.d_dependencyStreams.entrySet()) {
            val = obj.getNullableProp(entry.getKey());
            if (!val.isPresent()) continue;
            ((Stream)((Function)entry.getValue()).apply(obj)).forEach(dep -> deps.add(obj, ((Nullable)val.get()).val, dep));
        }
    }

    public CompositeValue getCompositeValue(ObjT src, CompositeProp prop) {
        PropertySet props = new PropertySet();
        for (IDisplayProp<?> wrapped : prop.props) {
            Object wrappedVal = src.getSupportedValue(wrapped.asProp());
            props.set(wrapped.asProp(), wrappedVal);
        }
        return new CompositeValue(props);
    }

    public void setCompositeValue(ObjT src, CompositeProp prop, CompositeValue val) {
        src.pauseUpdates();
        for (IDisplayProp<?> wrapped : prop.props) {
            src.setProp(wrapped.asProp(), val.vals().get(wrapped.asProp()));
        }
        src.resumeUpdates();
    }

    public static enum ScenarioProps {
        ALL,
        DISPLAY,
        STORAGE;

    }
}

