/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.Optional;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.IPropertySet;

public interface IDisplayProp<T> {
    default public Object getKey() {
        return this.asProp().key;
    }

    default public T getDefaultVal() {
        return this.asProp().defVal;
    }

    public String getGroupDisplayName();

    public String getDisplayName();

    default public String getNameWithColon() {
        return String.format(Intl.intl("%s:"), this.getDisplayName());
    }

    public String getDisplayDesc();

    public ValEditorSupplier<T> getValEditorSupplier();

    default public Optional<IValEditor<T>> newValueEditor(MerlinData md, boolean inline) {
        ValEditorSupplier<T> supplier = this.getValEditorSupplier();
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.of(supplier.get(md, inline));
    }

    public String formatValue(ICompElement var1, T var2);

    public T cloneValue(T var1);

    public IPropertySet.Prop<T> asProp();

    public boolean testMarker(Object var1);

    public Stream<?> streamMarkers();

    default public String getHtmlDescr() {
        return guiUtil.encodeToHtmlLabel(this.getDisplayDesc());
    }

    public static interface ValEditorSupplier<T> {
        public IValEditor<T> get(MerlinData var1, boolean var2);
    }
}

