/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.property.DisplayProp;
import merlin.data.property.IDisplayProp;
import merlin.data.property.IFormatValue;
import merlin.data.property.TypedProps;
import merlin.unitsystem.MerlinUnitType;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.StringFormat;
import thunderheadeng.gui.value.ValueFieldEditor;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class DisplayProps {
    public static <T> Builder<T> build(Object key, Class<T> type, T defVal, String name, String desc) {
        return (Builder)new Builder<T>().init(key, type, defVal, name, desc);
    }

    public static <T> Builder<T> buildGeneric(Object key, Class type, T defVal, String name, String desc) {
        return DisplayProps.build(key, type, defVal, name, desc);
    }

    public static Builder<Double> build(Object key, double defVal, String name, String desc) {
        return DisplayProps.build(key, Double.class, defVal, name, desc);
    }

    public static Builder<Float> build(Object key, float defVal, String name, String desc) {
        return DisplayProps.build(key, Float.class, Float.valueOf(defVal), name, desc);
    }

    public static Builder<Integer> build(Object key, int defVal, String name, String desc) {
        return DisplayProps.build(key, Integer.class, defVal, name, desc);
    }

    public static Builder<Long> build(Object key, long defVal, String name, String desc) {
        return DisplayProps.build(key, Long.class, defVal, name, desc);
    }

    public static Builder<Short> build(Object key, short defVal, String name, String desc) {
        return DisplayProps.build(key, Short.class, defVal, name, desc);
    }

    public static Builder<Byte> build(Object key, byte defVal, String name, String desc) {
        return DisplayProps.build(key, Byte.class, defVal, name, desc);
    }

    public static Builder<Character> build(Object key, char defVal, String name, String desc) {
        return DisplayProps.build(key, Character.class, Character.valueOf(defVal), name, desc);
    }

    public static Builder<Boolean> build(Object key, boolean defVal, String name, String desc) {
        return DisplayProps.build(key, Boolean.class, defVal, name, desc);
    }

    public static Builder<String> build(Object key, String defVal, String name, String desc) {
        return (Builder)DisplayProps.build(key, String.class, defVal, name, desc).attrValEditor((md, inline) -> new ValueFieldEditor<String>(String.class, new ValueField<String>(new StringFormat(), defVal)));
    }

    public static Builder<UnitDouble> build(Object key, UnitDouble defVal, String name, String desc, IUnitSrc usrc) {
        return DisplayProps.defaults(DisplayProps.build(key, UnitDouble.class, defVal, name, desc), usrc);
    }

    public static Builder<UnitDouble> build(Object key, UnitDouble defVal, String name, String desc, int unitType) {
        return DisplayProps.build(key, defVal, name, desc, new MerlinUnitType(unitType));
    }

    public static <PropT extends DisplayProp<UnitDouble>, BuilderT extends TBuilder<UnitDouble, PropT, BuilderT>> BuilderT defaults(BuilderT udBuilder, IUnitSrc usrc) {
        return udBuilder.attrFormatValue((obj, ud) -> Global.format(ud, usrc.getUnit()));
    }

    public static <T> Set<T> emptySet(T unused) {
        return Collections.emptySet();
    }

    public static <T> Set<T> emptySet(Class<T> unused) {
        return Collections.emptySet();
    }

    public static <K, V> Map<K, V> emptyMap(K unusedKey, V unusedVal) {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> emptyMap(Class<K> unusedKeyType, Class<V> unusedValType) {
        return Collections.emptyMap();
    }

    public static <T> List<T> emptyList(T unused) {
        return Collections.emptyList();
    }

    public static <T> List<T> emptyList(Class<T> unused) {
        return Collections.emptyList();
    }

    public static class Builder<T>
    extends TBuilder<T, DisplayProp<T>, Builder<T>> {
    }

    public static class TBuilder<T, PropT extends DisplayProp<T>, BuilderT extends TBuilder<T, PropT, BuilderT>>
    extends TypedProps.TBuilder<T, PropT, TBuilder<T, PropT, BuilderT>> {
        protected String groupName;
        protected String name;
        protected String desc;
        protected IDisplayProp.ValEditorSupplier<T> valEditorSupplier;
        protected IFormatValue<ICompElement, T> formatValue = IFormatValue.getDefaultFormatVal();
        protected UnaryOperator<T> cloneValue = v -> v;

        protected BuilderT init(Object key, Class<T> type, T defVal, String name, String desc) {
            super.init(key, type, defVal);
            this.name = name;
            this.desc = desc;
            return (BuilderT)this;
        }

        public BuilderT attrGroupName(String name) {
            this.groupName = name;
            return (BuilderT)this;
        }

        public BuilderT attrFormatValue(Function<T, String> format) {
            return this.attrFormatValue((ICompElement obj, T v) -> (String)format.apply(v));
        }

        public BuilderT attrFormatValue(IFormatValue<ICompElement, T> format) {
            this.formatValue = format;
            return (BuilderT)this;
        }

        public BuilderT attrValEditor(IDisplayProp.ValEditorSupplier<T> valEditor) {
            this.valEditorSupplier = valEditor;
            return (BuilderT)this;
        }

        public BuilderT attrCloneValue(UnaryOperator<T> cloneValue) {
            this.cloneValue = cloneValue;
            return (BuilderT)this;
        }

        public BuilderT attrMarkScenarioSupported() {
            return (BuilderT)((TBuilder)this.attrAddMarkers(MerlinData.SCENARIO_MARKER));
        }

        public BuilderT attrMarkScenarioSupported(boolean supported) {
            if (supported) {
                return this.attrMarkScenarioSupported();
            }
            return (BuilderT)this;
        }

        @Override
        public PropT attrToProp() {
            return (PropT)new DisplayProp<Object>(this.key, this.groupName, this.name, this.desc, this.type, this.defVal, this.valEditorSupplier, this.cloneValue, this.formatValue, this.markers);
        }
    }
}

