/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.property.IDisplayProp;
import merlin.data.property.IFormatValue;
import thunderheadeng.gui.Application;
import thunderheadeng.util.TypedProp;

public class DisplayProp<T>
extends TypedProp<T>
implements IDisplayProp<T> {
    private static final Logger LOGGER = Logger.getLogger(DisplayProp.class.getSimpleName());
    public final String groupName;
    public final String name;
    public final String desc;
    public final IDisplayProp.ValEditorSupplier<T> valEditorSupplier;
    public final IFormatValue<ICompElement, T> formatValue;
    public final UnaryOperator<T> cloneValue;
    private static final Map<String, Object> s_scenarioPropNames = new HashMap<String, Object>();

    public DisplayProp(Object key, String groupName, String name, String desc, Class<T> type, T defVal, IDisplayProp.ValEditorSupplier<T> valEditorSupplier, UnaryOperator<T> cloneValue, IFormatValue<ICompElement, T> formatValue, Set<Object> markers) {
        super(key, type, defVal, markers);
        Object prevKey;
        this.groupName = groupName;
        this.name = name;
        this.desc = desc;
        this.valEditorSupplier = valEditorSupplier;
        this.cloneValue = cloneValue;
        this.formatValue = formatValue;
        if (markers.contains(MerlinData.SCENARIO_MARKER) && Application.isDev() && (prevKey = s_scenarioPropNames.put(name, key)) != null) {
            LOGGER.log(Level.WARNING, String.format("Property name %1$s is associated with both %2$s and %3$s.", name, prevKey, key));
        }
    }

    @Override
    public String formatValue(ICompElement src, T value) {
        return this.formatValue.format(src, value);
    }

    @Override
    public T cloneValue(T value) {
        return (T)this.cloneValue.apply(value);
    }

    @Override
    public String getGroupDisplayName() {
        return this.groupName;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getDisplayDesc() {
        return this.desc;
    }

    @Override
    public IDisplayProp.ValEditorSupplier<T> getValEditorSupplier() {
        return this.valEditorSupplier;
    }

    @Override
    public DisplayProp<T> asProp() {
        return this;
    }

    @Override
    public Stream<?> streamMarkers() {
        return this.markers.stream();
    }
}

