/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.montecarlo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.montecarlo.VariationOccFilter;
import merlin.data.montecarlo.VariationPositionDistribution;
import merlin.data.montecarlo.VariationProfileRule;
import merlin.data.montecarlo.VariationRoomRule;
import merlin.data.property.CompositeProp;
import merlin.data.property.CompositeProps;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;

public class MonteCarlo
extends AMerlinObj
implements Serializable,
ICompElement,
IRestorable,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<MonteCarlo> PROPS = new PropertyDefs<MonteCarlo>(MonteCarlo.class, (Collection<PropertyDefs<ICompElement>>)Collections.emptyList(), new Stream[0]);
    public static final DisplayProp<Integer> VARIATION_COUNT = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.VARIATION_COUNT", 1, Intl.intl("Variation Count"), Intl.intl("The number of variations to generate.\nIf this is 1, no randomization will be performed.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
    public static final DisplayProp<Boolean> RANDOMIZE_POSITIONS = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_POSITIONS", true, Intl.intl("Randomize Positions"), Intl.intl("Whether to randomize occupant positions by default.\nThis may be overridden by Occupant Filters.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
    public static final DisplayProp<Boolean> RANDOMIZE_PROPERTIES = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_PROPERTIES", true, Intl.intl("Randomize Profile Properties"), Intl.intl("Whether to randomize occupant properties by default.\nThis may be overridden by Occupant Filters.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
    public static final DisplayProp<Boolean> RANDOMIZE_PROFILES = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_PROFILES", true, Intl.intl("Randomize Profiles"), Intl.intl("Whether to randomize occupant profiles by default.\nThis may be overridden by Occupant Filters.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
    public static final DisplayProp<VariationProfileRule> PROFILE_RULE = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.PROFILE_RULE", VariationProfileRule.class, VariationProfileRule.SHUFFLE_EXISTING, Intl.intl("Profile Rule"), "").attrMarkScenarioSupported()).attrFormatValue(VariationProfileRule::getName)).attrToProp();
    public static final DisplayProp<IUrn<OccProfile>> PROFILE_DIST = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("MonteCarlo.PROFILE_DIST", IUrn.class, null, Intl.intl("Profile Distribution"), Intl.intl("The distribution of profiles for occupants whose profiles are randomized.")).attrMarkScenarioSupported()).attrFormatValue(dist -> dist.format2(OccProfile::getName))).attrToProp();
    public static final CompositeProp TARGET_PROFILES = ((CompositeProps.CompositePropBuilder)CompositeProps.build(Intl.intl("Target Profiles"), "", PROFILE_RULE, PROFILE_DIST).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<List<VariationOccFilter>> OCC_FILTERS = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("MonteCarlo.OCC_FILTERS", List.class, DisplayProps.emptyList(VariationOccFilter.class), Intl.intl("Occupant Filters"), Intl.intl("Filters that can be used to disable or enable randomization for specific groups of occupants.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.isEmpty() ? Intl.intl("None") : v.stream().map(Record::toString).collect(Collectors.joining("; ")))).attrStoreIn(PROPS);
    public static final DisplayProp<VariationRoomRule> ROOM_RULE = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.ROOM_RULE", VariationRoomRule.class, VariationRoomRule.SAME, Intl.intl("Room Rule"), Intl.intl("Specifies which rooms occupants may be repositioned to.")).attrMarkScenarioSupported()).attrFormatValue(VariationRoomRule::getName)).attrStoreIn(PROPS);
    public static final DisplayProp<VariationPositionDistribution> POSITION_DISTRIBUTION = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.POSITION_DISTRIBUTION", VariationPositionDistribution.class, VariationPositionDistribution.RANDOM, Intl.intl("Position Distribution"), Intl.intl("Specifies how occupant positions are chosen.")).attrMarkScenarioSupported()).attrFormatValue(VariationPositionDistribution::getName)).attrStoreIn(PROPS);
    public static final DisplayProp<Long> RANDOMIZATION_SEED = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZATION_SEED", 0L, Intl.intl("Randomization Seed"), Intl.intl("Initial seed for randomization.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
    private PropertySet d_props = new PropertySet();

    public MonteCarlo(OccProfile noChangeProfile) {
        this.set(PROFILE_DIST, new InfiniteUrn<OccProfile>(noChangeProfile));
    }

    @Override
    public PropertyDefs<? extends ICompElement> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS.props();
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            IPropertySet.Prop supportedProp = (IPropertySet.Prop)property;
            return this.get(supportedProp);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            IPropertySet.Prop supportedProp = (IPropertySet.Prop)property;
            this.set(supportedProp, value);
        }
    }

    @Override
    public String getName() {
        return Intl.intl("Monte Carlo");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    @Override
    public MonteCarlo clone() {
        MonteCarlo clone = (MonteCarlo)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj instanceof MonteCarlo) {
            MonteCarlo oldMonteCarlo = (MonteCarlo)obj;
            this.pauseUpdates();
            this.d_props = oldMonteCarlo.d_props;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROPS.takeDepSnapshot(this, deps);
    }

    public void reset(OccProfile noChangeProfile) {
        this.restoreFrom(new MonteCarlo(noChangeProfile));
    }

    static {
        PROPS.add(PROFILE_RULE);
        PROPS.add(PROFILE_DIST);
        PROPS.add(TARGET_PROFILES);
        PROPS.registerDependency(PROFILE_DIST, Dependencies.newDependency(PROFILE_DIST, DLink.WEAK, OccProfile.class, (md, src, urn) -> urn.stream(), Predicates.alwaysTrue(), (md, src, urn, old, repl) -> {
            if (repl == null) {
                repl = md.profiles.NO_CHANGE;
            }
            return Dependencies.replaceUrnValue(urn, old, repl);
        }));
        PROPS.registerDependency(OCC_FILTERS, Dependencies.newDependency(OCC_FILTERS, DLink.WEAK, EgressAgentComp.class, (md, src, filters) -> filters.stream().flatMap(f -> Set.of(f.group()).stream()), Predicates.alwaysTrue(), (md, src, filters, old, repl) -> {
            ArrayList<VariationOccFilter> filterData = new ArrayList<VariationOccFilter>((Collection<VariationOccFilter>)filters);
            ArrayList<VariationOccFilter> toRemove = new ArrayList<VariationOccFilter>();
            for (int i = 0; i < filterData.size(); ++i) {
                if (((VariationOccFilter)filterData.get(i)).group() != old) continue;
                if (repl == null) {
                    toRemove.add((VariationOccFilter)filterData.get(i));
                    continue;
                }
                filterData.set(i, new VariationOccFilter((EgressAgentComp)repl, ((VariationOccFilter)filterData.get(i)).randomizePositions(), ((VariationOccFilter)filterData.get(i)).randomizeProperties(), ((VariationOccFilter)filterData.get(i)).randomizeProfiles()));
            }
            filterData.removeAll(toRemove);
            return filterData;
        }));
    }
}

