/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.Opacity;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.mv.displays.MerlinDispProps;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.util.Events;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class QueueObject
extends GeomComposite<IQueueElement>
implements IGotoQueueDestination,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    private Set<Tag> d_tags;
    private Color d_color = theUtil.newRandomLightColor();
    private float d_transparency = 0.0f;
    @SkipDep
    private Object d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
    public static final DisplayProp<ObjsFilter<OccProfile>> RESTRICTED_PROFILES = ((DisplayProps.Builder)DisplayProps.buildGeneric("QueuePath.RESTRICTED_PROFILES", ObjsFilter.class, new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet()), Intl.intl("Accepted Profiles"), "").attrMarkScenarioSupported()).attrToProp();
    public static final PropertyDefs<QueueObject> PROP_TYPES = new PropertyDefs<QueueObject>(QueueObject.class, List.of(), NAME, MerlinData.COLOR, MerlinData.OPACITY, MerlinData.VISIBILITY, RESTRICTED_PROFILES, MerlinData.TAGS);
    private static final Predicate<ICompElement> s_filter;

    public QueueObject(String name) {
        super(name);
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_restrictedProfiles == null) {
            this.d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueObject qo = (QueueObject)obj;
        return Objects.equals(this.getName(), qo.getName()) && Objects.equals(this.d_color, qo.d_color) && this.d_transparency == qo.d_transparency && theUtil.equal(this.d_restrictedProfiles, qo.d_restrictedProfiles, comparedSet) && theUtil.surrogateSetsEqual(this.getMembers(), qo.getMembers(), comparedSet) && theUtil.surrogateSetsEqual(this.getTags(), qo.getTags(), comparedSet);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.changedEvt(new Object[0]);
    }

    public void setColor(Color c) {
        if (!Objects.equals(this.d_color, c)) {
            this.d_color = c;
            for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
                elem.changedEvt(MerlinData.COLOR);
            }
            this.changedEvt(MerlinData.COLOR);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
            elem.changedEvt(MerlinData.OPACITY);
        }
        this.changedEvt(MerlinData.OPACITY);
    }

    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    public Color getDisplayColor() {
        return MerlinDispProps.applyAlpha(this.getColor(), this.getOpacity());
    }

    public void setRestrictedProfiles(ObjsFilter<OccProfile> profs) {
        if (Objects.equals(this.d_restrictedProfiles, profs)) {
            return;
        }
        this.d_restrictedProfiles = profs;
        this.changedEvt(RESTRICTED_PROFILES);
    }

    public ObjsFilter<OccProfile> getRestrictedProfiles() {
        return (ObjsFilter)this.d_restrictedProfiles;
    }

    @Deprecated
    public Set<OccProfile> getLegacyRestrictedProfiles() {
        return (Set)this.d_restrictedProfiles;
    }

    public List<String> getRestrictedProfiles_Strings() {
        return QueueObject.getRestrictedProfiles_Strings((MerlinData)this.getDomain(), this.getRestrictedProfiles());
    }

    protected static List<String> getRestrictedProfiles_Strings(MerlinData md, ObjsFilter<OccProfile> filterProfs) {
        Set<OccProfile> rejectedProfs;
        Set modelProfs;
        ArrayList<String> profs = new ArrayList<String>();
        Collection<Object> collection = modelProfs = md != null ? md.profiles.flatten(OccProfile.class) : Collections.emptySet();
        if (filterProfs.mode == ObjsFilter.Mode.ALL) {
            rejectedProfs = Collections.emptySet();
        } else if (filterProfs.mode == ObjsFilter.Mode.NONE) {
            rejectedProfs = modelProfs;
        } else if (filterProfs.rejected) {
            rejectedProfs = filterProfs.objects;
        } else {
            rejectedProfs = new LinkedHashSet(modelProfs);
            rejectedProfs.removeAll(filterProfs.objects);
        }
        for (OccProfile prof : rejectedProfs) {
            profs.add(prof.getName());
        }
        return profs;
    }

    public Set<Tag> getTags() {
        return this.d_tags;
    }

    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public PropertyDefs<QueueObject> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.setProperty((Object)prop, value);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.COLOR) {
            this.setColor((Color)value);
        } else if (property == MerlinData.OPACITY) {
            this.setOpacity(((IOpacity)value).getValue());
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == RESTRICTED_PROFILES) {
            this.setRestrictedProfiles((ObjsFilter)value);
        } else if (property == MerlinData.TAGS) {
            this.setTags((Set)value);
        } else assert (false) : "Unsupported Operation: <EgressAgent>.setProperty(" + String.valueOf(property) + ")";
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.COLOR) {
            return this.getColor();
        }
        if (property == MerlinData.OPACITY) {
            return new Opacity(this.getOpacity());
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == RESTRICTED_PROFILES) {
            return this.getRestrictedProfiles();
        }
        if (property == MerlinData.TAGS) {
            return this.getTags();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueueObject)) {
            return;
        }
        QueueObject qo = (QueueObject)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.setVisible(qo.isVisible());
        this.setOpacity(qo.getOpacity());
        this.setColor(qo.getColor());
        this.setRestrictedProfiles(qo.getRestrictedProfiles());
        this.setTags(qo.getTags());
        this.resumeUpdates();
    }

    @Override
    public void add(ICompElement obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends ICompElement> objs) {
        super.addAll(theUtil.filter(objs, IQueueElement.class));
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    public static boolean testValidateDirty(Events events) {
        return EntryPointFactory.isModified(events, QueuePath.class) || EntryPointFactory.isModified(events, OccProfile.class);
    }

    public void validate(MerlinData md, SimError.Level errLevel, Consumer<? super SimError> errors) {
        QueueObject qo = this;
        if (qo.flatten(QueueService.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Service."), Intl.intl("Delete or add a Service."), this));
        }
        if (qo.flatten(QueuePath.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Path."), Intl.intl("Delete or add a Path."), qo));
        } else {
            ObjsFilter<OccProfile> qFilter = qo.getRestrictedProfiles();
            block0: for (QueuePath qp : qo.flatten(QueuePath.class)) {
                for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
                    ObjsFilter<OccProfile> pathFilter = qp.getRestrictedProfiles();
                    if (!qFilter.test(prof) || pathFilter.test(prof)) continue;
                    errors.accept(new SimError(errLevel, Intl.intl("A Queue allows a profile that its Path(s) cannot accept."), Intl.intl("Change the Accepted Profiles in the Queue or Path"), qo));
                    break block0;
                }
            }
        }
    }

    static {
        PROP_TYPES.registerDependency(RESTRICTED_PROFILES, ObjsFilter.newDepCallback(RESTRICTED_PROFILES, OccProfile.class));
        TagsUtil.registerTagsDependency(PROP_TYPES);
        s_filter = new TypeFilter<ICompElement>(QueuePath.class, QueueService.class);
    }
}

