/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.attractors;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.RoomLocationGeometry;
import merlin.data.egress.scripting.attractors.IAttractorTime;
import merlin.data.property.CompositeProp;
import merlin.data.property.CompositeProps;
import merlin.data.property.CompositeValue;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.property.TypedProps;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.data.value.ConstVariant;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.MerlinValueFields;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.value.UDValEditor;
import thunderheadeng.gui.value.ValueFieldEditor;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class Attractor
extends NamedMerlinObj
implements IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final Behavior WAIT_AT_ATTRACTOR_BEHAVIOR = new Behavior(Intl.intl("<Wait at Trigger>")){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return WAIT_AT_ATTRACTOR_BEHAVIOR;
        }

        @Override
        public boolean isPlaceholder() {
            return true;
        }
    };
    public static final PropertyDefs<Attractor> PROPS = new PropertyDefs<Attractor>(Attractor.class, (Collection<PropertyDefs<ICompElement>>)List.of(), new Stream[0]);
    public static final TypedProp<PlaceType> TYPE;
    public static final DisplayProp<Integer> RANK;
    public static final DisplayProp<Boolean> REQUIRES_COMPLETION;
    public static final DisplayProp<Awareness> AWARENESS;
    public static final DisplayProp<Boolean> REMEMBER_OUTSIDE_AWARENESS;
    public static final TopologyProp<Point3d> LOCATION;
    public static final TypedProp<Vector3d> ROOM_NORMAL;
    public static final DisplayProp<UnitDouble> INFLUENCE_RADIUS;
    @Deprecated
    private static final IPropertySet.Prop<UnitDouble> INFLUENCE;
    public static final DisplayProp<IVariant<UnitDouble>> ATTR_INFLUENCE;
    public static final DisplayProp<InfluenceFrom> ATTR_INFLUENCE_FROM;
    public static final DisplayProp<Behavior> BEHAVIOR;
    public static final DisplayProp<IDistributedVal<UnitDouble>> WAIT_TIME;
    public static final DisplayProp<UnitDouble> WAIT_RADIUS;
    public static final DisplayProp<Set<IEgressOccupiable>> ROOMS;
    public static final DisplayProp<IAttractorTime> OCC_REACT_TIME;
    public static final DisplayProp<Boolean> IGNORE_OCC_SUSC;
    public static final DisplayProp<ObjsFilter<Tag>> OCC_TAG_FILTER;
    public static final DisplayProp<Integer> AWARENESS_COUNT;
    public static final DisplayProp<UnitDouble> AWARENESS_TIME;
    public static final CompositeProp AWARENESS_CRITERIA;
    @SkipDep
    private transient IEgressOccupiable d_room;
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private static final Color BASE_COLOR;
    private static final DepCallback<MerlinData, Attractor, IEgressOccupiable, IEgressOccupiable> ROOM_CALLBACK;

    private static String formatAwarenessCriteria(CompositeValue val) {
        return String.format("Count &ge; %d, Time &ge; %s", val.vals().get(AWARENESS_COUNT), Global.format(val.vals().get(AWARENESS_TIME), 1));
    }

    public Attractor(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        if (this.d_props.isDefined(INFLUENCE)) {
            UnitDouble influence = this.d_props.get(INFLUENCE);
            this.d_props.setIfNotDefault(ATTR_INFLUENCE, new ConstVariant<UnitDouble>(influence));
            this.d_props.remove(INFLUENCE);
        }
    }

    @Override
    public Attractor clone() {
        Attractor clone = (Attractor)super.clone();
        clone.d_props = this.d_props.clone();
        clone.d_room = null;
        return clone;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        Attractor attr = (Attractor)comparable;
        if (!theUtil.surrogateSetsEqual((Collection)this.get(ROOMS), (Collection)attr.get(ROOMS), comparedSet)) {
            return false;
        }
        if (!theUtil.surrogateSetsEqual((Collection)this.get(MerlinData.TAGS), (Collection)attr.get(MerlinData.TAGS), comparedSet)) {
            return false;
        }
        Predicate<Object> compareFilter = new TypeFilter(CompositeProp.class).negate().and(Filters.reject(ROOMS, MerlinData.VISIBILITY, MerlinData.ENABLED, MerlinData.TAGS));
        return PROPS.props().stream().filter(compareFilter).allMatch(prop -> theUtil.equal(this.getProperty(prop), attr.getProperty(prop), comparedSet));
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Attractor)) {
            return;
        }
        Attractor a = (Attractor)obj;
        this.pauseUpdates();
        this.setName(a.getName());
        this.d_props = a.d_props;
        this.d_enabled = a.d_enabled;
        this.d_visible = a.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public PropertyDefs<Attractor> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS.props();
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop == AWARENESS_CRITERIA) {
            return (T)PROPS.getCompositeValue(this, AWARENESS_CRITERIA);
        }
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (prop == AWARENESS_CRITERIA) {
            PROPS.setCompositeValue(this, AWARENESS_CRITERIA, (CompositeValue)value);
        } else if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.pauseUpdates();
            if (prop instanceof TopologyProp) {
                this.changedEvt(MerlinData.TOPOLOGY);
            }
            this.changedEvt(prop);
            this.resumeUpdates();
        }
    }

    @Deprecated
    public ObjsFilter<String> getLegacyPre170OccTagFilter() {
        IPropertySet.Prop LEGACY_OCC_TAG_FILTER = new IPropertySet.Prop(43792304946L, ObjsFilter.acceptAll());
        return this.d_props.get(LEGACY_OCC_TAG_FILTER);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    public boolean isTemplate() {
        return this.get(TYPE) == PlaceType.TEMPLATE;
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room != null ? Collections.singleton(this.d_room) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public boolean updateTopo() {
        Point3d loc = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(loc.x, loc.y, loc.z + 1.0E-6), new Point3d(loc.x, loc.y, loc.z - 1.0E-6), 1);
        if (room != null) {
            this.pauseUpdates();
            this.d_room = room.room;
            this.set(ROOM_NORMAL, room.faceNormal);
            loc = room.p;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.get(LOCATION);
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.get(LOCATION);
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        if (loc.equals(this.d_props.get(LOCATION)) && roomNormal.equals(this.d_props.get(ROOM_NORMAL)) && this.d_room == room) {
            return;
        }
        this.d_props.set(LOCATION, loc);
        this.d_props.set(ROOM_NORMAL, roomNormal);
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(new Object[0]);
    }

    public boolean requiresLocation() {
        return Attractor.requiresLocation(this.d_props);
    }

    public static boolean requiresLocation(IPropertySet props) {
        if (props.get(TYPE) == PlaceType.TEMPLATE) {
            return false;
        }
        switch (props.get(AWARENESS).ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: {
                return props.get(BEHAVIOR) == WAIT_AT_ATTRACTOR_BEHAVIOR;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public IGeomNode getGeom() {
        if (this.get(TYPE) == PlaceType.TEMPLATE) {
            return GeomNodeUtil.EMPTY_NODE;
        }
        switch (this.get(AWARENESS).ordinal()) {
            case 0: {
                return GeomNodeUtil.newNode(this.getLocGeom());
            }
            case 1: {
                return GeomNodeUtil.newNode(this.getPointGeom());
            }
            case 2: 
            case 3: {
                return this.get(BEHAVIOR) == WAIT_AT_ATTRACTOR_BEHAVIOR ? GeomNodeUtil.newNode(this.getPointGeom()) : GeomNodeUtil.EMPTY_NODE;
            }
        }
        assert (false);
        return GeomNodeUtil.EMPTY_NODE;
    }

    private RoomLocationGeometry getLocGeom() {
        return new RoomLocationGeometry(this.d_room, this.get(ROOM_NORMAL), this.get(LOCATION), this.get(INFLUENCE_RADIUS).getValue(Geometry.LENGTH_UNIT));
    }

    private Point getPointGeom() {
        return new Point(this.get(LOCATION));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof RoomLocationGeometry) {
            RoomLocationGeometry wgeom = (RoomLocationGeometry)geom;
            this.pauseUpdates();
            this.set(INFLUENCE_RADIUS, new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.set(LOCATION, p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (this.get(TYPE) == PlaceType.TEMPLATE) {
            return DisplayGeom.EMPTY;
        }
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        Runnable addPointProps = () -> gprops.add(new IPrimProps.Vertex(BASE_COLOR, 12.0));
        switch (this.get(AWARENESS).ordinal()) {
            case 0: {
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
                gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
                break;
            }
            case 1: {
                addPointProps.run();
                break;
            }
            case 2: 
            case 3: {
                if (this.get(BEHAVIOR) != WAIT_AT_ATTRACTOR_BEHAVIOR) break;
                addPointProps.run();
            }
        }
        return new DisplayGeom(geom, gprops);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        deps.add(this, this.getRoom(), ROOM_CALLBACK);
        PROPS.takeDepSnapshot(this, deps);
    }

    static {
        PROPS.add(NamedMerlinObj.NAME);
        PROPS.add(MerlinData.VISIBILITY);
        PROPS.add(MerlinData.ENABLED);
        PROPS.add(MerlinData.TAGS);
        TYPE = TypedProps.build(1821138651, PlaceType.class, PlaceType.PLACED).attrStoreIn(PROPS);
        RANK = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)133663026, 0, Intl.intl("Rank"), "<html>" + Intl.intl("Used to compare with other triggers if an occupant has multiple choices available<br>or has already started a trigger. Triggers with higher ranks are given priority<br>over those with lower and can interrupt a lower-rank trigger's behavior.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        REQUIRES_COMPLETION = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)306752291, false, Intl.intl("Resume if interrupted"), "<html>" + Intl.intl("If the selected trigger is interrupted by another higher rank trigger with a <br><i>Resume Prior Behavior</i> action, this flag determines what happens when the <br>selected trigger's behavior is resumed: <br>If <b>checked</b>, the selected trigger's behavior resumes and is completed normally.<br>If <b>unchecked</b>, the remainder of the selected trigger's behavior is skipped, <br>replaced immediately with a <i>Resume Prior Behavior</i> action.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        AWARENESS = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)-2110148814, Awareness.class, Awareness.LINE_OF_SIGHT, Intl.intl("Awareness"), Intl.intl("Defines how an occupant becomes aware of the trigger.")).attrMarkScenarioSupported()).attrFormatValue(awareness -> awareness.name)).attrStoreIn(PROPS);
        REMEMBER_OUTSIDE_AWARENESS = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)141894139, false, Intl.intl("Remain aware"), "<html>" + Intl.intl("Allows the occupant to consider the trigger if they become aware of it and then leave<br>the awareness region before the <b>Decision Time</b>.<br>If <b>checked</b>, the occupant will consider the trigger when it's time, even if they're no longer in the awareness region.<br>If <b>unchecked</b>, the occupant ignores the trigger if they are no longer in the awareness region.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        LOCATION = PROPS.add(new TopologyProp<Point3d>(128448899, new Point3d(0.0, 0.0, 0.0)));
        ROOM_NORMAL = TypedProps.build(92873722, Vector3d.class, new Vector3d(0.0, 0.0, 1.0)).attrStoreIn(PROPS);
        INFLUENCE_RADIUS = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)10070259, new UnitDouble(2.0, SI.METER), Intl.intl("Awareness Radius"), Intl.intl("The maximum distance at which an occupant would be aware of this trigger."), 0).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        INFLUENCE = new IPropertySet.Prop<UnitDouble>(37024035, new UnitDouble(100.0, NonSI.PERCENT));
        ATTR_INFLUENCE = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(183743272, IVariant.class, new ConstVariant<UnitDouble>(new UnitDouble(100.0, NonSI.PERCENT)), Intl.intl("Influence"), "<html>" + Intl.intl("The influence of this trigger. This is multiplied by an<br>occupant's susceptibility to triggers to create a probability<br>that this trigger will influence the occupant.")).attrMarkScenarioSupported()).attrFormatValue(influence -> VariantUtil.describeUDVariant(influence, new ConstantUnitSrc(NonSI.PERCENT)))).attrStoreIn(PROPS);
        ATTR_INFLUENCE_FROM = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)83336126, InfluenceFrom.class, InfluenceFrom.ATTRACTOR_CREATION, Intl.intl("Influence Timeline"), Intl.intl("The timeline on which the trigger's influence times are based.")).attrMarkScenarioSupported()).attrFormatValue(t -> t.name)).attrStoreIn(PROPS);
        BEHAVIOR = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)266417039, Behavior.class, WAIT_AT_ATTRACTOR_BEHAVIOR, Intl.intl("Behavior"), Intl.intl("The behavior used by the occupant when influenced by this trigger.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        WAIT_TIME = (DisplayProp)((DisplayProps.Builder)DisplayProps.buildGeneric(-1752198270, IDistributedVal.class, new ConstantCurve(new UnitDouble(5.0, SI.SECOND)), Intl.intl("Wait Time"), Intl.intl("The amount of time to wait at the trigger.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        WAIT_RADIUS = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)142645281, new UnitDouble(1.0, SI.METER), Intl.intl("Wait Area Radius"), Intl.intl("Defines the radius of the wait area for the trigger."), 0).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        ROOMS = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(6464059, IEgressOccupiable.class, DisplayProps.emptySet(IEgressOccupiable.class), Intl.intl("Rooms"), Intl.intl("The rooms in which an occupant is aware of the trigger.")).attrMarkScenarioSupported()).attrFormatValue(rooms -> MerlinUtil.formatNamedSet(rooms, Intl.intl("[none]")))).attrStoreIn(PROPS);
        OCC_REACT_TIME = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)262705962, IAttractorTime.class, IAttractorTime.Auto.INSTANCE, Intl.intl("Decision Time"), Intl.intl("Specifies the time at which an occupant considers the trigger after becoming aware of it.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        IGNORE_OCC_SUSC = (DisplayProp)((DisplayProps.Builder)DisplayProps.build((Object)2029627442, false, Intl.intl("Ignore Occupant Susceptibility"), Intl.intl("If checked, ignores the occupant's susceptibility to triggers and uses only<br>the trigger's <b>Influence</b> to control the probability that an occupant<br>uses the trigger.")).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        OCC_TAG_FILTER = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(43792304946L, ObjsFilter.class, ObjsFilter.acceptAll(Tag.class), Intl.intl("Allowed Occupants"), Intl.intl("Defines which occupants can be affected by the trigger. Only occupants with\nthe specified tags are affected.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.format(30))).attrStoreIn(PROPS);
        AWARENESS_COUNT = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)3473347916419L, 1, Intl.intl("Min. Awareness Count"), Intl.intl("The minimum number of times an occupant must become aware of the trigger or a\ntrigger template's instances before the occupant will consider the trigger.")).attrValEditor((md, inline) -> new ValueFieldEditor<Integer>(Integer.class, ValueFields.intFld(IntVR.ge(1))))).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        AWARENESS_TIME = (DisplayProp)((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)547914007471L, UnitDouble.class, new UnitDouble(0.0, SI.SECOND), Intl.intl("Min. Awareness Time"), Intl.intl("The minimum amount of time an occupant must be aware of the trigger or a\ntrigger template's instances before they will consider the trigger.")).attrValEditor((md, inline) -> new UDValEditor(MerlinValueFields.udFld(DoubleVR.ge(0.0), (Unit)SI.SECOND, 1)))).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        AWARENESS_CRITERIA = (CompositeProp)((CompositeProps.CompositePropBuilder)((CompositeProps.CompositePropBuilder)CompositeProps.build(Intl.intl("Awareness Requirements"), Intl.intl("Specifies additional awareness requirements before an occupant will consider the trigger."), AWARENESS_COUNT, AWARENESS_TIME).attrDefaultValEditor(Attractor::formatAwarenessCriteria)).attrMarkScenarioSupported()).attrStoreIn(PROPS);
        PROPS.registerCompositeScenarioProperty(AWARENESS, INFLUENCE_RADIUS, ROOMS);
        PROPS.markWrapperProps(LOCATION, AWARENESS_CRITERIA);
        PROPS.registerDependency(BEHAVIOR, Dependencies.newDependency(BEHAVIOR, DLink.WEAK, Behavior.class, (md, src, behavior) -> behavior != WAIT_AT_ATTRACTOR_BEHAVIOR ? Stream.of(behavior) : Stream.empty(), Predicates.alwaysTrue(), (md, src, val, old, repl) -> repl != null ? repl : WAIT_AT_ATTRACTOR_BEHAVIOR));
        PROPS.registerDependency(ROOMS, Dependencies.newDependencyInSet(ROOMS, DLink.WEAK, IEgressOccupiable.class, Predicates.alwaysTrue()));
        PROPS.registerDependency(OCC_TAG_FILTER, ObjsFilter.newDepCallback(OCC_TAG_FILTER, Tag.class));
        TagsUtil.registerTagsDependency(PROPS);
        BASE_COLOR = Color.ORANGE;
        ROOM_CALLBACK = Dependencies.newDependencyContainedBy(IEgressOccupiable.class);
    }

    public static class TopologyProp<T>
    extends IPropertySet.Prop<T> {
        public TopologyProp(Object key, T defVal) {
            super(key, defVal);
        }
    }

    public static enum PlaceType {
        PLACED,
        TEMPLATE;

    }

    public static enum Awareness {
        LINE_OF_SIGHT(Intl.intl("Line of Sight"), Intl.intl("The occupant must be within the influence radius and have\nline-of-sight to the trigger.")),
        ROOM_ONLY(Intl.intl("Same Room"), Intl.intl("The occupant must be in the same room as the trigger.")),
        ROOMS(Intl.intl("Specified Rooms"), Intl.intl("The occupant must be in one of the specified rooms.")),
        GLOBAL(Intl.intl("Global"), Intl.intl("The occupant always knows about the trigger."));

        public final String name;
        public final String desc;

        private Awareness(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    public static enum InfluenceFrom {
        ATTRACTOR_CREATION(Intl.intl("Trigger"), Intl.intl("The trigger's influence value starts when it is created.")),
        SIMULATION_START(Intl.intl("Global"), Intl.intl("The trigger's influence value starts at the beginning of the simulation."));

        public final String name;
        public final String desc;

        private InfluenceFrom(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

