/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import common.data.WaitMode;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.AssistedEvacTeam;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.AWaitAction;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class WaitForAssistance
extends AWaitAction
implements IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<Set<AssistedEvacTeam>> TEAMS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("WaitForAssistance.TEAMS", Set.class, DisplayProps.emptySet(AssistedEvacTeam.class), Intl.intl("Assisting Teams"), Intl.intl("The teams that will assist the occupant.")).attrMarkScenarioSupported()).attrFormatValue(teams -> MerlinUtil.formatNamedSet(teams, Intl.intl("[any]")))).attrToProp();
    public static final PropertyDefs<WaitForAssistance> PROP_TYPES = new PropertyDefs<AWaitAction>(WaitForAssistance.class, AWaitAction.PROP_TYPES, TEAMS);

    public WaitForAssistance(Set<AssistedEvacTeam> teams) {
        this.set(TEAMS, teams);
        this.set(MODE, WaitMode.WAIT_IN_PLACE_COLLISIONS);
    }

    public Predicate<AssistedEvacTeam> getTeamFilter() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        return teams.isEmpty() ? Predicates.alwaysTrue() : Filters.accept(teams);
    }

    @Override
    public WaitForAssistance clone() {
        return (WaitForAssistance)super.clone();
    }

    @Override
    public WaitForAssistance getRestoreObj() {
        return (WaitForAssistance)super.getRestoreObj();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        if (teams.size() == 1) {
            return String.format(Intl.intl("Wait for assistance <%s>"), teams.iterator().next().getName());
        }
        if (teams.isEmpty()) {
            return Intl.intl("Wait for assistance <any team>");
        }
        return Intl.intl("Wait for assistance");
    }

    @Override
    public void setName(String name) {
    }

    public PropertyDefs<WaitForAssistance> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(TEAMS, Dependencies.newDependencyInSet(TEAMS, DLink.WEAK, AssistedEvacTeam.class, Predicates.alwaysTrue()));
    }
}

