/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class LookAt
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<Set<Tag>> PROP_TAGS = ((DisplayProps.Builder)DisplayProps.buildGeneric("LookAt.TAGS ", Set.class, theUtil.emptySet(Tag.class), Intl.intl("Occupant Tags"), Intl.intl("Defines the tags used to find a target occupant.")).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<TagLogic> PROP_TAG_LOGIC = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"LookAt.TAG_LOGIC ", TagLogic.class, TagLogic.ALL, Intl.intl("Tag Logic"), Intl.intl("Defines how the tags are combined in order to find a target occupant.")).attrMarkScenarioSupported()).attrFormatValue(logic -> logic.name)).attrToProp();
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"LookAt.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), Intl.intl("Defines the occupant's preference for a target occupant based on the distance\nto the occupant.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    private static final Collection<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(LookAt.class);
    private static final Map<Object, IPropertySet.Prop<?>> ALL_PROPS_MAP = IPropertySet.getKeyToPropMap(ALL_PROPS);
    public static final PropertyDefs<LookAt> PROP_TYPES = new PropertyDefs<LookAt>(LookAt.class, List.of(), ALL_PROPS, NamedMerlinObj.NAME);
    private PropertySet d_props = new PropertySet();

    public LookAt() {
        super(null);
    }

    @Override
    public LookAt clone() {
        LookAt clone = (LookAt)super.clone();
        clone.d_props = MerlinUtil.clone(this.d_props, ALL_PROPS_MAP::get, (prop, v) -> {
            if (prop instanceof IDisplayProp) {
                return ((IDisplayProp)((Object)prop)).cloneValue(v);
            }
            return v;
        });
        return clone;
    }

    @Override
    public LookAt getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof LookAt)) {
            return;
        }
        LookAt la = (LookAt)obj;
        this.pauseUpdates();
        this.d_props = la.d_props;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        LookAt la = (LookAt)comparable;
        return this.getName().equals(la.getName()) && this.d_props.compare((IPropertySet)la.d_props, PROP_DIST_PREF, PROP_TAG_LOGIC, PROP_TAGS);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Deprecated
    public Set<String> getLegacyPre170Tags() {
        IPropertySet.Prop strTagsProp = new IPropertySet.Prop("LookAt.TAGS ", Collections.emptySet());
        return this.d_props.get(strTagsProp);
    }

    public PropertyDefs<LookAt> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public String getName() {
        return LookAt.formatName(this.get(PROP_TAG_LOGIC), TagsUtil.tagsAsStrings(this.get(PROP_TAGS)));
    }

    public static String formatName(TagLogic logic, Set<String> tagStrings) {
        return String.format(Intl.intl("Look at Occ %s"), logic.formatTags.apply(tagStrings));
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(PROP_TAGS, TagsUtil.getTagCallback(PROP_TAGS));
        PROP_TYPES.registerCompositeScenarioProperty(PROP_TAGS, PROP_TAG_LOGIC);
    }

    public static enum TagLogic implements ILabeledEnum
    {
        ALL(Intl.intl("All"), Intl.intl("The target occupant must have all the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" and "), 25)),
        ANY(Intl.intl("Any"), Intl.intl("The target occupant must have any of the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" or "), 25));

        public final String name;
        public final String desc;
        public final Function<Set<String>, String> formatTags;

        private TagLogic(String name, String desc, Function<Set<String>, String> formatTags) {
            this.name = name;
            this.desc = desc;
            this.formatTags = formatTags;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DistancePref implements ILabeledEnum
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A target occupant is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available occupant is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

