/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class GotoQueue
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    @Deprecated
    public static final IPropertySet.Prop<QueueObject> PROP_QUEUES = new IPropertySet.Prop<Object>("GotoQueue.QUEUES", null);
    @Deprecated
    public static final IPropertySet.Prop<Set<QueueObject>> PROP_QUEUE_OBJECTS = new IPropertySet.Prop("GotoQueue.QUEUE_OBJECTS", Collections.emptySet());
    @Deprecated
    public static final IPropertySet.Prop<Set<QueueObjectComp>> PROP_QUEUE_COMPS = new IPropertySet.Prop("GotoQueue.QUEUE_COMPS", Collections.emptySet());
    public static final DisplayProp<Set<IGotoQueueDestination>> PROP_QUEUE_DESTINATIONS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("GotoQueue.QUEUE_DESTINATION", Set.class, DisplayProps.emptySet(IGotoQueueDestination.class), Intl.intl("Queue"), "").attrMarkScenarioSupported()).attrFormatValue(queues -> MerlinUtil.formatNamedSet(queues, Intl.intl("[none]")))).attrToProp();
    public static final PropertyDefs<GotoQueue> PROP_TYPES = new PropertyDefs<GotoQueue>(GotoQueue.class, List.of(), NamedMerlinObj.NAME, PROP_QUEUE_DESTINATIONS);
    private PropertySet d_props = new PropertySet();
    @Deprecated
    private QueueObject d_queue;

    public GotoQueue(IGotoQueueDestination queue) {
        this(Collections.singleton(queue));
    }

    public GotoQueue(Set<IGotoQueueDestination> queues) {
        super(null);
        this.set(PROP_QUEUE_DESTINATIONS, queues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0143)) {
            this.d_props = new PropertySet();
            LinkedIdentityHashSet qObjs = new LinkedIdentityHashSet();
            qObjs.add(this.d_queue);
            this.set(PROP_QUEUE_OBJECTS, qObjs);
            this.set(PROP_QUEUE_COMPS, Collections.emptySet());
            this.d_queue = null;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0144)) {
            Set<QueueObject> queues = this.get(PROP_QUEUE_OBJECTS);
            Set<QueueObjectComp> groups = this.get(PROP_QUEUE_COMPS);
            this.d_props.remove(PROP_QUEUE_OBJECTS);
            this.d_props.remove(PROP_QUEUE_COMPS);
            LinkedIdentityHashSet destinations = new LinkedIdentityHashSet();
            destinations.addAll(queues);
            destinations.addAll(groups);
            this.set(PROP_QUEUE_DESTINATIONS, destinations.isEmpty() ? Collections.emptySet() : destinations);
        }
    }

    @Override
    public GotoQueue getRestoreObj() {
        return this.clone();
    }

    @Override
    public GotoQueue clone() {
        GotoQueue clone = (GotoQueue)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoQueue)) {
            return;
        }
        GotoQueue gq = (GotoQueue)obj;
        this.pauseUpdates();
        this.setName(gq.getSetName());
        this.set(PROP_QUEUE_DESTINATIONS, gq.getDestinations());
        this.resumeUpdates();
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        GotoQueue gq = (GotoQueue)comparable;
        return Objects.equals(this.getSetName(), gq.getSetName()) && theUtil.surrogateSetsEqual((Collection)this.get(PROP_QUEUE_DESTINATIONS), (Collection)gq.get(PROP_QUEUE_DESTINATIONS), comparedSet);
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        IGotoQueueDestination dest;
        String name = super.getName();
        if (name != null) {
            return name;
        }
        Set<IGotoQueueDestination> dests = this.getDestinations();
        if (dests.size() == 1 && (dest = dests.iterator().next()) instanceof INamed) {
            return String.format(Intl.intl("Goto %s"), ((INamed)((Object)dest)).getName());
        }
        return Intl.intl("Goto Queues");
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    public Set<IGotoQueueDestination> getDestinations() {
        return this.get(PROP_QUEUE_DESTINATIONS);
    }

    public Set<QueueObject> getExplicitQueues() {
        return theUtil.filter(this.getDestinations(), QueueObject.class);
    }

    public Collection<QueueObject> getQueues() {
        return MerlinUtil.flatten(this.getDestinations(), QueueObject.class);
    }

    public Set<QueueObjectComp> getQueueComps() {
        return theUtil.filter(this.getDestinations(), QueueObjectComp.class);
    }

    public PropertyDefs<GotoQueue> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return ICompElement.NOT_SUPPORTED;
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(this.get(prop), value)) {
            return;
        }
        this.d_props.setIfNotDefault(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(PROP_QUEUE_DESTINATIONS, Dependencies.newDependency(PROP_QUEUE_DESTINATIONS, DLink.WEAK, IGotoQueueDestination.class, (md, src, set) -> set.stream(), (md, q) -> src -> src != md.queues, (md, src, set, old, repl) -> Dependencies.replaceSetValue(set, old, repl)));
    }
}

