/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class GotoOccTarget
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<Set<OccTarget>> PROP_TARGETS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("GotoOccTarget.LOCATIONS ", Set.class, DisplayProps.emptySet(OccTarget.class), Intl.intl("Occ Targets"), "").attrMarkScenarioSupported()).attrFormatValue(targets -> MerlinUtil.formatNamedSet(targets, Intl.intl("[any]")))).attrToProp();
    public static final IPropertySet.Prop<Predicate<? super OccTarget>> PROP_FILTER = new IPropertySet.Prop("GotoOccTarget.FILTER", Predicates.alwaysTrue());
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOccTarget.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the distance<br>to the target. This is secondary to the <b>Priority Preference</b>,<br>but also helps define how the occupant chooses a target.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final DisplayProp<PriorityPref> PROP_PRIORITY_PREF = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOccTarget.PRIORITY_PREF", PriorityPref.class, PriorityPref.HIGHER, Intl.intl("Priority Preference"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the<br>target's priority. This interacts with the <b>Distance Preference</b><br>to define how the occupant chooses a target.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final PropertyDefs<GotoOccTarget> PROP_TYPES = new PropertyDefs<GotoOccTarget>(GotoOccTarget.class, List.of(), IPropertySet.getAllDeclaredPublicStaticProps(GotoOccTarget.class), NamedMerlinObj.NAME);
    private PropertySet d_props = new PropertySet();

    public GotoOccTarget(Predicate<? super OccTarget> filter, Set<OccTarget> locations) {
        super(null);
        this.set(PROP_FILTER, filter);
        this.set(PROP_TARGETS, locations);
    }

    @Override
    public GotoOccTarget clone() {
        GotoOccTarget clone = (GotoOccTarget)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public GotoOccTarget getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoOccTarget)) {
            return;
        }
        GotoOccTarget gr = (GotoOccTarget)obj;
        this.pauseUpdates();
        this.d_props = gr.d_props;
        this.changedEvt(new Object[0]);
        this.setName(gr.getSetName());
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        GotoOccTarget gol = (GotoOccTarget)comparable;
        return this.getName().equals(gol.getName()) && this.get(PROP_DIST_PREF) == gol.get(PROP_DIST_PREF) && this.get(PROP_PRIORITY_PREF) == gol.get(PROP_PRIORITY_PREF) && theUtil.equal(this.get(PROP_FILTER), gol.get(PROP_FILTER)) && theUtil.surrogateSetsEqual((Collection)this.get(PROP_TARGETS), (Collection)gol.get(PROP_TARGETS));
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        Predicate<? super OccTarget> filter = this.get(PROP_FILTER);
        Collection locations = this.get(PROP_TARGETS);
        if (filter instanceof IFilter) {
            String filterName = filter.toString();
            if (this.get(PROP_TARGETS).size() == 1) {
                return String.format(Intl.intl("Goto %1$s <%2$s>"), filterName, ((OccTarget)locations.iterator().next()).getName());
            }
            return String.format(Intl.intl("Goto %s Occ Targets"), filterName);
        }
        if (locations.size() == 1) {
            return String.format(Intl.intl("Goto %s"), ((OccTarget)locations.iterator().next()).getName());
        }
        if (locations.isEmpty()) {
            return Intl.intl("Goto Any Occ Target");
        }
        return String.format(Intl.intl("Goto Occ Targets"), new Object[0]);
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    public PropertyDefs<GotoOccTarget> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public IDestination getDestination() {
        MerlinData md;
        Function<Collection, Set> toRooms = locs -> new LinkedIdentityHashSet<IEgressOccupiable>(theUtil.map(locs, loc -> loc.getRoom()));
        Set d_rooms = toRooms.apply(this.get(PROP_TARGETS));
        Collection destRooms = d_rooms;
        if (destRooms.isEmpty() && (md = (MerlinData)this.getDomain()) != null) {
            destRooms = toRooms.apply(md.occTargets.flatten(OccTarget.class, this.get(PROP_FILTER)));
        }
        return new GotoRooms.Destination(this, d_rooms, destRooms);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(PROP_TARGETS, Dependencies.newDependencyInSet(PROP_TARGETS, DLink.WEAK, OccTarget.class, Predicates.alwaysTrue()));
    }

    public static interface IFilter
    extends Predicate<OccTarget> {
        public String toString();
    }

    public static enum PriorityPref {
        NONE(Intl.intl("None"), Intl.intl("The occupant does not consider target priority when choosing a target.")),
        LOWER(Intl.intl("Lower"), Intl.intl("The occupant prefers targets with lower priority.")),
        HIGHER(Intl.intl("Higher"), Intl.intl("The occupant prefers targets with higher priority."));

        public final String name;
        public final String desc;

        private PriorityPref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    public static enum DistancePref {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A target is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available target is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

