/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class GotoOcc
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<Set<Tag>> PROP_GOTO_TAGS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("GotoOcc.TAGS ", Set.class, theUtil.emptySet(Tag.class), Intl.intl("Occupant Tags"), Intl.intl("Defines the tags used to find a destination occupant.")).attrMarkScenarioSupported()).attrFormatValue(tags -> StringTagsUtil.format(TagsUtil.tagsAsStrings(tags)))).attrToProp();
    public static final DisplayProp<TagLogic> PROP_TAG_LOGIC = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.TAG_LOGIC ", TagLogic.class, TagLogic.ALL, Intl.intl("Tag Logic"), Intl.intl("Defines how the tags are combined in order to find a destination occupant.")).attrMarkScenarioSupported()).attrFormatValue(logic -> logic.name)).attrToProp();
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), Intl.intl("Defines the occupant's preference for a destination occupant based on the distance\nto the occupant.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final DisplayProp<Tracking> PROP_TRACKING = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.TRACKING", Tracking.class, Tracking.DYNAMIC_ONCE, Intl.intl("Tracking"), Intl.intl("Defines how the source occupant will track the destination occupant.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_ARRIVAL_RADIUS = ((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.ARRIVAL_RADIUS", new UnitDouble(1.0, SI.METER), Intl.intl("Arrival Radius"), Intl.intl("The distance to the destination occupant at which the source occupant\ndecides they have reached the destination."), 0).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<TargetNotFound> PROP_NO_OCCUPANTS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.PROP_NO_OCCUPANTS", TargetNotFound.class, TargetNotFound.SKIP, Intl.intl("No available occupants"), Intl.intl("Defines what to do if there are no occupants matching the tag\ncriteria when the action is started.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final DisplayProp<TargetUnreachable> PROP_UNREACHABLE = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.PROP_UNREACHABLE", TargetUnreachable.class, TargetUnreachable.SKIP, Intl.intl("Destination unreachable"), Intl.intl("Defines what to do if the current destination occupant becomes unreachable,\nsuch as if all paths to the destination become blocked.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final PropertyDefs<GotoOcc> PROP_TYPES = new PropertyDefs<GotoOcc>(GotoOcc.class, List.of(), NamedMerlinObj.NAME, PROP_GOTO_TAGS, PROP_TAG_LOGIC, PROP_DIST_PREF, PROP_TRACKING, PROP_ARRIVAL_RADIUS, PROP_NO_OCCUPANTS, PROP_UNREACHABLE);
    private static final Collection<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(GotoOcc.class);
    private static final Map<Object, IPropertySet.Prop<?>> ALL_PROPS_MAP = IPropertySet.getKeyToPropMap(ALL_PROPS);
    private PropertySet d_props = new PropertySet();

    public GotoOcc() {
        super(null);
    }

    @Override
    public GotoOcc clone() {
        GotoOcc clone = (GotoOcc)super.clone();
        clone.d_props = MerlinUtil.clone(this.d_props, ALL_PROPS_MAP::get, (prop, v) -> {
            if (prop instanceof IDisplayProp) {
                return ((IDisplayProp)((Object)prop)).cloneValue(v);
            }
            return v;
        });
        return clone;
    }

    @Override
    public GotoOcc getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoOcc)) {
            return;
        }
        GotoOcc gr = (GotoOcc)obj;
        this.pauseUpdates();
        this.d_props = gr.d_props;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        GotoOcc gol = (GotoOcc)comparable;
        return this.getName().equals(gol.getName()) && this.d_props.compare((IPropertySet)gol.d_props, PROP_DIST_PREF, PROP_TAG_LOGIC, PROP_GOTO_TAGS, PROP_NO_OCCUPANTS, PROP_UNREACHABLE, PROP_TRACKING, PROP_ARRIVAL_RADIUS);
    }

    @Deprecated
    public Set<String> getLegacyPre170Tags() {
        IPropertySet.Prop LEGACY_TAGS = new IPropertySet.Prop("GotoOcc.TAGS ", Collections.emptySet());
        return this.d_props.get(LEGACY_TAGS);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        return GotoOcc.formatName(this.get(PROP_TAG_LOGIC), this.get(PROP_GOTO_TAGS).stream().map(Tag::toString).collect(Collectors.toSet()));
    }

    public static String formatName(TagLogic logic, Set<String> tagNames) {
        return String.format(Intl.intl("Goto Occ %s"), logic.formatTags.apply(tagNames));
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public PropertyDefs<GotoOcc> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    @Override
    public IDestination getDestination() {
        return Destination.INSTANCE;
    }

    static {
        PROP_TYPES.registerDependency(PROP_GOTO_TAGS, TagsUtil.getTagCallback(PROP_GOTO_TAGS));
        PROP_TYPES.registerCompositeScenarioProperty(PROP_GOTO_TAGS, PROP_TAG_LOGIC);
    }

    public static enum TagLogic implements ILabeledEnum
    {
        ALL(Intl.intl("All"), Intl.intl("The destination occupant must have all the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" and "), 25)),
        ANY(Intl.intl("Any"), Intl.intl("The destination occupant must have any of the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" or "), 25));

        public final String name;
        public final String desc;
        public final Function<Set<String>, String> formatTags;

        private TagLogic(String name, String desc, Function<Set<String>, String> formatTags) {
            this.name = name;
            this.desc = desc;
            this.formatTags = formatTags;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class Destination
    implements IDestination {
        public static final Destination INSTANCE = new Destination();

        private Destination() {
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }

    public static enum TargetUnreachable implements ILabeledEnum
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The source occupant waits until their current destination occupant becomes reachable again.")),
        RESTART(Intl.intl("Restart action"), Intl.intl("The action is restarted so a new destination occupant can be found."));

        public final String name;
        public final String desc;

        private TargetUnreachable(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum TargetNotFound implements ILabeledEnum
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The source occupant waits until a destination occupant can be found."));

        public final String name;
        public final String desc;

        private TargetNotFound(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Tracking implements ILabeledEnum
    {
        DYNAMIC_ONCE(Intl.intl("Go to occupant"), Intl.intl("The source occupant seeks the destination occupant until they are within the arrival\nradius and have a clear line-of-sight.")),
        DYNAMIC_CONTINUOUS(Intl.intl("Follow occupant"), Intl.intl("The source occupant seeks and follows the destination occupant as long as the\ndestination occupant is still in the simulation and has the desired tags.")),
        INITIAL_LOC(Intl.intl("Go to initial location"), Intl.intl("The source occupant records the location of the destination occupant when the action\nis started and then seeks that point until they are within the arrival radius and\nhave a clear line-of-sight to the point.\nNOTE: The destination occupant may not still be at the point when the source occupant\narrives."));

        public final String name;
        public final String desc;

        private Tracking(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DistancePref implements ILabeledEnum
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A destination occupant is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available occupant is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

