/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;

public class GotoCurrentAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<UnitDouble> PROP_ARRIVAL_RADIUS = ((DisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.ARRIVAL_RADIUS", new UnitDouble(1.0, SI.METER), Intl.intl("Arrival Radius"), Intl.intl("The distance to the trigger at which the occupant decides they have reached the trigger."), 0).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Tracking> PROP_TRACKING = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.TRACKING", Tracking.class, Tracking.DYNAMIC_ONCE, Intl.intl("Tracking"), Intl.intl("Defines how the occupant will track the trigger.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    public static final DisplayProp<TargetUnreachable> PROP_UNREACHABLE = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.PROP_UNREACHABLE", TargetUnreachable.class, TargetUnreachable.SKIP, Intl.intl("Destination unreachable"), Intl.intl("Defines what to do if the trigger becomes unreachable, such as if all paths to the trigger become blocked.")).attrMarkScenarioSupported()).attrFormatValue(v -> v.name)).attrToProp();
    private static final Collection<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(GotoCurrentAttractor.class);
    private static final Map<Object, IPropertySet.Prop<?>> ALL_PROPS_MAP = IPropertySet.getKeyToPropMap(ALL_PROPS);
    public static final PropertyDefs<GotoCurrentAttractor> PROP_TYPES = new PropertyDefs<GotoCurrentAttractor>(GotoCurrentAttractor.class, List.of(), ALL_PROPS, NamedMerlinObj.NAME);
    private PropertySet d_props = new PropertySet();

    public GotoCurrentAttractor() {
        super(null);
    }

    public GotoCurrentAttractor(String name, UnitDouble arriveRad, TargetUnreachable unreachable) {
        super(name);
        this.set(PROP_ARRIVAL_RADIUS, arriveRad);
        this.set(PROP_UNREACHABLE, unreachable);
    }

    @Override
    public GotoCurrentAttractor clone() {
        GotoCurrentAttractor clone = (GotoCurrentAttractor)super.clone();
        clone.setName(this.getSetName());
        clone.d_props = MerlinUtil.clone(this.d_props, ALL_PROPS_MAP::get, (prop, v) -> {
            if (prop instanceof IDisplayProp) {
                return ((IDisplayProp)((Object)prop)).cloneValue(v);
            }
            return v;
        });
        return clone;
    }

    @Override
    public GotoCurrentAttractor getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoCurrentAttractor)) {
            return;
        }
        GotoCurrentAttractor gca = (GotoCurrentAttractor)obj;
        this.pauseUpdates();
        this.setName(this.getSetName());
        this.d_props = gca.d_props;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        GotoCurrentAttractor gca = (GotoCurrentAttractor)comparable;
        return this.getName().equals(gca.getName()) && this.d_props.compare((IPropertySet)gca.d_props, PROP_UNREACHABLE, PROP_TRACKING, PROP_ARRIVAL_RADIUS);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = Intl.intl("Goto Current Trigger");
        }
        return name;
    }

    public PropertyDefs<GotoCurrentAttractor> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public IDestination getDestination() {
        return Destination.INSTANCE;
    }

    private static class Destination
    implements IDestination {
        public static final Destination INSTANCE = new Destination();

        private Destination() {
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }

    public static enum TargetUnreachable implements ILabeledEnum
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The occupant waits until the trigger becomes reachable again."));

        public final String name;
        public final String desc;

        private TargetUnreachable(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Tracking implements ILabeledEnum
    {
        DYNAMIC_ONCE(Intl.intl("Go to trigger"), Intl.intl("The occupant seeks their current trigger until they are within the arrival\nradius and there is a clear line-of-sight to the trigger.")),
        DYNAMIC_CONTINUOUS(Intl.intl("Follow trigger"), Intl.intl("The occupant seeks and follows the trigger as long as the\ntrigger still exists.")),
        INITIAL_LOC(Intl.intl("Go to initial location"), Intl.intl("The occupant records the location of their current trigger when the action\nis started, and then seeks that point until they are within the arrival radius\nand there is a clear line-of-sight to the point.\nNOTE: The trigger might not still be at the point when the occupant\narrives."));

        public final String name;
        public final String desc;

        private Tracking(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

