/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class DestroyAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 7824814114567292619L;
    public static final DisplayProp<Set<Attractor>> PROP_ATTRACTORS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("DestroyAttractor.ATTRACTORS", Set.class, DisplayProps.emptySet(Attractor.class), Intl.intl("Triggers"), Intl.intl("<html>The set of triggers to destroy.<br>Only triggers previously created by this occupant will be destroyed.")).attrMarkScenarioSupported()).attrFormatValue(attractors -> MerlinUtil.formatNamedSet(attractors, Intl.intl("[none]")))).attrToProp();
    public static final PropertyDefs<DestroyAttractor> PROP_TYPES = new PropertyDefs<DestroyAttractor>(DestroyAttractor.class, List.of(), NamedMerlinObj.NAME, PROP_ATTRACTORS);
    private Set<Attractor> d_attractors;

    public DestroyAttractor(Set<Attractor> attractors) {
        super(null);
        this.d_attractors = attractors;
    }

    @Override
    public DestroyAttractor getRestoreObj() {
        return (DestroyAttractor)this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof DestroyAttractor)) {
            return;
        }
        DestroyAttractor da = (DestroyAttractor)obj;
        this.pauseUpdates();
        this.setAttractors(da.d_attractors);
        this.setName(da.getSetName());
        this.resumeUpdates();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public Set<Attractor> getAttractors() {
        return Collections.unmodifiableSet(this.d_attractors);
    }

    public void setAttractors(Set<Attractor> attractors) {
        this.d_attractors = attractors;
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        if (this.d_attractors.size() == 1) {
            return String.format(Intl.intl("Destroy %s"), this.d_attractors.iterator().next().getName());
        }
        return Intl.intl("Destroy Triggers");
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    public PropertyDefs<DestroyAttractor> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_ATTRACTORS) {
            return this.getAttractors();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_ATTRACTORS) {
            this.setAttractors((Set)value);
        }
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        DestroyAttractor comparableAction = (DestroyAttractor)comparable;
        if (!theUtil.equal(this.getSetName(), comparableAction.getSetName(), comparedSet)) {
            return false;
        }
        return theUtil.surrogateSetsEqual(this.getAttractors(), comparableAction.getAttractors(), comparedSet);
    }

    static {
        PROP_TYPES.registerDependency(PROP_ATTRACTORS, Dependencies.newDependencyInSet(PROP_ATTRACTORS, DLink.WEAK, Attractor.class, Attractor::isTemplate));
    }
}

