/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class ChangeTags
extends NamedMerlinObj
implements IBehaviorAction,
ICyclicSurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<Operation> OPERATION = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)855282475, Operation.class, Operation.ADD, Intl.intl("Operation"), Intl.intl("Specifies how the tags should be applied to the occupant.")).attrMarkScenarioSupported()).attrFormatValue(op -> op.name)).attrToProp();
    public static final DisplayProp<Set<Tag>> TAGS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(262350898, Set.class, theUtil.emptySet(Tag.class), Intl.intl("Tags"), Intl.intl("The tags for the operation.")).attrMarkScenarioSupported()).attrFormatValue(tags -> StringTagsUtil.format(TagsUtil.tagsAsStrings(tags)))).attrToProp();
    public static final PropertyDefs<ChangeTags> PROP_TYPES = new PropertyDefs<ChangeTags>(ChangeTags.class, List.of(), NamedMerlinObj.NAME, OPERATION, TAGS);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(ChangeTags.class);
    private PropertySet d_props = new PropertySet();

    private static String format(Set<String> tags) {
        return MerlinUtil.formatStrTags(tags, "; ", 25);
    }

    public ChangeTags(Operation op, Set<Tag> tags) {
        this.set(OPERATION, op);
        this.set(TAGS, tags);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public Object clone() {
        ChangeTags cpp = (ChangeTags)super.clone();
        cpp.d_props = this.d_props.clone();
        return cpp;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ChangeTags)) {
            return;
        }
        ChangeTags changeProfile = (ChangeTags)obj;
        this.pauseUpdates();
        for (IPropertySet.Prop<?> prop : ALL_PROPS) {
            this.d_props.setIfNotDefault(prop, changeProfile.d_props.get(prop));
        }
        this.resumeUpdates();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    @Override
    public String getName() {
        return ChangeTags.formatName(this.get(OPERATION), theUtil.map(this.get(TAGS), NamedMerlinObj::getName));
    }

    public static String formatName(Operation op, Set<String> tagNames) {
        return op.format.apply(tagNames);
    }

    public PropertyDefs<ChangeTags> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return ICompElement.NOT_SUPPORTED;
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(this.getProp(prop), value)) {
            return;
        }
        this.d_props.setIfNotDefault(prop, value);
        this.changedEvt(prop);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        ChangeTags comparableBehavior = (ChangeTags)comparable;
        return this.get(OPERATION) == comparableBehavior.get(OPERATION) && theUtil.surrogateSetsEqual((Collection)this.get(TAGS), (Collection)comparableBehavior.get(TAGS), comparedSet);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(TAGS, TagsUtil.getTagCallback(TAGS));
    }

    public static enum Operation {
        ADD(Intl.intl("Add (+)"), Intl.intl("Adds the specified tags to the occupant."), false, tags -> String.format(Intl.intl("+ %s"), ChangeTags.format(tags))),
        REMOVE(Intl.intl("Remove (-)"), Intl.intl("Removes the specified tags from the occupant."), false, tags -> String.format(Intl.intl("- %s"), ChangeTags.format(tags))),
        SET(Intl.intl("Set"), Intl.intl("Sets the occupant's tags to the specified set."), true, tags -> String.format(Intl.intl("Set Tags: %s"), ChangeTags.format(tags)));

        public final String name;
        public final String description;
        public final Function<Set<String>, String> format;
        public final boolean tagsCanBeEmpty;

        private Operation(String name, String desc, boolean tagsCanBeEmpty, Function<Set<String>, String> format) {
            this.name = name;
            this.description = desc;
            this.format = format;
            this.tagsCanBeEmpty = tagsCanBeEmpty;
        }
    }
}

