/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import common.data.ClientAwareness;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class AssistOccupants
extends AMerlinObj
implements IDestinationAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<AssistedEvacTeam> TEAM = ((DisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.TEAM", AssistedEvacTeam.class, null, Intl.intl("Team"), Intl.intl("The team on which the occupant will assist.")).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<ClientAwareness> CLIENT_AWARENESS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.CLIENT_AWARENESS", ClientAwareness.class, ClientAwareness.GLOBAL, Intl.intl("Client Awareness"), Intl.intl("Determines which clients the assistant can assist.")).attrMarkScenarioSupported()).attrFormatValue(awareness -> awareness.name)).attrToProp();
    public static final DisplayProp<Set<IEgressOccupiable>> ROOMS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("AssistOccupants.ROOMS", IEgressOccupiable.class, DisplayProps.emptySet(IEgressOccupiable.class), Intl.intl("Rooms"), Intl.intl("The rooms in which this assistant can assist clients.")).attrMarkScenarioSupported()).attrFormatValue(rooms -> MerlinUtil.formatNamedSet(rooms, Intl.intl("[none]")))).attrToProp();
    public static final String AWARENESS_RADIUS_DISABLED_STR = Intl.intl("INF");
    public static final DisplayProp<UnitDouble> AWARENESS_RADIUS = ((DisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.AWARENESS_RADIUS", new UnitDouble(Double.POSITIVE_INFINITY, SI.METER), Intl.intl("Awareness Radius"), String.format(Intl.intl("The assistant will only assist clients they have been within this distance to.\n\"%s\" may be specified to disable distance requirements."), AWARENESS_RADIUS_DISABLED_STR), 0).attrMarkScenarioSupported()).attrToProp();
    public static final PropertyDefs<AssistOccupants> PROP_TYPES = new PropertyDefs<AssistOccupants>(AssistOccupants.class, List.of(), NamedMerlinObj.NAME, TEAM, CLIENT_AWARENESS, ROOMS, AWARENESS_RADIUS);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(AssistOccupants.class);
    private PropertySet d_props = new PropertySet();

    public AssistOccupants(AssistedEvacTeam team) {
        this.d_props.set(TEAM, team);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public AssistOccupants clone() {
        AssistOccupants clone = (AssistOccupants)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public AssistOccupants getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof AssistOccupants)) {
            return;
        }
        AssistOccupants ao = (AssistOccupants)obj;
        this.pauseUpdates();
        for (IPropertySet.Prop<?> prop : ALL_PROPS) {
            this.d_props.setIfNotDefault(prop, ao.d_props.get(prop));
        }
        this.resumeUpdates();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        return String.format(Intl.intl("Assist <%s>"), this.get(TEAM).getName());
    }

    @Override
    public void setName(String name) {
    }

    public PropertyDefs<AssistOccupants> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(value, this.d_props.get(prop))) {
            try (IMerlinObj.EventPause paused = this.openPause();){
                this.d_props.setIfNotDefault(prop, value);
                this.changedEvt(prop);
                if (prop.key.equals(AssistOccupants.CLIENT_AWARENESS.key) && value != ClientAwareness.ROOMS) {
                    this.set(ROOMS, Collections.emptySet());
                }
            }
        }
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        AssistOccupants comparableAction = (AssistOccupants)comparable;
        return theUtil.equal(this.getProperty(TEAM), comparableAction.getProperty(TEAM), comparedSet);
    }

    private int surrogateHashCode() {
        return this.hashCode();
    }

    static {
        PROP_TYPES.registerCompositeScenarioProperty(CLIENT_AWARENESS, ROOMS, AWARENESS_RADIUS);
        PROP_TYPES.registerDependency(TEAM, Dependencies.newDependencyAsValue(TEAM, DLink.STRONG, AssistedEvacTeam.class, Predicates.alwaysTrue()));
        PROP_TYPES.registerDependency(ROOMS, Dependencies.newDependencyInSet(ROOMS, DLink.WEAK, IEgressOccupiable.class, Predicates.alwaysTrue()));
    }

    public class Destination
    implements IDestination {
        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getAction().get(TEAM).equals(AssistOccupants.this.get(TEAM));
        }

        @Override
        public int hashCode() {
            return 0xFA9832F ^ this.getAction().get(TEAM).hashCode();
        }

        protected AssistOccupants getAction() {
            return AssistOccupants.this;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }
}

