/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.Occupancy;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.units.UnitDouble;

public interface IEgressOccupiable
extends IEgressComp {
    public static final DisplayProp<UnitDouble> AREA = DisplayProps.build((Object)"IEgressOccupiable.AREA", null, Intl.intl("Area"), "", 4).attrToProp();
    public static final DisplayProp<UnitDouble> OCC_COUNT = DisplayProps.build((Object)"IEgressOccupiable.OCC_COUNT", null, Intl.intl("Pers"), "", 9).attrToProp();
    public static final DisplayProp<SpeedModifier> SPEED_MODIFIER = ((DisplayProps.Builder)DisplayProps.build((Object)"IEgressOccupiable.SPEED_MODIFIER", SpeedModifier.class, SpeedModifier.IDENTITY, Intl.intl("Speed Modifier"), Intl.intl("Modifier applied to the speed of occupants in the room.")).attrMarkScenarioSupported()).attrToProp();
    public static final Object OCCUPANCY_CHANGED = "IEgressOccupiable.OCCUPANCY_CHANGED";
    public static final DisplayProp<IOccCount> PROP_CAPACITY = ((DisplayProps.Builder)DisplayProps.build((Object)"AEgressComp.CAPACITY", IOccCount.class, new ConstOccCount(50), Intl.intl("Capacity"), Intl.intl("If checked, sets a custom capacity limit for selected components.<br>If unchecked, no capacity limit is used for selected components.")).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Boolean> PROP_CAPACITY_ENABLED = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"AEgressComp.CAPACITY_ENABLED", false, Intl.intl("Capacity Enabled"), Intl.intl("Whether or not to enforce the set Capacity.")).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrMarkScenarioSupported()).attrToProp();

    public UnitDouble getArea();

    public Occupancy getOccupancy();

    public boolean isWalkable(Point3d var1);

    public boolean getOccupantsAllowed();

    public Set<EgressAgent> getOccupants();

    public Set<GotoWaypoint> getWaypoints();

    public IOccCount getCapacity();

    public void setCapacity(IOccCount var1);

    public boolean getCapacityEnabled();

    public void setCapacityEnabled(boolean var1);

    public Model getModel();

    default public Predicate<Edge> getBoundaryEdgeFilter() {
        return edge -> !edge.faces.isEmpty() && edge.partOfGroup(1);
    }

    public boolean isModelCached();

    @Override
    public IGeomNode getGeom();
}

