/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import merlin.data.AMerlinObj;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.Opacity;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class AEgressComp
extends NamedMerlinObj
implements IEgressComp,
Serializable,
Cloneable,
ISurrogate,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<AEgressComp> PROP_TYPES = new PropertyDefs<AEgressComp>(AEgressComp.class, List.of(), MerlinData.VISIBILITY, NamedMerlinObj.NAME, MerlinData.COLOR, MerlinData.OPACITY, MerlinData.ENABLED, MerlinData.TAGS);
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Color d_color = null;
    private float d_transparency = 0.0f;
    private Set<Tag> d_tags = Collections.emptySet();

    public AEgressComp(String name) {
        super(name);
    }

    @Override
    public void restoreFrom(Object obj) {
        AEgressComp c = (AEgressComp)obj;
        this.pauseUpdates();
        this.setName(c.getSetName());
        this.setVisible(c.isVisible());
        this.setEnabled(c.isEnabled());
        this.setColor(c.getColor());
        this.setOpacity(c.getOpacity());
        this.setTags(c.getTags());
        this.resumeUpdates();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        this.d_tags = Collections.emptySet();
        in.defaultReadObject();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    private int surrogateHashCode() {
        int hash = super.surrogateHashCodeHelper();
        hash = 31 * hash + theUtil.hashCode(this.d_color);
        hash = 31 * hash + theUtil.hashCode(this.d_tags);
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        return this.surrogateEqualsHelper(comparable);
    }

    @Override
    protected boolean surrogateEqualsHelper(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AEgressComp)) {
            return false;
        }
        AEgressComp comp = (AEgressComp)obj;
        return super.surrogateEqualsHelper(comp) && theUtil.surrogateSetsEqual(this.d_tags, comp.d_tags) && Objects.equals(this.d_color, comp.d_color);
    }

    @Override
    public Collection<Pair<IEgressComp, IEgressComp.ConflictType>> getConflicts() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.d_color, color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        this.changedEvt(new Object[0]);
    }

    @Override
    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
        }
    }

    private Set<Tag> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    private void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    public Collection<AMerlinObj> getConnObjectsForEnable(MerlinData md, Supplier<MerlinDepSnapshot> deps) {
        return Collections.emptyList();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
        if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.COLOR) {
            this.setColor((Color)value);
        } else if (property == MerlinData.OPACITY) {
            this.setOpacity(((IOpacity)value).getValue());
        } else if (property == MerlinData.TAGS) {
            this.setTags((Set)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.COLOR) {
            return this.getColor();
        }
        if (property == MerlinData.OPACITY) {
            return new Opacity(this.getOpacity());
        }
        if (property == MerlinData.TAGS) {
            return this.getTags();
        }
        return NOT_SUPPORTED;
    }

    public PropertyDefs<? extends AEgressComp> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.markWrapperProps(MerlinData.ENABLED);
        TagsUtil.registerTagsDependency(PROP_TYPES);
    }
}

