/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorSort;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class Elevator
extends GeomComposite<ElevatorRoom>
implements IMerlinGeomSrc,
ISurrogate,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 2273482934324398172L;
    public static final UnitDouble DEFAULT_ELEVATOR_CALL_DIST = new UnitDouble(0.5, SI.METER);
    public static final UnitDouble DEFAULT_OPEN_DOOR_TIME = new UnitDouble(3.5, SI.SECOND);
    public static final UnitDouble DEFAULT_CLOSE_DOOR_TIME = new UnitDouble(3.5, SI.SECOND);
    public static final Object PROP_DISCHARGE_ROOM = "Elevator.DISCHARGE_ROOM";
    public static final DisplayProp<Floor> PROP_DISCHARGE_FLOOR = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.DISCHARGE_FLOOR", Floor.class, null, Intl.intl("Discharge Floor"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_OPEN_DELAY = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.OPEN_DELAY", new UnitDouble(5.0, SI.SECOND), Intl.intl("Open Delay"), Intl.intl("The minimum time an elevator door stays open on a pickup floor."), 1).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_CLOSE_DELAY = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.CLOSE_DELAY", new UnitDouble(5.0, SI.SECOND), Intl.intl("Close Delay"), Intl.intl("The door closing delay after the last occupant goes through on a pickup floor."), 1).attrMarkScenarioSupported()).attrToProp();
    public static final Object PROP_SERVABLE_FLOORS = "Elevator.SERVABLE_FLOORS";
    public static final DisplayProp<List<Floor>> PROP_FLOOR_PRIORITY = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("Elevator.FLOOR_PRIORITY", List.class, DisplayProps.emptyList(Floor.class), Intl.intl("Floor Priority"), "").attrMarkScenarioSupported()).attrFormatValue(levels -> levels == null || levels.isEmpty() ? Intl.intl("[top-down]") : levels.stream().map(Floor::getName).collect(Collectors.joining(", ")))).attrToProp();
    public static final DisplayProp<Map<Floor, LevelData>> PROP_LEVEL_DATA = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("Elevator.LEVEL_DATA", Map.class, DisplayProps.emptyMap(Floor.class, LevelData.class), Intl.intl("Level Data"), "").attrMarkScenarioSupported()).attrFormatValue(data -> data.entrySet().stream().map(level -> String.format(Intl.intl("%1$s Delay: %2$s Open+Close Time: %3$s"), ((Floor)level.getKey()).getName(), Global.format(((LevelData)level.getValue()).delay), Global.format(((LevelData)level.getValue()).openTime.add(((LevelData)level.getValue()).closeTime)))).collect(Collectors.joining("; ")))).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_NOMINAL_LOAD = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.NOMINAL_LOAD", new UnitDouble(17.0, SIUS.unit(9)), Intl.intl("Nominal Load"), Intl.intl("The approximate number of people in a full load."), 9).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Boolean> PROP_DOUBLE_DECK = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.DOUBLE_DECK", false, Intl.intl("Double-Deck"), String.format("<html>" + Intl.intl("If checked, the elevator will use two decks to transport occupants.<br>Additionally to the discharge level, the level on top of the discharge level will also be used for discharge.") + "</html>", new Object[0])).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_CALL_DISTANCE = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.CALL_DISTANCE", new UnitDouble(0.5, SI.METER), Intl.intl("Call Distance"), Intl.intl("The distance away from the elevator door at which an occupant can call the elevator."), 0).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Floor> PROP_INIT_FLOOR = ((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.INIT_FLOOR", Floor.class, null, Intl.intl("Initial Floor"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<ElevatorType> PROP_TYPE = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.TYPE", ElevatorType.class, ElevatorType.EVAC, Intl.intl("Type"), "").attrMarkScenarioSupported()).attrFormatValue(ElevatorType::getName)).attrToProp();
    public static final DisplayProp<IElevatorTimingModel> PROP_TIMING_MODEL = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"Elevator.TIMING_MODEL", IElevatorTimingModel.class, IElevatorTimingModel.DEF_MODEL, Intl.intl("Timing Model"), "").attrMarkScenarioSupported()).attrFormatValue(Object::toString)).attrToProp();
    public static final PropertyDefs<Elevator> LOCAL_PROPS = new PropertyDefs<Elevator>(Elevator.class, GeomComposite.PROP_TYPES, PROP_DISCHARGE_ROOM, PROP_DISCHARGE_FLOOR, PROP_OPEN_DELAY, PROP_CLOSE_DELAY, PROP_SERVABLE_FLOORS, PROP_LEVEL_DATA, PROP_FLOOR_PRIORITY, PROP_NOMINAL_LOAD, PROP_DOUBLE_DECK, PROP_CALL_DISTANCE, PROP_INIT_FLOOR, PROP_TYPE, PROP_TIMING_MODEL, MerlinData.TAGS);
    private static final Set<Object> ALL_PROPS = Sets.appendLHS(LOCAL_PROPS.props(), MerlinData.ENABLED);
    @SkipDep
    private Map<ElevatorRoom, LevelData> d_roomLevelData;
    @SkipDep
    private ElevatorRoom d_dischargeRoom;
    @SkipDep
    private List<ElevatorRoom> d_levelPriority;
    private IElevatorTimingModel d_timingModel;
    private UnitDouble d_openDelay;
    private UnitDouble d_closeDelay;
    private UnitDouble d_nominalLoad;
    private boolean d_doubleDeck;
    private UnitDouble d_callDistance;
    @SkipDep
    private ElevatorRoom d_initRoom;
    private ElevatorType d_type;
    private Set<Tag> d_tags;

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        LOCAL_PROPS.takeDepSnapshot(this, deps);
    }

    public Elevator(String name, ElevatorType type) {
        super(name);
        this.d_type = type;
        this.d_timingModel = IElevatorTimingModel.DEF_MODEL;
        this.d_roomLevelData = new LinkedIdentityHashMap<ElevatorRoom, LevelData>();
        this.d_openDelay = new UnitDouble(5.0, SI.SECOND);
        this.d_closeDelay = new UnitDouble(5.0, SI.SECOND);
        this.d_levelPriority = Collections.EMPTY_LIST;
        this.d_tags = new LinkedIdentityHashSet<Tag>();
        this.d_nominalLoad = null;
        this.d_doubleDeck = false;
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return CompFilter.INSTANCE;
    }

    @Override
    public Elevator getRestoreObj() {
        Elevator clone = (Elevator)super.getRestoreObj();
        clone.d_roomLevelData.putAll(this.d_roomLevelData);
        clone.d_levelPriority = this.d_levelPriority;
        clone.d_dischargeRoom = this.d_dischargeRoom;
        clone.d_initRoom = this.d_initRoom;
        clone.d_tags = this.d_tags;
        return clone;
    }

    @Override
    public Elevator clone() {
        Elevator clone = (Elevator)super.clone();
        clone.d_roomLevelData = new LinkedIdentityHashMap<ElevatorRoom, LevelData>();
        clone.d_levelPriority = Collections.EMPTY_LIST;
        clone.d_dischargeRoom = null;
        clone.d_initRoom = null;
        clone.setNominalLoad(this.d_nominalLoad);
        clone.setTags(this.d_tags);
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Elevator)) {
            return;
        }
        Elevator elev = (Elevator)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.setDischargeRoom(elev.d_dischargeRoom);
        this.setInitRoom(elev.d_initRoom);
        this.setDoorDelays(elev.d_openDelay, elev.d_closeDelay);
        this.d_levelPriority = elev.d_levelPriority;
        this.d_roomLevelData.clear();
        this.d_roomLevelData.putAll(elev.d_roomLevelData);
        this.setNominalLoad(elev.d_nominalLoad);
        this.setDoubleDeck(elev.isDoubleDeck());
        this.setCallDistance(elev.getCallDistance());
        this.setInitRoom(elev.getInitRoom());
        this.setType(elev.getType());
        this.setTimingModel(elev.getTimingModel());
        this.setTags(elev.getTags());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.writeTopology(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.readTopology(in);
        }
        if (this.d_tags == null) {
            this.d_tags = new LinkedIdentityHashSet<Tag>();
        }
    }

    @Override
    public void add(ICompElement obj) {
        if (!(obj instanceof ElevatorRoom)) {
            return;
        }
        ElevatorRoom room = (ElevatorRoom)obj;
        this.pauseUpdates();
        super.add(obj);
        if (!this.d_roomLevelData.containsKey(obj)) {
            this.setLevelData(room, this.getDefaultLevelData(room));
        }
        if (this.d_dischargeRoom == null) {
            this.setDischargeRoom((ElevatorRoom)obj);
        }
        this.resumeUpdates();
    }

    @Override
    public boolean remove(ICompElement obj) {
        this.pauseUpdates();
        boolean result = super.remove(obj);
        if (result) {
            if (obj == this.d_dischargeRoom) {
                if (!this.isEmpty()) {
                    this.setDischargeRoom((ElevatorRoom)this.getMembers().iterator().next());
                } else {
                    this.setDischargeRoom(null);
                }
            }
            if (obj == this.d_initRoom) {
                if (!this.isEmpty()) {
                    this.setInitRoom((ElevatorRoom)this.getMembers().iterator().next());
                } else {
                    this.setInitRoom(null);
                }
            }
            this.setLevelData((ElevatorRoom)obj, null);
            if (this.d_levelPriority.contains(obj)) {
                this.d_levelPriority = new ArrayList<ElevatorRoom>(this.d_levelPriority);
                this.d_levelPriority.remove(obj);
            }
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    public void clear() {
        this.d_roomLevelData.clear();
        this.d_dischargeRoom = null;
        this.d_initRoom = null;
        this.d_levelPriority = Collections.EMPTY_LIST;
        super.clear();
    }

    public ElevatorRoom getDischargeRoom() {
        return this.d_dischargeRoom;
    }

    public boolean setDischargeRoom(ElevatorRoom dischargeRoom) {
        if (dischargeRoom != null && !this.contains(dischargeRoom)) {
            return false;
        }
        this.d_dischargeRoom = dischargeRoom;
        this.changedEvt(new Object[0]);
        return true;
    }

    public boolean setDischargeFloor(Floor floor) {
        ElevatorRoom room = this.getFloorLevelMap().get(floor);
        if (room == null) {
            return false;
        }
        return this.setDischargeRoom(room);
    }

    public Floor getDischargeFloor() {
        return this.getConnectedFloor(this.getDischargeRoom());
    }

    public Floor getConnectedFloor(ElevatorRoom room) {
        if (this.getDomain() == null) {
            return null;
        }
        Floor floor = ElevatorUtil.getFloor((MerlinData)this.getDomain(), room);
        return floor;
    }

    public Map<Floor, ElevatorRoom> getFloorLevelMap() {
        LinkedIdentityHashMap<Floor, ElevatorRoom> map = new LinkedIdentityHashMap<Floor, ElevatorRoom>();
        for (ElevatorRoom er : this.getDeepMembers(ElevatorRoom.class)) {
            Floor floor = ElevatorUtil.getFloor((MerlinData)this.getDomain(), er);
            if (floor == null) continue;
            map.put(floor, er);
        }
        return map;
    }

    public void setFloorPriority(List<Floor> floors) {
        Map<Floor, ElevatorRoom> map = this.getFloorLevelMap();
        ArrayList<ElevatorRoom> levelPriority = new ArrayList<ElevatorRoom>(floors.size());
        for (Floor floor : floors) {
            ElevatorRoom er = map.get(floor);
            if (er == null) continue;
            levelPriority.add(er);
        }
        levelPriority.trimToSize();
        this.setLevelPriority(levelPriority);
    }

    public List<Floor> getFloorPriority() {
        ArrayList<Floor> floorPriority = new ArrayList<Floor>(this.d_levelPriority.size());
        for (ElevatorRoom er : this.d_levelPriority) {
            Floor floor = ElevatorUtil.getFloor((MerlinData)this.getDomain(), er);
            if (floor == null) continue;
            floorPriority.add(floor);
        }
        return floorPriority;
    }

    public Collection<Floor> getServableFloors() {
        return this.getFloorLevelMap().keySet();
    }

    public List<ElevatorRoom> getLevelPriority() {
        return Collections.unmodifiableList(this.d_levelPriority);
    }

    public void setLevelPriority(List<ElevatorRoom> priority) {
        this.d_levelPriority = priority.isEmpty() ? Collections.EMPTY_LIST : priority;
        this.changedEvt(new Object[0]);
    }

    public void setDoorDelays(UnitDouble open, UnitDouble close) {
        this.d_openDelay = open;
        this.d_closeDelay = close;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getOpenDelay() {
        return this.d_openDelay;
    }

    public UnitDouble getCloseDelay() {
        return this.d_closeDelay;
    }

    public static double getNominalLoad(UnitDouble areaUd, double szFactor) {
        double fillDens = Math.max(0.0, 3.062 * Math.pow(szFactor, -1.21));
        double area = areaUd.getValue(SIUS.unit(4));
        return Math.max(0.0, area * fillDens);
    }

    public static double getSizeFactorFromLoad(UnitDouble areaUd, double numOccs) {
        return 0.0;
    }

    public UnitDouble getNominalLoad() {
        return this.d_nominalLoad;
    }

    public void setNominalLoad(UnitDouble udNumOccs) {
        this.d_nominalLoad = new UnitDouble(udNumOccs.getValueNoUnit(), udNumOccs.getUnit());
        this.changedEvt(new Object[0]);
    }

    public void setDoubleDeck(boolean doubleDeck) {
        this.d_doubleDeck = doubleDeck;
        this.changedEvt(new Object[0]);
    }

    public boolean isDoubleDeck() {
        return this.d_doubleDeck;
    }

    public ElevatorRoom getInitRoom() {
        return this.d_initRoom;
    }

    public void setInitRoom(ElevatorRoom initRoom) {
        if (initRoom != null && !this.contains(initRoom)) {
            return;
        }
        this.d_initRoom = initRoom;
        this.changedEvt(new Object[0]);
    }

    public Floor getInitFloor() {
        return this.getInitRoom() != null ? this.getConnectedFloor(this.getInitRoom()) : null;
    }

    public void setInitFloor(Floor initFloor) {
        ElevatorRoom room = this.getFloorLevelMap().get(initFloor);
        if (room == null) {
            return;
        }
        this.setInitRoom(room);
    }

    public ElevatorType getType() {
        return this.d_type;
    }

    public void setType(ElevatorType type) {
        this.d_type = type;
        this.changedEvt(new Object[0]);
    }

    public IElevatorTimingModel getTimingModel() {
        return this.d_timingModel;
    }

    public void setTimingModel(IElevatorTimingModel model) {
        if (this.d_timingModel.equals(model)) {
            return;
        }
        this.d_timingModel = model;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getCallDistance() {
        return this.d_callDistance;
    }

    public void setCallDistance(UnitDouble udCallDist) {
        this.d_callDistance = new UnitDouble(udCallDist.getValueNoUnit(), udCallDist.getUnit());
        this.changedEvt(new Object[0]);
    }

    public LevelData getDefaultLevelData(ElevatorRoom room) {
        return new LevelData(DEFAULT_OPEN_DOOR_TIME, DEFAULT_CLOSE_DOOR_TIME, new UnitDouble(0.0, SI.SECOND));
    }

    public void setLevelData(ElevatorRoom room, LevelData data) {
        if (!this.contains(room)) {
            return;
        }
        if (data != null) {
            this.d_roomLevelData.put(room, data);
        } else {
            this.d_roomLevelData.remove(room);
        }
        this.changedEvt(new Object[0]);
    }

    public LevelData getLevelData(ElevatorRoom room) {
        return this.d_roomLevelData.get(room);
    }

    public Map<Floor, LevelData> getFloorLevelData() {
        LinkedIdentityHashMap<Floor, LevelData> ld = new LinkedIdentityHashMap<Floor, LevelData>(this.d_roomLevelData.size());
        for (Map.Entry<ElevatorRoom, LevelData> entry : this.d_roomLevelData.entrySet()) {
            Floor floor = ElevatorUtil.getFloor((MerlinData)this.getDomain(), entry.getKey());
            if (floor == null) continue;
            ld.put(floor, entry.getValue());
        }
        return ld;
    }

    public Map<ElevatorRoom, LevelData> getRoomLevelData() {
        return this.d_roomLevelData;
    }

    public void setLevelData(Map<Floor, LevelData> levelData) {
        this.pauseUpdates();
        Map<Floor, ElevatorRoom> floorMap = this.getFloorLevelMap();
        for (Map.Entry<Floor, LevelData> entry : levelData.entrySet()) {
            ElevatorRoom er = floorMap.get(entry.getKey());
            if (er == null) continue;
            this.setLevelData(er, entry.getValue());
        }
        this.resumeUpdates();
    }

    public void setTags(Set<Tag> newTags) {
        if (Objects.equals(this.d_tags, newTags)) {
            return;
        }
        this.d_tags = newTags;
        this.changedEvt(new Object[0]);
    }

    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public PropertyDefs<Elevator> getAllLocalProperties() {
        return LOCAL_PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return LOCAL_PROPS.props();
        }
        return ALL_PROPS;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == PROP_DISCHARGE_ROOM) {
            return this.getDischargeRoom();
        }
        if (property == PROP_DISCHARGE_FLOOR) {
            return this.getDischargeFloor();
        }
        if (property == PROP_OPEN_DELAY) {
            return this.getOpenDelay();
        }
        if (property == PROP_CLOSE_DELAY) {
            return this.getCloseDelay();
        }
        if (property == PROP_SERVABLE_FLOORS) {
            return this.getServableFloors();
        }
        if (property == PROP_FLOOR_PRIORITY) {
            return this.getFloorPriority();
        }
        if (property == PROP_LEVEL_DATA) {
            return this.getFloorLevelData();
        }
        if (property == PROP_NOMINAL_LOAD) {
            return this.getNominalLoad();
        }
        if (property == PROP_DOUBLE_DECK) {
            return this.isDoubleDeck();
        }
        if (property == PROP_CALL_DISTANCE) {
            return this.getCallDistance();
        }
        if (property == PROP_INIT_FLOOR) {
            return this.getInitFloor();
        }
        if (property == PROP_TYPE) {
            return this.getType();
        }
        if (property == PROP_TIMING_MODEL) {
            return this.getTimingModel();
        }
        if (property == MerlinData.TAGS) {
            return this.getTags();
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == PROP_DISCHARGE_ROOM) {
            this.setDischargeRoom((ElevatorRoom)value);
        } else if (property == PROP_DISCHARGE_FLOOR) {
            this.setDischargeFloor((Floor)value);
        } else if (property == PROP_OPEN_DELAY) {
            this.setDoorDelays((UnitDouble)value, this.d_closeDelay);
        } else if (property == PROP_CLOSE_DELAY) {
            this.setDoorDelays(this.d_openDelay, (UnitDouble)value);
        } else if (property == PROP_FLOOR_PRIORITY) {
            this.setFloorPriority((List)value);
        } else if (property == PROP_LEVEL_DATA) {
            this.setLevelData((Map)value);
        } else if (property == PROP_NOMINAL_LOAD) {
            this.setNominalLoad((UnitDouble)value);
        } else if (property == PROP_DOUBLE_DECK) {
            this.setDoubleDeck((Boolean)value);
        } else if (property == PROP_CALL_DISTANCE) {
            this.setCallDistance((UnitDouble)value);
        } else if (property == PROP_INIT_FLOOR) {
            this.setInitFloor((Floor)value);
        } else if (property == PROP_TYPE) {
            this.setType((ElevatorType)value);
        } else if (property == PROP_TIMING_MODEL) {
            this.setTimingModel((IElevatorTimingModel)value);
        } else if (property == MerlinData.TAGS) {
            this.setTags((Set)value);
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public IGeomNode getGeom() {
        Floor lastFloor;
        ArrayList<IFace> faces = new ArrayList<IFace>();
        ArrayList<ElevatorRoom> rooms = new ArrayList<ElevatorRoom>(this.getMembers(ElevatorRoom.class));
        Collections.sort(rooms, new Comparator<ElevatorRoom>(this){

            @Override
            public int compare(ElevatorRoom o1, ElevatorRoom o2) {
                return Double.compare(o1.getBounds().getMinZ(), o2.getBounds().getMinZ());
            }
        });
        for (int m = 0; m < rooms.size() - 1; ++m) {
            ElevatorRoom er1 = (ElevatorRoom)rooms.get(m);
            ElevatorRoom er2 = (ElevatorRoom)rooms.get(m + 1);
            Vector3d travelDir = Util3D.vector(er1.getBounds().getMin(), er2.getBounds().getMin());
            Elevator.getWalls(er1, travelDir, faces);
        }
        if (this.getDomain() != null && (lastFloor = ElevatorUtil.getFloor((MerlinData)this.getDomain(), (ElevatorRoom)rooms.get(rooms.size() - 1))) != null) {
            UnitDouble floorHeight;
            ElevatorRoom er = (ElevatorRoom)rooms.get(rooms.size() - 1);
            ArrayList<Floor> floors = new ArrayList<Floor>(((MerlinData)this.getDomain()).floors.getMembers(Floor.class));
            int fix = floors.indexOf(lastFloor);
            if (fix < floors.size() - 1) {
                Floor nextFloor = (Floor)floors.get(fix + 1);
                floorHeight = nextFloor.getWorkingZ().sub(lastFloor.getWorkingZ());
            } else {
                floorHeight = ((MerlinData)this.getDomain()).floorSortOptions.get(FloorSort.MIN_AUTO_FLOOR_DIST);
            }
            Vector3d extrudeDir = new Vector3d(0.0, 0.0, floorHeight.getValue(Geometry.LENGTH_UNIT));
            Elevator.getWalls(er, extrudeDir, faces);
        }
        GeomGroup geom = new GeomGroup(faces);
        return GeomNodeUtil.newNode(geom);
    }

    private static void getWalls(ElevatorRoom room, Vector3d extrudeVec, List<IFace> walls) {
        for (Edge edge : room.getModel().getEdges()) {
            if (!edge.partOfGroup(1)) continue;
            Point3d p1 = edge.curve.get(0.0);
            Point3d p2 = edge.curve.get(1.0);
            Point3d p3 = Util3D.add(p2, (Tuple3d)extrudeVec);
            Point3d p4 = Util3D.add(p1, (Tuple3d)extrudeVec);
            walls.add(new Quad(p1, p2, p3, p4));
        }
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        IPrimProps.Face fprops = new IPrimProps.Face(new Color(0.7f, 0.5f, 0.5f, 0.1f), null, 0);
        return new DisplayGeom(geom, (IPrimProps)fprops);
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box, IDisplayProps dprops) {
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
    }

    public boolean isEnabled() {
        Collection<ElevatorDoor> elDoors = this.getDeepMembers(ElevatorDoor.class);
        return elDoors.stream().anyMatch(ElevatorDoor::isEnabled);
    }

    private boolean canCompareFloors(ElevatorRoom room1, ElevatorRoom room2) {
        return room1.getDomain() != null && room2.getDomain() != null;
    }

    private int surrogateHashCode() {
        int hash = 7;
        Set<Object> props = this.getPropTypes(1);
        props.removeAll(Arrays.asList(PROP_DISCHARGE_FLOOR, PROP_INIT_FLOOR, PROP_SERVABLE_FLOORS, PROP_LEVEL_DATA));
        for (Object prop : props) {
            hash = 31 * hash + theUtil.hashCode(this.getProperty(prop));
        }
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        Elevator comparableElevator = (Elevator)comparable;
        Set<Object> props = this.getPropTypes(1);
        Predicate<Object> filter = Predicates.alwaysTrue();
        if (!this.canCompareFloors(this.d_dischargeRoom, comparableElevator.getDischargeRoom())) {
            filter = Filters.reject(PROP_DISCHARGE_FLOOR, PROP_INIT_FLOOR, PROP_SERVABLE_FLOORS, PROP_LEVEL_DATA);
        }
        return props.stream().filter(filter).allMatch(prop -> theUtil.equal(this.getProperty(prop), comparableElevator.getProperty(prop)));
    }

    public double getDist(Map<Floor, ElevatorRoom> floorMap, Floor from, Floor to) {
        if (from == to) {
            return 0.0;
        }
        ElevatorRoom fromRoom = floorMap.get(from);
        if (fromRoom == null) {
            return Double.NaN;
        }
        ElevatorRoom toRoom = floorMap.get(to);
        if (toRoom == null) {
            return Double.NaN;
        }
        return this.getDist(fromRoom, toRoom);
    }

    public double getDist(ElevatorRoom from, ElevatorRoom to) {
        if (from == to) {
            return 0.0;
        }
        Point3d fromPt = from.getBounds().getMin();
        Point3d toPt = to.getBounds().getMin();
        return fromPt.distance(toPt) * Math.signum(toPt.z - fromPt.z);
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    static {
        TagsUtil.registerTagsDependency(LOCAL_PROPS);
    }

    private static class CompFilter
    implements Predicate<ICompElement> {
        public static final CompFilter INSTANCE = new CompFilter();

        private CompFilter() {
        }

        @Override
        public boolean test(ICompElement obj) {
            if (obj instanceof ElevatorRoom) {
                ElevatorRoom er = (ElevatorRoom)obj;
                return er.getDomain() == null || ((MerlinData)er.getDomain()).hierarchy.getParent(er) == null;
            }
            return false;
        }
    }

    public static class LevelData
    implements Serializable {
        static final long serialVersionUID = 525324190123487L;
        public final UnitDouble openTime;
        public final UnitDouble closeTime;
        public final UnitDouble delay;

        public LevelData(UnitDouble openTime, UnitDouble closeTime, UnitDouble delay) {
            this.openTime = openTime;
            this.closeTime = closeTime;
            this.delay = delay;
        }

        public int hashCode() {
            return -202497206 + Objects.hash(this.openTime, this.closeTime, this.delay);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LevelData)) {
                return false;
            }
            LevelData ld = (LevelData)obj;
            return this.openTime.equals(ld.openTime) && this.closeTime.equals(ld.closeTime) && this.delay.equals(ld.delay);
        }
    }
}

