/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.function.Predicate;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TypeFilter;

public class VehicleShapeComp
extends Composite<VehicleShape> {
    static final long serialVersionUID = 1L;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(VehicleShape.class, VehicleShapeComp.class);

    public VehicleShapeComp() {
        this(Intl.intl("Vehicle Shapes"));
        this.addDefault();
    }

    public VehicleShapeComp(String name) {
        super(name);
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new VehicleShapeComp(name);
    }

    public void addDefault() {
        VehicleShape defaultWheelchair = new VehicleShape();
        defaultWheelchair.setProperty(VehicleShape.PROP_NAME, Intl.intl("Default Wheelchair"));
        defaultWheelchair.setProperty(VehicleShape.PROP_POINTS, (IPolygon)VehicleShape.PROP_POINTS_DEFAULT_WHEELCHAIR.defVal);
        defaultWheelchair.setProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS, (Point3d[])VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR.defVal);
        defaultWheelchair.setProperty(VehicleShape.PROP_ANIM_TAGS, VehicleShape.AnimType.WHEELCHAIR.tags);
        defaultWheelchair.setProperty(VehicleShape.PROP_MODEL, new ResourceAvatar("props/Wheelchair/Wheelchair.bea"));
        defaultWheelchair.setProperty(VehicleShape.PROP_ALLOW_LATERAL, Boolean.valueOf(false));
        this.add(defaultWheelchair);
        VehicleShape defaultBed = new VehicleShape();
        defaultBed.setProperty(VehicleShape.PROP_NAME, Intl.intl("Default Bed"));
        defaultBed.setProperty(VehicleShape.PROP_POINTS, (IPolygon)VehicleShape.PROP_POINTS_DEFAULT_BED_TWO_NURSES.defVal);
        defaultBed.setProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS, (Point3d[])VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES.defVal);
        defaultBed.setProperty(VehicleShape.PROP_ANIM_TAGS, VehicleShape.AnimType.BED.tags);
        defaultBed.setProperty(VehicleShape.PROP_MODEL, new ResourceAvatar("props/HospitalBed02/HospitalBed02.bea"));
        defaultBed.setProperty(VehicleShape.PROP_OCCAVATAR_OFFSET, new UnitPoint3D(-0.15, 0.0, 0.9, SI.METER));
        defaultBed.setProperty(VehicleShape.PROP_ALLOW_LATERAL, Boolean.valueOf(true));
        this.add(defaultBed);
    }

    public void loadFrom(VehicleShapeComp vShapeComp) {
        this.pauseUpdates();
        super.loadFrom(vShapeComp);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.resumeUpdates();
    }

    @Override
    public void loadFrom(Composite<VehicleShape> obj) {
        assert (obj instanceof VehicleShapeComp);
        this.loadFrom((VehicleShapeComp)obj);
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == VehicleShape.PROP_NAME) {
            return this.getName();
        }
        return super.getProperty(property);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Vehicle Shape Group");
    }
}

